package tool;

import java.beans.*;
import java.io.*;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_System_Config;

public class Tool_Cost_Analysis_Digest_IO {

	private String				filename;
	
//	private String[]			columnames;

	private ArrayList array_Cost_Analysis_Digest;
	
	private boolean blnload = false;

	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Cost_Analysis_Digest_IO(String filename){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.filename=filename;
	}

//	public void putColum(String[] columnames){
//		this.columnames = columnames;
//	}

	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			array_Cost_Analysis_Digest = new ArrayList();
			blnload = true;
			return;
		}
		

		try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 array_Cost_Analysis_Digest = (ArrayList) xml.readObject();

			 
			} catch (FileNotFoundException e) {
	 	        e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			} catch (Exception e) {
	 	        e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		xml.writeObject(array_Cost_Analysis_Digest);
		  
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	}

	
	public Object[][] getObj(){
		Struct_Cost_Analysis_Digest struct_cost_analysis_digest = new Struct_Cost_Analysis_Digest();
		
		Object[][] rtnobj = new Object[array_Cost_Analysis_Digest.size()][struct_cost_analysis_digest.getColData().length];

		for(int i = 0;i<array_Cost_Analysis_Digest.size();i++){
			
			struct_cost_analysis_digest = (Struct_Cost_Analysis_Digest) array_Cost_Analysis_Digest.get(i);
			
			rtnobj[i][0] = struct_cost_analysis_digest.getYyyymm();
			rtnobj[i][1] = struct_cost_analysis_digest.getWrite_cost();
			rtnobj[i][2] = struct_cost_analysis_digest.getRead_cost();
			rtnobj[i][3] = struct_cost_analysis_digest.getReal_cost();
			rtnobj[i][4] = struct_cost_analysis_digest.getToMe_eval();
			rtnobj[i][5] = struct_cost_analysis_digest.getToOther_eval();
			rtnobj[i][6] = struct_cost_analysis_digest.getCont_cost();
			rtnobj[i][7] = struct_cost_analysis_digest.getTotal_cost();
			rtnobj[i][8] = struct_cost_analysis_digest.getBatch_date();
			rtnobj[i][9] = struct_cost_analysis_digest.getFilename_send();
			rtnobj[i][10] = struct_cost_analysis_digest.getFilename_recieve();
		
		}
			
		return rtnobj ;
	}	
	

	public Object[][] getObj_short(){
		Struct_Cost_Analysis_Digest struct_cost_analysis_digest = new Struct_Cost_Analysis_Digest();
		
		Object[][] rtnobj = new Object[array_Cost_Analysis_Digest.size()][struct_cost_analysis_digest.getColData_short().length];

		for(int i = 0;i<array_Cost_Analysis_Digest.size();i++){
			
			struct_cost_analysis_digest = (Struct_Cost_Analysis_Digest) array_Cost_Analysis_Digest.get(i);
			
			rtnobj[i][0] = struct_cost_analysis_digest.getYyyymm();
			rtnobj[i][1] = struct_cost_analysis_digest.getWrite_cost();
			rtnobj[i][2] = struct_cost_analysis_digest.getRead_cost();
			rtnobj[i][3] = struct_cost_analysis_digest.getReal_cost();
			rtnobj[i][4] = struct_cost_analysis_digest.getToMe_eval();
			rtnobj[i][5] = struct_cost_analysis_digest.getToOther_eval();
			rtnobj[i][6] = struct_cost_analysis_digest.getCont_cost();
			rtnobj[i][7] = struct_cost_analysis_digest.getTotal_cost();
		
		}
			
		return rtnobj ;
	}	
	
	
	public ArrayList getdata(){
		if(blnload == false){
			loadXml();
		}
		return array_Cost_Analysis_Digest;
	}
	
	public int getLine(String yyyymm){
		for(int i=0;i<array_Cost_Analysis_Digest.size();i++){
			Struct_Cost_Analysis_Digest scad = (Struct_Cost_Analysis_Digest)array_Cost_Analysis_Digest.get(i); 
			if(yyyymm.equals(scad.getYyyymm())){
				return i;
			}
		}
		return -1;
	}
	public Struct_Cost_Analysis_Digest getdata(int index){
		return (Struct_Cost_Analysis_Digest)array_Cost_Analysis_Digest.get(index);
	}
	
	
	public  void insertData(Struct_Cost_Analysis_Digest struct_cost_analysis_digest){
		array_Cost_Analysis_Digest.add(0, struct_cost_analysis_digest);
		return;
	}

	public  void insertData_asc(Struct_Cost_Analysis_Digest struct_cost_analysis_digest){
		int row;
		for(row=0;row<array_Cost_Analysis_Digest.size();row++){
			Struct_Cost_Analysis_Digest scad = (Struct_Cost_Analysis_Digest)array_Cost_Analysis_Digest.get(row); 
			if( struct_cost_analysis_digest.getYyyymm_int()   >  scad.getYyyymm_int()  ){
				break;
			}
		}
		array_Cost_Analysis_Digest.add(row, struct_cost_analysis_digest);
		return;
	}
	
	public  void replaceData(int index,Struct_Cost_Analysis_Digest struct_cost_analysis_digest){
		array_Cost_Analysis_Digest.remove(index);
		array_Cost_Analysis_Digest.add(index, struct_cost_analysis_digest);
		return;
	}

	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (Exception e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
