package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_Digest;
import structure.Struct_Cost_Digest_NumberAdd;
import structure.Struct_Format_Numeric;
import structure.Struct_System_Config;

public class Tool_Cost_Digest_IO {

	String				filename;
	
	String[]			columnames;

	ArrayList<Struct_Cost_Digest> array_Cost_Digest;
//	ArrayList array_Cost_Digest;

	//番号つき
	ArrayList <Struct_Cost_Digest_NumberAdd>array_Cost_Digest_Number_add;
	
	boolean blnload = false;

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Cost_Digest_IO(String filename){
		this.filename=filename;

	
	}

	public void putColum(String[] columnames){
		this.columnames = columnames;
	}

	//初期化
	public void Initialize(){
		array_Cost_Digest = new ArrayList<Struct_Cost_Digest>();
		blnload = true;
	}
	
	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			array_Cost_Digest = new ArrayList<Struct_Cost_Digest>();
			blnload = true;
			return;
		}
		

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 array_Cost_Digest = (ArrayList) xml.readObject();

			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		xml.writeObject(array_Cost_Digest);
		  
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	}

	
	public Object[][] getObj(){
		Struct_Cost_Digest struct_cost_digest = new Struct_Cost_Digest();
		
		Object[][] rtnobj = new Object[array_Cost_Digest.size()][struct_cost_digest.getColData().length];

		for(int i = 0;i<array_Cost_Digest.size();i++){
			
			struct_cost_digest = (Struct_Cost_Digest) array_Cost_Digest.get(i);
			
			rtnobj[i][0] = struct_cost_digest.getSender();
			rtnobj[i][1] = struct_cost_digest.getSendnumber();
			rtnobj[i][2] = struct_cost_digest.getSubject();
			rtnobj[i][3] = struct_cost_digest.getSend_date();
			rtnobj[i][4] = struct_cost_digest.getSend_cost();
			rtnobj[i][5] = struct_cost_digest.getRecieve_cost();
			rtnobj[i][6] = struct_cost_digest.getTotal_cost();
			rtnobj[i][7] = struct_cost_digest.getEval_value();
			rtnobj[i][8] = struct_cost_digest.getAteval_cost();
			rtnobj[i][9] = struct_cost_digest.getUserid();
		
		}
			
		return rtnobj ;
	}	
	

	public Object[][] getObj_short(){
		Struct_Cost_Digest struct_cost_digest = new Struct_Cost_Digest();
		
		Object[][] rtnobj = new Object[array_Cost_Digest.size()][struct_cost_digest.getColData_short().length];

		for(int i = 0;i<array_Cost_Digest.size();i++){
			
			struct_cost_digest = (Struct_Cost_Digest) array_Cost_Digest.get(i);
			
			rtnobj[i][0] = struct_cost_digest.getSender();
			rtnobj[i][1] = struct_cost_digest.getSendnumber();
			rtnobj[i][2] = struct_cost_digest.getSubject();
			rtnobj[i][3] = struct_cost_digest.getSend_date();
			rtnobj[i][4] = struct_cost_digest.getSend_cost();
			rtnobj[i][5] = struct_cost_digest.getRecieve_cost();
			rtnobj[i][6] = struct_cost_digest.getTotal_cost();
			rtnobj[i][7] = struct_cost_digest.getEval_value();
			rtnobj[i][8] = struct_cost_digest.getAteval_cost();
		
		}
			
		return rtnobj ;
	}	
	
	
	public ArrayList getdata(){
		if(blnload == false){
			loadXml();
		}
		return array_Cost_Digest;
	}
	
	public int getLine(String number){
		for(int i=0;i<array_Cost_Digest.size();i++){
			Struct_Cost_Digest scd = (Struct_Cost_Digest)array_Cost_Digest.get(i); 
			if(number.equals(scd.getSendnumber())){
				return i;
			}
		}
		return -1;
	}
	public Struct_Cost_Digest getdata(int index){
		return (Struct_Cost_Digest)array_Cost_Digest.get(index);
	}
	
	
	public  void putdata(ArrayList<Struct_Cost_Digest> array_Cost_Digest){
		this.array_Cost_Digest = array_Cost_Digest;
		return;
	}

	
	public  void insertData(Struct_Cost_Digest struct_cost_digest){
		array_Cost_Digest.add(0, struct_cost_digest);
		return;
	}
	
	public  void insertLastData(Struct_Cost_Digest struct_cost_digest){
		array_Cost_Digest.add(struct_cost_digest);
		return;
	}

	public  void replaceData(int index,Struct_Cost_Digest struct_cost_digest){
		array_Cost_Digest.remove(index);
		array_Cost_Digest.add(index, struct_cost_digest);
		return;
	}

	
	
	public void Number_add_Make(){
		//表示用フォーマット変換
		Struct_Format_Numeric form_change = new Struct_Format_Numeric(); 

		
		//番号つきコストダイジェストのリストを初期化
		array_Cost_Digest_Number_add = new ArrayList<Struct_Cost_Digest_NumberAdd>();
		
		for(int i=0 ; i<array_Cost_Digest.size() ; i++){

			//コストダイジェストを取得
			Struct_Cost_Digest scd = (Struct_Cost_Digest) array_Cost_Digest.get(i);		

			//番号つきコストダイジェストの枠を作成
			Struct_Cost_Digest_NumberAdd scd_na = new Struct_Cost_Digest_NumberAdd();

			scd_na.setNumber(i+1);							// 1.番号
			scd_na.setSender(scd.getSender());				// 2.差出人
			scd_na.setSendnumber(scd.getSendnumber());		// 3.送信ナンバー
			scd_na.setSubject(scd.getSubject());			// 4.件名
			scd_na.setSend_date(scd.getSend_date());		// 5.送信日時
			
			//***************************************
			//* 6.送信コスト	
			//***************************************
			scd.getSend_cost().setMongon(
					form_change.change_format9_doble(
							scd.getSend_cost().getRealvalue()));
			scd_na.setSend_cost(scd.getSend_cost());		

			//***************************************
			//* 7.受信コスト	
			//***************************************
			scd.getRecieve_cost().setMongon(
					form_change.change_format9_doble(
							scd.getRecieve_cost().getRealvalue()));
			scd_na.setRecieve_cost(scd.getRecieve_cost());	

			//***************************************
			//* 8.総コスト
			//***************************************
			scd.getTotal_cost().setMongon(
					form_change.change_format9_doble(
							scd.getTotal_cost().getRealvalue()));
			scd_na.setTotal_cost(scd.getTotal_cost());		
			
			//***************************************
			//* 9.評価額	
			//***************************************
			scd.getEval_value().setMongon(
					form_change.change_format9_doble(
							scd.getEval_value().getRealvalue()));
			scd_na.setEval_value(scd.getEval_value());		

			//***************************************
			//*10.評価後コスト
			//***************************************
			scd.getAteval_cost().setMongon(
					form_change.change_format9_doble(
							scd.getAteval_cost().getRealvalue()));
			scd_na.setAteval_cost(scd.getAteval_cost());	

			scd_na.setUserid(scd.getUserid());				//10.（差出人）ユーザーＩＤ
			scd_na.setFilename(scd.getFilename());			//11.送信ファイル名称
		 
			array_Cost_Digest_Number_add.add(scd_na);
			
		}
		
		
	}
	public Object[][] Number_add_getObj_short(){
		Struct_Cost_Digest_NumberAdd scd_na = new Struct_Cost_Digest_NumberAdd();
		
		Object[][] rtnobj = new Object[array_Cost_Digest_Number_add.size()][scd_na.getColData_short().length];

		for(int i = 0;i<array_Cost_Digest_Number_add.size();i++){
			
			scd_na = (Struct_Cost_Digest_NumberAdd) array_Cost_Digest_Number_add.get(i);
			
			rtnobj[i][0] = scd_na.getNumber();
			rtnobj[i][1] = scd_na.getSender();
			rtnobj[i][2] = scd_na.getSendnumber();
			rtnobj[i][3] = scd_na.getSubject();
			rtnobj[i][4] = scd_na.getSend_date();
			rtnobj[i][5] = scd_na.getSend_cost();
			rtnobj[i][6] = scd_na.getRecieve_cost();
			rtnobj[i][7] = scd_na.getTotal_cost();
			rtnobj[i][8] = scd_na.getEval_value();
			rtnobj[i][9] = scd_na.getAteval_cost();
		
		}
			
		return rtnobj ;
	}		

	public ArrayList Number_add_getdata(){
		if(blnload == false){
			loadXml();
		}
		return array_Cost_Digest_Number_add;
	}

	
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
