package tool;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_Report;
import structure.Struct_System_Config;

public class Tool_Cost_Report_Calculate {

	
	ArrayList array_cost_report;
	
	int send_cost		=	0;
	int recieve_cost	=	0;
	int total_cost		=	0;
	int eval_value		=	0;
	int atvalue_cost	=	0;	

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Cost_Report_Calculate(ArrayList<Struct_Cost_Report> array_cost_report){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.array_cost_report = array_cost_report;
	}
	
	
	public void Caluculate(){
		double send_cost		=	0;
		double recieve_cost		=	0;
		double total_cost		=	0;
		double eval_value		=	0;
		double atvalue_cost		=	0;	
		
		for(int i=0;i<array_cost_report.size();i++){
			Struct_Cost_Report scr = (Struct_Cost_Report)array_cost_report.get(i);

			send_cost 		= 	send_cost		+	scr.getSend_cost().getRealvalue();
			recieve_cost	=	recieve_cost	+	scr.getRecieve_cost().getRealvalue();
			total_cost		=	total_cost		+	scr .getTotal_cost().getRealvalue();
			eval_value		=	eval_value		+	scr.getEval_value().getRealvalue();
			atvalue_cost	=	atvalue_cost	+	scr.getAteval_cost().getRealvalue();
		}
		this.send_cost 		= 	(int) send_cost;
		this.recieve_cost	=	(int) recieve_cost;
		this.total_cost		=	(int) total_cost;
		this.eval_value		=	(int) eval_value;
		this.atvalue_cost	=	(int) atvalue_cost;
	
	}


	//ゲッター
	public int getAtvalue_cost() {
		return atvalue_cost;
	}
	public int getEval_value() {
		return eval_value;
	}
	public int getRecieve_cost() {
		return recieve_cost;
	}
	public int getSend_cost() {
		return send_cost;
	}
	public int getTotal_cost() {
		return total_cost;
	}

	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	

}
