package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_SendList;
import structure.Struct_System_Config;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;


public class Tool_Cost_SendList_IO {

	String sendlistname;
	
	Struct_Cost_SendList cost_sendlist_data= new Struct_Cost_SendList();
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	//INPUT用
	public  Tool_Cost_SendList_IO(String sendlistname){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.sendlistname		= sendlistname;
	}
	
	//OUTPUT用
	public  Tool_Cost_SendList_IO(String sendlistname,Struct_Cost_SendList cost_sendlist_data){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.sendlistname		= sendlistname;
		this.cost_sendlist_data	= cost_sendlist_data;


	}
	

	public void saveXml(){
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;
		
		try {
			os  = new FileOutputStream(sendlistname);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
				
		   		xml.writeObject(cost_sendlist_data);
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			xml.close();
		}
		
	}
	
	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;
		
			try {
				is = new FileInputStream(sendlistname);
				bis = new BufferedInputStream(is);
				xml = new XMLDecoder(bis);

				cost_sendlist_data = (Struct_Cost_SendList) xml.readObject();
				
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}finally{
				xml.close();
			}
		
	}	

	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}


	//ゲッター＆セッター
	public Struct_Cost_SendList getdata() {
		return cost_sendlist_data;
	}	

	
}
