package tool;

import java.io.File;

public class Tool_DirDel {

	private File rootdir;
	private String strname;

	public Tool_DirDel(String name){
		strname = name;
	}

	public boolean delete() {
    	rootdir = new File(strname);
    	if(rootdir.exists() == false){
	    	//削除対象がない場合は、ＯＫとする。
	    	return true;
    	}
    	if(rootdir.isFile() == true){
			//普通ファイルがある
	    	rootdir.delete();
	    	return true;
    	}

    	if(rootdir.isDirectory() == false){
			//ディレクトリではない
	    	return false;
    	}

    	//再帰呼び出し＆削除
		if(recursive(rootdir) == true){
	    	if(rootdir.delete() == true){
				return true;		
	    	}else{
		    	return false;
	    	}
			
		}else{
	    	return false;
		}	
	}
	

	public boolean recursive(File dir){
		String[] contents = dir.list();
    	
    	for(int i = 0 ;i<contents.length;i++){
			File sdir = new File(dir,contents[i]);
			
    		if(sdir.isFile() == true){
    			//普通ファイルがある
    	    	sdir.delete();
    		}else if(sdir.isDirectory() == true){
    			//再帰呼び出し
    			if(recursive(sdir) == true){
    				//空ディレクトリ
        	    	sdir.delete();
    			}else{
    	   			//再帰呼び出しの結果が、false
    				return false;
    			}
    		}else{
    			//処理できないノードがある
    			return false;
   			}
    	}
    		return true;
    		
    }
		
	
}
