package tool;

import java.beans.*;
import java.io.*;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;

public class Tool_Entry_Project_IO {

	private String								filename;

	private ArrayList<Struct_Entry_Project>	array_Entry_Project;
	
	private boolean 							blnload = false;
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	public Tool_Entry_Project_IO(String filename){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.filename=filename;
	}


	//初期化
	public void Initialize(){
		array_Entry_Project = new ArrayList<Struct_Entry_Project>();
		blnload = true;
	}
	
	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			array_Entry_Project = new ArrayList<Struct_Entry_Project>();
			blnload = true;
			return;
		}
		

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 array_Entry_Project = (ArrayList<Struct_Entry_Project>) xml.readObject();

			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		xml.writeObject(array_Entry_Project);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	}

	
	public Object[][] getObj(){
		Struct_Entry_Project struct_entry_project = new Struct_Entry_Project();
		
		Object[][] rtnobj = new Object[array_Entry_Project.size()][struct_entry_project.getColData().length];

		for(int i = 0;i<array_Entry_Project.size();i++){
			
			struct_entry_project = (Struct_Entry_Project) array_Entry_Project.get(i);
			
			rtnobj[i][0] = struct_entry_project.getProject();
			rtnobj[i][1] = struct_entry_project.getLastupdate();
			rtnobj[i][2] = struct_entry_project.getIp_address();
			rtnobj[i][3] = struct_entry_project.getUserid();
		}
			
		return rtnobj ;
	}	
	

	public Object[][] getObj_short(){
		Struct_Entry_Project struct_entry_project = new Struct_Entry_Project();
		
		Object[][] rtnobj = new Object[array_Entry_Project.size()][struct_entry_project.getColData_short().length];

		for(int i = 0;i<array_Entry_Project.size();i++){
			
			struct_entry_project = (Struct_Entry_Project) array_Entry_Project.get(i);
			
			rtnobj[i][0] = struct_entry_project.getProject();
			rtnobj[i][1] = struct_entry_project.getLastupdate();
		
		}
			
		return rtnobj ;
	}	

	public String[] get_project(){
		Struct_Entry_Project struct_entry_project = new Struct_Entry_Project();
		
		String[]rtn = new String[array_Entry_Project.size()];

		for(int i = 0;i<array_Entry_Project.size();i++){
			
			struct_entry_project = (Struct_Entry_Project) array_Entry_Project.get(i);
			
			rtn[i] = struct_entry_project.getProject();
		
		}
			
		return rtn ;
	}	

	public String[] getLiveProject(){
		Struct_Entry_Project struct_entry_project = new Struct_Entry_Project();

		int deadproject = 0;
		for(int i = 0;i<array_Entry_Project.size();i++){
			if(array_Entry_Project.get(i).isKill() == true){
				deadproject++;
			}
		}
		
		//参加プロジェクトはない
		if(array_Entry_Project.size() == deadproject){
			return null;
		}
		
		String[]rtn = new String[array_Entry_Project.size()-deadproject];

		for(int i = 0;i<array_Entry_Project.size();i++){
			if(array_Entry_Project.get(i).isKill() == false){
				struct_entry_project = (Struct_Entry_Project) array_Entry_Project.get(i);
				rtn[i] = struct_entry_project.getProject();
			}
		}
			
		return rtn ;
	}	
	
	
	public ArrayList getdata(){
		if(blnload == false){
			loadXml();
		}
		return array_Entry_Project;
	}

	public void  putdata(ArrayList al){
		array_Entry_Project = al;
	}
	
	public int getLine(String project){
		for(int i=0;i<array_Entry_Project.size();i++){
			Struct_Entry_Project scd = (Struct_Entry_Project)array_Entry_Project.get(i); 
			if(project.equals(scd.getProject())){
				return i;
			}
		}
		return -1;
	}

	public Struct_Entry_Project getdata(int index){
		return (Struct_Entry_Project)array_Entry_Project.get(index);
	}
	
	
	
	public  void insertData(Struct_Entry_Project struct_entry_project){
		array_Entry_Project.add(0, struct_entry_project);
		return;
	}
	
	public  void insertLastData(Struct_Entry_Project struct_entry_project){
		array_Entry_Project.add(struct_entry_project);
		return;
	}

	public  void replaceData(int index,Struct_Entry_Project struct_entry_project){
		array_Entry_Project.remove(index);
		array_Entry_Project.add(index, struct_entry_project);
		return;
	}
	

	public String[] getProjectData(){
		if(array_Entry_Project == null || array_Entry_Project.size() == 0){
			return null;
		}
		
		String[] projectdata = new String[array_Entry_Project.size()];
		for(int i=0;i<array_Entry_Project.size();i++){
			Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i); 
			projectdata[i] = sep.getProject();
		}
		return projectdata;
	}
	
	public boolean liveProject(String project){
		if(array_Entry_Project == null || array_Entry_Project.size() == 0){
			return false;
		}
		for(int i=0;i<array_Entry_Project.size();i++){
			Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i); 
			if(sep.getProject().equals(project)){
				if(sep.isKill() ==false){
					return true;
				}else{
					return false;
				}
			}
		}
		return false;
		
	}
	
	public ArrayList getArrayProject(){
		if(blnload == false){
			loadXml();
		}
		ArrayList<String> arrayProject = new ArrayList();
		for(int i=0;i<array_Entry_Project.size();i++){
			arrayProject.add(array_Entry_Project.get(i).getProject());
		}
		
		return arrayProject;
	}
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (Exception e) {
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
