package tool;

import java.beans.*;
import java.io.*;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Eval_Rank;
import structure.Struct_System_Config;

public class Tool_Eval_Rank_IO {

	private String		filename;

	private ArrayList al;	
	
	private boolean blnload = false;

	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Eval_Rank_IO(String filename){

		this.filename=filename;
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
	}

	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			Struct_Eval_Rank 	ser	= new Struct_Eval_Rank();
			ser.setEval_rank("5");
			ser.setEval_weight(1.0);
			ser.setEval_sentence("自分の仕事に大変役立ちました");
			al = new ArrayList();
			al.add(ser);
			ser	= new Struct_Eval_Rank();
			ser.setEval_rank("4");
			ser.setEval_weight(0.8);
			ser.setEval_sentence("自分の仕事に役立ちました");
			al.add(ser);
			ser	= new Struct_Eval_Rank();
			ser.setEval_rank("3");
			ser.setEval_weight(0.6);
			ser.setEval_sentence("大変必要な情報でした");
			al.add(ser);
			ser	= new Struct_Eval_Rank();
			ser.setEval_rank("2");
			ser.setEval_weight(0.4);
			ser.setEval_sentence("必要な情報でした");
			al.add(ser);
			ser	= new Struct_Eval_Rank();
			ser.setEval_rank("1");
			ser.setEval_weight(0.2);
			ser.setEval_sentence("参考になりました");
			al.add(ser);
			ser	= new Struct_Eval_Rank();
			ser.setEval_rank("0");
			ser.setEval_weight(0.0);
			ser.setEval_sentence("次回は送らないでください");
			al.add(ser);
			blnload = true;
			return;
		}
		

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 al = (ArrayList) xml.readObject();

			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
	   		xml.writeObject(al);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	}

	
	public ArrayList getArralList(){
		if(blnload == false){
			loadXml();
		}
		return al;
	}

	public Struct_Eval_Rank getStruct_Eval_Rank(String s){
		if(blnload == false){
			loadXml();
		}

		for(int j=0;j<al.size();j++){
			Struct_Eval_Rank data = (Struct_Eval_Rank)al.get(j);
			if(data.getEval_rank().equals(s) == true){
				return data;
			}
		}
		return null;
	}
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
