package tool;

import java.io.*;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;

public class Tool_FileCopy {

	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	private Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	//infile を　outfile に　コピーする。
	public boolean Tool_FileCopy(String infile,String outfile){

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try{
			 int data;
	 	   Reader fr = new InputStreamReader(new FileInputStream(infile), "UTF-8");
	 	    //　ファイル出力ストリームを取得
	 	   Writer fw = new OutputStreamWriter(new FileOutputStream(outfile), "UTF-8");
	        while((data=fr.read())!=-1){
 	            fw.write(data);
 	        }
	        fw.close();
	        fr.close();
	    }catch(IOException ex){
			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "file copy error");
			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "infile :"+infile);
			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "outfile:"+outfile);
 	        ex.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , ex.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , ex.getStackTrace());
 	        return false;
	    }
	        return true;
 			
 	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
}
