package tool;

import java.io.File;
import java.io.FileFilter;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;

public class Tool_FileFilter implements FileFilter{

	
	String prefix = new String();
	String suffix = new String();
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public boolean accept(File pathname) {
		//接頭辞と接尾辞のチェック
		boolean prefix_swicth = true;
		boolean suffix_swicth = true;
		if( prefix == null || prefix.length() == 0 ){
			prefix_swicth = false;
		}
		if( suffix == null || suffix.length() == 0 ){
			suffix_swicth = false;
		}
		
		if( prefix_swicth  == false  &&	suffix_swicth  == false ){
			return true;
		}
		else if( prefix_swicth  == true  &&	suffix_swicth  == false ){
			if(pathname.getName().startsWith(prefix) == true ){
				return true;
			}
			return false;
		}
		else if( prefix_swicth  == false  &&	suffix_swicth  == true ){
			if(	pathname.getName().endsWith(suffix) == true){
				return true;
			}
			return false;
		}
		else if( prefix_swicth  == true  &&	suffix_swicth  == true ){
			if(pathname.getName().startsWith(prefix) == true &&
					pathname.getName().endsWith(suffix) == true){
				return true;
			}
			return false;
		}
		else{
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "File Filter error");
			return false;
		}
		
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}
	
}
