package tool;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Map;

import structure.File_and_Directory_Address;
import structure.Struct_Format_Numeric;
import structure.Struct_System_Config;

public class Tool_GetEnv {
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	//表示用フォーマット変換
	Struct_Format_Numeric form_change = new Struct_Format_Numeric(); 


	//*************************************************************************
	//*  環境変数取得ツール（デバッグ用）
	//*  ※本番では使用しない
	//*************************************************************************
	public Tool_GetEnv(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

	
	   for (Map.Entry entry: System.getenv().entrySet()) {
		      System.out.println(entry.getKey() + " / " +
		        entry.getValue());
	    }

	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}
	
}
