package tool;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.*;
import java.text.*;
import java.util.ArrayList;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

import structure.File_and_Directory_Address;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Cost_Source;
import structure.Struct_Eval_Rank;
import structure.Struct_System_Config;
import structure.Struct_Time_Count;
import structure.Struct_User;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_Eval_Rank_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Tool_Gui_PanelEvaluate extends JPanel {
	
	Struct_Eval_Rank ser;


	JRadioButton rbtn_level_5;
	JRadioButton rbtn_level_4;
	JRadioButton rbtn_level_3;
	JRadioButton rbtn_level_2;
	JRadioButton rbtn_level_1;
	JRadioButton rbtn_level_0;

	String level5	=	"5";
	String level4	=	"4";
	String level3	=	"3";
	String level2	=	"2";
	String level1	=	"1";
	String level0	=	"0";
	
	public JButton btn_OK;
	public JButton btn_Cancel;

	DecimalFormat df = new DecimalFormat("0.0");


	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	Tool_Eval_Rank_IO eval_rank = new Tool_Eval_Rank_IO(addr.getDir_current() + addr.getFile_eval_rank());


	public Tool_Gui_PanelEvaluate(String mode,
						String sendnumber,					// 4.送信番号
						String subject,						// 6.件名
						String senddate,					// 7.送信日付
						String sender						// 8.（差出人）送信者
						){
		
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
        setLayout(null);
		this.setPreferredSize(new Dimension(340, 450));


		//ラベル
		JLabel lbl1 = new JLabel();
		lbl1.setText("評価の入力");
		lbl1.setBounds(10, 10, 100, 28);
		add(lbl1);
		

		//ラベル　送信番号
		JLabel lbl2 = new JLabel();
		lbl2.setText("送信番号：");
		lbl2.setBounds(30, 40, 100, 28);
		add(lbl2);

		//ラベル　送信番号本体
		JLabel lbl3 = new JLabel();
		lbl3.setText(sendnumber);
		lbl3.setBounds(100, 40, 100, 28);
		add(lbl3);


		//ラベル　件名
		JLabel lbl4 = new JLabel();
		lbl4.setText("件名　　：");
		lbl4.setBounds(30, 60, 100, 28);
		add(lbl4);
		
		//ラベル　件名本体
		JLabel lbl5 = new JLabel();
		lbl5.setText(subject);
		lbl5.setBounds(100, 60, 400, 28);
		add(lbl5);

		
		//ラベル　送信者
		JLabel lbl8 = new JLabel();
		lbl8.setText("送信者　：");
		lbl8.setBounds(30, 80, 100, 28);
		add(lbl8);

		
		//ラベル　送信者本体
		JLabel lbl9 = new JLabel();
		lbl9.setText(sender);
		lbl9.setBounds(100, 80, 400, 28);
		add(lbl9);


		//ラベル　送信日付
		JLabel lbl6 = new JLabel();
		lbl6.setText("送信日付：");
		lbl6.setBounds(30, 100, 100, 28);
		add(lbl6);

		
		JLabel lbl7 = new JLabel();
		lbl7.setText(senddate);
		lbl7.setBounds(100, 100, 400, 28);
		add(lbl7);


		//***********************************************
		//* 評価の選択
		//***********************************************
		
		//ラジオボタン　レベル５
		ser = eval_rank.getStruct_Eval_Rank(level5);
		rbtn_level_5 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_5.setBounds(30, 140, 450, 28);
		add(rbtn_level_5);

		//ラジオボタン　レベル４
		ser = eval_rank.getStruct_Eval_Rank(level4);
		rbtn_level_4 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_4.setBounds(30, 170, 450, 28);
		add(rbtn_level_4);

		//ラジオボタン　レベル３
		ser = eval_rank.getStruct_Eval_Rank(level3);
		rbtn_level_3 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_3.setBounds(30, 200, 450, 28);
		add(rbtn_level_3);
		
		//ラジオボタン　レベル２
		ser = eval_rank.getStruct_Eval_Rank(level2);
		rbtn_level_2 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_2.setBounds(30, 230, 450, 28);
		add(rbtn_level_2);

		//ラジオボタン　レベル１
		ser = eval_rank.getStruct_Eval_Rank(level1);
		rbtn_level_1 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_1.setBounds(30, 260, 450, 28);
		add(rbtn_level_1);

		//ラジオボタン　レベル０
		ser = eval_rank.getStruct_Eval_Rank(level0);
		rbtn_level_0 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_0.setBounds(30, 290, 450, 28);
		add(rbtn_level_0);

		//ラジオボタン　グループ
		ButtonGroup group_warning = new ButtonGroup();
		group_warning.add(rbtn_level_5); 
		group_warning.add(rbtn_level_4);
		group_warning.add(rbtn_level_3); 
		group_warning.add(rbtn_level_2); 	
		group_warning.add(rbtn_level_1); 	
		group_warning.add(rbtn_level_0); 	

		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		
		if(su.getEval_rank().equals(level5)){
			rbtn_level_5.setSelected( true);
		}
		else if(su.getEval_rank().equals(level4)){
			rbtn_level_4.setSelected( true);
		}
		else if(su.getEval_rank().equals(level3)){
			rbtn_level_3.setSelected( true);
		}
		else if(su.getEval_rank().equals(level2)){
			rbtn_level_2.setSelected( true);
		}
		else if(su.getEval_rank().equals(level1)){
			rbtn_level_1.setSelected( true);
		}
		else if(su.getEval_rank().equals(level0)){
			rbtn_level_0.setSelected( true);
		}

		//余白
		add(Box.createRigidArea(new Dimension(10,10)));
		
		if(mode.equals("modal") == false){
			//確定ボタン
			btn_OK = new JButton("確定");
			btn_OK.setBounds(80, 340, 70, 50);
			add(btn_OK);

	        //取消ボタン
			btn_Cancel = new JButton("取消");
			btn_Cancel.setBounds(180, 340, 70, 50);
			add(btn_Cancel);
			
		}
		
		
	}
	
	//選択中の評価加重値を返す
	public double getEvalWeight(){
		Double weight = 0.0;
		if(rbtn_level_5.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level5);
			weight = ser.getEval_weight();
		}
		else if(rbtn_level_4.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level4);
			weight = ser.getEval_weight();
		}
		else if(rbtn_level_3.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level3);
			weight = ser.getEval_weight();
		}
		else if(rbtn_level_2.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level2);
			weight = ser.getEval_weight();
		}
		else if(rbtn_level_1.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level1);
			weight = ser.getEval_weight();
		}
		else if(rbtn_level_0.isSelected() == true){
			ser = eval_rank.getStruct_Eval_Rank(level0);
			weight = ser.getEval_weight();
		}
		return weight;
	}
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}
	
}
