package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;

import javax.swing.DefaultListModel;
import javax.swing.JList;

public class Tool_JList_IO {

	JList	 			list;
	DefaultListModel 	listModel;
	String				filename;

	public Tool_JList_IO(String filename){
		this.filename=filename;
	}
	
	public void putJList(JList list){
		this.list = list;
	}

	public DefaultListModel getDefaultListModele(){
		return listModel;
	}
	
	
	//jlistのロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);
		
		//初回は保存データがない
		if(fl.exists()==false){
			listModel = new DefaultListModel();
			return;
		}
		
		try {
			is = new FileInputStream(filename);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);

	   		Object data[] ;

	   		data = (Object[])xml.readObject();
		
			listModel = new DefaultListModel();
	        for(int i = 0;i<data.length;i++){
	        	listModel.addElement(data[i]);
	        }

//	        listModel.addElement("コミュニティ＿Ａ");
//	        listModel.addElement("コミュニティ＿Ｂ");
//	        listModel.addElement("コミュニティ＿Ｃ");
//	        listModel.addElement("コミュニティ＿Ｄ");
//	        listModel.addElement("コミュニティ＿Ｅ");
	        
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
	
	}
	
	//jListのセーブ	
	public boolean saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		DefaultListModel model = (DefaultListModel)list.getModel();
   		
	   		Object data[] =new Object[model.getSize()];
	        for(int i = 0;i<model.getSize();i++){
	        	data[i] = model.getElementAt(i);
	        }

	   		xml.writeObject(data);
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
		
	}

	public void delete(DefaultListModel delmodel){
		for(int i = 0;i<delmodel.getSize();i++){
			int j = listModel.indexOf(delmodel.get(i));
			//選択済みのコミュニティは削除する
			if(j != -1){
				listModel.remove(j);
			}
		}
		
	}
	
	//jlistのロード	
	public String[] loadXml2(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		String[] data2 =null ;

		File fl = new File(filename);
		
		//初回は保存データがない
		if(fl.exists()==false){
			listModel = new DefaultListModel();
			return null;
		}
		
		try {
			is = new FileInputStream(filename);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);

	   		Object data[] ;

	   		data = (Object[])xml.readObject();

			data2 = new String[data.length];
			
			for(int i=0;i<data.length;i++){
				data2[i] =  (String) data[i];
			}
	   		
	   		return (String[]) data2;
		
        
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
		return null;
	
	}
	
}
