package mailcost_main;


import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;
import java.util.ArrayList;

import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_System_Config;
import tool.Tool_Community_Diject_Status_Update;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Tool_JTable_IO {

	JTable	 			table;
	DefaultTableModel 	tableModel;
	String				filename;
	String[]			columnames;
	String[]			col1;
	
	Boolean				blnsubmit;
	
	int oldrow	=	-2;
	int nowrow	=	-1;
	
	String nodeproject;
	String nodecommunity;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current() +
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	
	public Tool_JTable_IO(String filename){
		setStandard();
		this.filename=filename;
	}

	public Tool_JTable_IO(String filename,String nodeproject,String nodecommunity){
		setStandard();
		this.filename=filename;
		this.nodeproject = nodeproject;
		this.nodecommunity = nodecommunity;
	}
	
	
	public void putColum(String[] columnames){
		this.columnames = columnames;
	}
	
	public void putJTable(JTable table){
		this.table = table;
	}

	public DefaultTableModel getDefaultTableModele(){
		return tableModel;
	}

	public void setTableModel(DefaultTableModel tableModel){
		this.tableModel = tableModel;
	}
	
	
	public void putData(String[] data){
		tableModel.addRow(data);
	}

	public void insertData(String[] data){
		tableModel.insertRow(0, data);
	}

	public void replaceData(int row,String[] data){
		tableModel.removeRow(row);
		tableModel.insertRow(row, data);
	}
	
	
	public String[] getData(int i){
		String[] rtn = new String[tableModel.getColumnCount()];
		for(int j = 0; j < tableModel.getColumnCount() ; j++){

			rtn[j] = tableModel.getValueAt(i, j).toString();
		}
		return rtn;
	}
	
	public int getTableCount(){
		return tableModel.getRowCount();
	}
	
	
	//jtableのロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
/*
			table =new JTable(0,columnames.length);
			TableColumn col;
			for(int i = 0;i<columnames.length;i++){
				col = table.getColumnModel().getColumn(i);
				col.setHeaderValue(columnames[i]);
			}
*/
			tableModel = new DefaultTableModel(null, columnames)
				//編集不可処理
				{public boolean isCellEditable(int row, int column) 
					{	if(blnsubmit == true){
							Message_Submit(row);
						}
						return false;
					}
				};

			return;
		}

		//読めない場合は３回リトライする
		for(int i=0 ; i<3 ;i++){
			boolean result = false;

			try {
				 is = new FileInputStream(filename);
				 bis = new BufferedInputStream(is);
				 xml = new XMLDecoder(bis);

		   		Object data[][] ;
				data = (Object[][])xml.readObject();
				
				
				tableModel = new DefaultTableModel(data, columnames)
				//編集不可処理
					{public boolean isCellEditable(int row, int column) 
						{	if(blnsubmit == true){
								Message_Submit(row);
							}
							return false;
						}
					};
				result = true;				
		   		
			} catch (FileNotFoundException e) {
				//３回目だけエラー排出する
				if(i==2){
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
				}
			//全エラーをキャッチ
			} catch (Exception e) {
				//３回目だけエラー排出する
				if(i==2){
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
				}
			}finally{
				try{
					xml.close();
				} catch(Exception e2){
					e2.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());

				}			
			}
			if(result == true){
				return;
			}
			sleep();
		}
		

	
	}
	
	//jtableのセーブ(ＪＴａｂｌｅ用)
	public boolean saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

			
		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		DefaultTableModel model = (DefaultTableModel)table.getModel();

	   		int introw = table.getRowCount();
	   		int intcol = table.getColumnCount();
	   		

			Object data[][] = new Object[introw][intcol];

	   		for( int i = 0 ;i<introw;i++){
		   		for( int j = 0 ;j<intcol;j++){
			   			data[i][j] = table.getValueAt(i, j);
//			   			System.out.println("row:"+i+" col:"+j+" data:"+table.getValueAt(i, j));

		   		}
	   		}
	   		xml.writeObject(data);
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
				return false;
			}
		}
		return true;
		
	}

	//jtableのセーブ(デフォルトモデル用)
	public boolean saveXml2(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

			
		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
   		
	   		int introw = tableModel.getRowCount();
	   		int intcol = tableModel.getColumnCount();

			Object data[][] = new Object[introw][intcol];

	   		for( int i = 0 ;i<introw;i++){
		   		for( int j = 0 ;j<intcol;j++){
			   			data[i][j] =  tableModel.getValueAt(i, j);
		   		}
	   		}
	   		xml.writeObject(data);
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
				return false;
			}
		}
		return true;
		
	}
	
	/*
	public Object getdata(int i, int j){
		if(table.getValueAt(i, j) != null){
			return table.getValueAt(i, j);
		} else{
			return null;
		}
		
	}
*/	

	//１カラム目だけを抽出する
	public String[] loadXml2(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;
		String[] data2 =null ;
		


		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			return null;
		}
		
		try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);

	   		Object data[][] ;
			
			data = (Object[][])xml.readObject();
			
			data2 = new String[data.length];
			
			for(int i=0;i<data.length;i++){
				data2[i] =  (String) data[i][0];
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	
		return data2;
	}	

	//Ｊｔｒｅｅ用のデータを作成する
	//引数１．．．対象文字列。ｎｕｌｌ値の場合は全対象
	//引数２．．．検索カラム　※０からカウント
	//引数３．．．出力カラム　※０からカウント
	public DefaultListModel loadXml3(String strkensaku,int colmnA,int colmnB){
		if(strkensaku == null){
			return loadXml3(strkensaku,0,colmnA, colmnB);
		}
		else{
			return loadXml3(strkensaku,colmnA, colmnB,-1);
		}
	}
	
	public DefaultListModel loadXml3(String strkensaku,int incolmn,int outcolmn1,int outcolmn2){
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		ArrayList data2 = new ArrayList();
		String[] data3 =null ;

		//初回は保存データがない
		if(fl.exists()==false){
			return null;
		}
		
		try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);

	   		Object data[][] ;
	   		
	   		data = (Object[][])xml.readObject();
			
			for(int i=0;i<data.length;i++){	
//				System.out.println(data[i][incolmn]);
//				System.out.println(data[i][outcolmn]);
				if(strkensaku == null || strkensaku.equals((String) data[i][incolmn])){
					if(outcolmn2 == -1){
						data2.add("["+ data[i][outcolmn1].toString()+"]");
					}
					else{
						data2.add( "["+data[i][outcolmn1].toString()+"]["+ data[i][outcolmn2].toString()+"]");
					}
				}
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	
//		data3 = new String[data2.size()];
//		for(int i=0;i<data2.size();i++){
//			data3[i] = data2.get(i);
//		}
//		return data3;

		DefaultListModel listModel = new DefaultListModel();
		
		if(data2 == null){
			return null;			
		}
		

		for(int i = 0;i<data2.size();i++){
        	listModel.addElement(data2.get(i));
        }
		return listModel;
	}		

	//(差出人)ユーザーＩＤを抽出する
	public String[] loadXmlUserid(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;
		
		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			return null;
		}
		
		String[] output = null;
		try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);

	   		Object data[][] ;
			
			data = (Object[][])xml.readObject();
			
			output = new String[data.length];
			for(int i=0;i<data.length;i++){
				output[i]=(String) data[i][6];
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	
		return output;
	}	
	
	
	
	//同じ行を２回選択した場合、メッセージを表示
	public void Message_Submit(int row){
//		System.out.println("call Message_Submit");
		oldrow = nowrow;
		nowrow = row;
		if(oldrow == nowrow){
			
			Struct_Community_Digest scd = new Struct_Community_Digest();

			//コミュニティダイジェストの取得
   			String[] columnames = scd.getColData();
   	    	Tool_JTable_IO t = new Tool_JTable_IO (filename);
   	    	t.putColum(columnames);
   	    	t.loadXml();
   	    	scd.setArryData(t.getData(row));

   	    	//未評の場合の督促
			if(scd.getStatus().equals(new Tool_Community_Diject_Status_Update().getStatus_notevaluate())){
			    String selectvalues[] = {"メールを評価する", "メールを読む","中止"};
			    int select = JOptionPane.showOptionDialog(null,
			      "選択してください", 
			      "メール表示", 
			      JOptionPane.YES_NO_OPTION,
			      JOptionPane.QUESTION_MESSAGE,
			      null, 
			      selectvalues, 
			      selectvalues[2]
			    );

			    if(select == 0){
		   			//****************************
					//* 評価の表示
					//****************************
					ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
			    			addr.getDir_current()+addr.getPgm_evaluate(),
		    				"--mode","@@@",									// 1.モード
		    				"--nodeproject",nodeproject,					// 2.ノードプロジェクト
		    				"--nodecommunity",nodecommunity,				// 3.ノードコミュニティ
		    				"--sendnumber",scd.getSendnumber(),				// 4.送信番号
		    				"--senduserid",scd.getUserid(),					// 5.（差出人）ユーザーＩＤ
		    				"--subject",scd.getSubject(),					// 6.件名
		    				"--senddate",scd.getSend_date(),				// 7.送信日付
		    				"--sender",scd.getSender(),						// 8.送信者
		    				"--recievecount",scd.getReciever_count(),		// 9.送信人数
		    				"--file",scd.getFilename(),						//10.ファイル
		    				"--sendcost",scd.getSendcost(),					//11.送信コスト
		    				"--sendnode",scd.getNode(),						//12.（差出人）ノード
		    				"--sendproject",scd.getProject(),				//13.（差出人）プロジェクト
		    				"--sendcommunity",scd.getCommunity()			//14.（差出人）コミュニティ			
					);
		    		try {
						Process process = builder.start();
					} catch (IOException e1) {
						e1.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
					}
					return;
			    }
			    else if(select == 1){
			    	//そのまま後続へ
			    }
			    else if(select == 2){
			    	return;
			    }
				
			}
   	    	
   	    	
   	    	//ファイル名作成
   	    	String file =scd.getFilename();
			int pos = filename.lastIndexOf( addr.getFs() );
//			String fl;
//			if(pos == 0){
				//ディレクトリは存在しない
//				fl = filename;
//			}else{
				//ディレクトリは存在する
//				System.out.println(filename.substring(0, pos));
//				fl = filename.substring(0, pos) + "\\" + file;
//			}
			File fle = new File(filename);
			String dir 	= fle.getParent();
			String fx	=	scd.getFilename();
			//メッセージを起動
			if(sysconfig.isTestmode() == false){
				ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
		    			addr.getDir_current()+addr.getPgm_message(),
		    				"--mode","read",								// 1.モード
		    				"--dir",dir,									// 2.ディレクトリ
		    				"--file",fx,									// 3.ファイル
		    				"--status",scd.getStatus(),						// 4.状態
		    				"--nodecommunity",nodecommunity,				// 5.ノードコミュニティ
		    				"--nodeproject",nodeproject,					// 6.ノードプロジェクト
		    				"--sendnumber",scd.getSendnumber(),				// 7.送信番号
		    				"--sender",scd.getSender(),						// 8.差出人
		    				"--senduserid",scd.getUserid(),					// 9.（差出人）ユーザーＩＤ
		    				"--sendnode",scd.getNode(),						//10.（差出人）ノード
		    				"--sendcommunity",scd.getCommunity(),			//11.（差出人）コミュニティ
		    				"--sendproject",scd.getProject(),				//12.（差出人）プロジェクト
		    				"--recievecount",scd.getReciever_count(),		//13.送信人数
		    				"--senddate",scd.getSend_date(),				//14.送信日付
		    				"--sendcost",scd.getSendcost()					//15.送信コスト			
				);
		    	try {
		    		Process process = builder.start();
		    		//ステータス　未読⇒未評に更新
		    		if(scd.getStatus().equals(new Tool_Community_Diject_Status_Update().getStatus_notread())){
			    		scd.setStatus(new Tool_Community_Diject_Status_Update().getStatus_notevaluate());
			    		t.replaceData(row, scd.getArryData());
			    		t.saveXml2();
		    		}
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
				}				

				
			}
			
		}
		
	}

	private void sleep(){
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}

	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}


	
}
