package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;
import java.util.ArrayList;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Tool_JTree_IO  {

	JTree	 			tree;
	String				filename;
	String				rootnodenm;
	
	DefaultTreeModel treemodel;
	
	//展開状態
	ArrayList  expandnodes;
	
	//選択行
	int selectionrow ;


	public Tool_JTree_IO(String filename){
		this.filename=filename;
	}

	public void putRootNode(String rootnodenm){
		this.rootnodenm = rootnodenm;
	}
	
	public void putJTree(JTree tree){
		this.tree = tree;
	}

	public DefaultTreeModel getDefaultTreeModel(){
		return treemodel;
	}
	
	
	//jtreeのロード	
	public void loadXml(){

		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			DefaultMutableTreeNode root	;
			root = new DefaultMutableTreeNode(rootnodenm);
			tree = new JTree(root);
	   		treemodel = (DefaultTreeModel)tree.getModel();
			return;
		}

		try {
			is  = new FileInputStream(filename);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);
			
			treemodel = (DefaultTreeModel)xml.readObject();

	   		//**************************************	
	   		//* 展開状態のロード
	   		//**************************************	
			expandnodes = (ArrayList)xml.readObject();
			
	   		//**************************************	
	   		//* 選択状態のロード
	   		//**************************************
			String readdata = (String)xml.readObject();
			selectionrow = Integer.valueOf(readdata).intValue();
			
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
	
	}
	public boolean projectLoadXml(){

		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			return false;
		}

		try {
			is  = new FileInputStream(filename);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);
			
			treemodel = (DefaultTreeModel)xml.readObject();
			
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
	
		return true;
		
	}	
	//jtreeのセーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
	   		xml.writeObject(model);

	   		//**************************************	
	   		//* 展開状態のセーブ
	   		//**************************************
	   		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
	   		DefaultMutableTreeNode node = root;
	   		int row_total = 0;
	   		while(true){
	   			row_total++;
	   			node = node.getNextNode();
	   			if(node == null)break;
	   		}
	   		expandnodes = new ArrayList();
	   		for(int i=0 ; i<row_total ; i++){
		   		if(tree.isExpanded(i) == true){
		   			expandnodes.add(i);
		   		}
	   		}
	   		xml.writeObject(expandnodes);
	   		
	   		//**************************************	
	   		//* 選択状態のセーブ
	   		//**************************************
	   		int[] selectionrows = tree.getSelectionRows();

	   		if(selectionrows != null && selectionrows.length > 0){
		   		xml.writeObject(String.valueOf(selectionrows[0]));
	   		}
	   		else{
		   		xml.writeObject("0");
	   		}
	   		
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
		
	}

	
	public void expandTree(JTree tree){
		if(expandnodes == null || expandnodes.size() == 0){
			return;
		}
		
   		for(int i=0 ; i<expandnodes.size() ; i++){
   			tree.expandRow(Integer.valueOf(expandnodes.get(i).toString()).intValue() );
   		}
		
	}
	
	public void selectNode(JTree tree){
		tree.setSelectionRow(selectionrow);
	}
	
}
