package tool;

import java.io.*;
import java.text.*;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;



//************************************************
//* 注意：シリアライズを削除するとエラーになる。
//************************************************
public class Tool_LogOut implements Serializable{

	private String				filename;

	private byte logmode;
	
	//ファイル＆ディレクトリ取得
	private  File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();


	public Tool_LogOut(String filename){
		
		this.filename	=	filename;
		this.logmode 	=	sysconfig.getLogmode();
	}

	
	public void out(byte mode,
						String classname,
						String msg){
		
		//モードが低い場合は出力しない
		if(logmode < mode){
			return;
		}
		
		FileOutputStream fos = null;
		BufferedWriter fp = null;
		try {
			fos = new FileOutputStream( filename , true );
		} catch (FileNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		fp = new BufferedWriter(new OutputStreamWriter(fos));

		try {
	    	//送信日付
	    	long nowtime = System.currentTimeMillis();
	    	
   	    	//送信日付のフォーマット変換
   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd HHmmss");			
   	    	fp.write (DateFormat.getDateTimeInstance().format(nowtime) +
   	    			" [" + classname + "] " + msg);
   	    	fp.newLine();
			fp.flush();
			fp.close();
			fos.flush();
			fos.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	//	例外メッセージ用
	public void out(byte mode, 
						String classname,
						java.lang.StackTraceElement[] stack){
		//モードが低い場合は出力しない
		if(logmode < mode){
			return;
		}
		
		FileOutputStream fos = null;
		BufferedWriter fp = null;
		try {
		fos = new FileOutputStream( filename , true );
		} catch (FileNotFoundException e) {
		// TODO 自動生成された catch ブロック
		e.printStackTrace();
		}
		fp = new BufferedWriter(new OutputStreamWriter(fos));

		try {
			//メッセージを展開
			for (int i=0; i<stack.length; i++){
				fp.write ("\t" + stack[i]);
				fp.newLine();
			}
			fp.flush();
			fp.close();
			fos.flush();
			fos.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	
	
	}



}
