package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;

import structure.File_and_Directory_Address;
import structure.Struct_MasterFile;
import structure.Struct_System_Config;

public class Tool_MasterFile_IO implements Serializable{
	private String 		filename;
	private Struct_MasterFile smf;
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	public Tool_MasterFile_IO(String filename){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.filename=filename;
	}

	
	
	public boolean loadXml(){
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			 smf = new Struct_MasterFile();
			 return true;
		}

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 smf = (Struct_MasterFile) xml.readObject();
			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
				return false;
			}
		}
		return true;
	}

	public boolean saveXml(){
		if(smf == null){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

			
	   		xml.writeObject(smf);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
				return false;
			}
		}
		return true;
	}

	public Struct_MasterFile getSmf() {
		return smf;
	}

	public void setSmf(Struct_MasterFile smf) {
		this.smf = smf;
	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (Exception e) {
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
