package tool;

public class Tool_Numeric_check {

	
	private String getdata;

	
	//整数桁チェック	初期値はチェックしない
	private boolean int_check 	= false;
	private byte integer_digit;
	private boolean int_err	= false;

	//少数桁チェック	初期値はチェックしない
	private boolean dec_check 	= false;
	private byte decimal_digit;
	private boolean dec_err	= false;
	
	//最大値チェック	初期値はチェックしない
	private boolean max_check 	= false;
	private float maxvalue;
	private boolean max_err	= false;

	//最小値チェック	初期値はチェックしない
	private boolean min_check	= false;
	private float minvalue;
	private boolean min_err	= false;

	public Tool_Numeric_check(String getdata){
		this.getdata = getdata;
	}

	public String integerCheck(){
		
		try {
			int a = Integer.parseInt(getdata);
			return null;
		} catch (NumberFormatException e) {
			return ("数値を入力してください");
		}	
	}

		public String floatCheck(){
		
		try {

			float a = Float.parseFloat(getdata);
		} catch (NumberFormatException e) {
//			System.out.println("例外：" + e);
//			System.out.println("引数を整数で入力してください。");
			return ("数値を入力してください");
		}
		
		String rtnmsg = optionCheck(); 
		if(rtnmsg == null){
			return null;
		}
		else{
			return rtnmsg;
			
		}
	}
	
	private String optionCheck(){

		int decimal_point = getdata.indexOf(".");

		//整数桁のみ
		if((int_check == true ) && 
				(decimal_point == -1) ) {
			//桁数チェック
			if(getdata.length() > integer_digit){
				return ("整数"+ integer_digit +"桁を越えないでください");
			}
		}
		//整数桁＋少数桁
		else{
			//整数桁チェック
			if((int_check == true ) && 
					(decimal_point > integer_digit ) ){
				return ("整数["+ integer_digit +"]桁を越えないでください");
			}
			//少数桁チェック
			if((dec_check == true) && 
					( (getdata.length() - decimal_point-1) > decimal_digit ) ){
				return ("少数["+ decimal_digit +"]桁より小さい桁を入力しないでください");
			}
		}
		float value = 	Float.valueOf(getdata);
		//ＭＡＸ値を超えた				
		if((max_check == true) && 
				(value > maxvalue) ) {
			return ("最大値["+ maxvalue +"]を越えないでください");
		}
		//ＭＩＮ値を超えた
		if((min_check == true) && 
				(value < minvalue) ) {
			return ("最小大値["+ minvalue +"]より小さい値を入力しないでください");
		}	

		return null;
	}
	
	public void setDecimal_digit(byte decimal_digit) {
		dec_check = true;
		this.decimal_digit = decimal_digit;
	}
	public void setInteger_digit(byte integer_digit) {
		int_check = true;
		this.integer_digit = integer_digit;
	}
	public void setMaxvalue(float maxvalue) {
		max_check = true;
		this.maxvalue =  maxvalue;
	}
	public void setMinvalue(float minvalue) {
		min_check = true;
		this.minvalue =  minvalue;
	}	
	
}
