package tool;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import structure.Struct_CostBar;

public class Tool_SortableTableModel extends DefaultTableModel implements TableModelListener{

	//* ソートしたあとの行の順番
	int             idxs[];
	//* ソート項目番号リスト（一つしか使ってない）
	int    sortCol;
	//* 昇順ソートの場合はTRUE
	boolean         ascend = true;
	//* 比較回数
	int comp;
	
	//* パラメータ値に関係なく、false を返します。
	public boolean isCellEditable(int row,int column)
	{
		return false;
	}
	
	//* 降順後に昇順ソートする場合のスイッチ。
	boolean switch_desc = true;
	
	//* コンストラクタ
	public Tool_SortableTableModel() {
		idxs = new int[0];
	}
	public Tool_SortableTableModel(int rowCount, int columnCount) {
		super(rowCount, columnCount);
		idxs = new int[rowCount];
		idxs_Init(rowCount);
	}
	public  Tool_SortableTableModel(Object[][] data, Object[] columnNames) {
		super(data, columnNames);
		idxs = new int[data.length];
		idxs_Init(data.length);
	}
	public Tool_SortableTableModel(Object[] columnNames, int rowCount) {
		super(columnNames, rowCount);
		idxs = new int[0];
	}
	public Tool_SortableTableModel(Vector columnNames, int rowCount) {
		super(columnNames, rowCount);
		idxs = new int[rowCount];
		idxs_Init(rowCount);
	}
	public Tool_SortableTableModel(Vector data, Vector columnNames) {
		super(data, columnNames);
		idxs = new int[data.size()];
		idxs_Init(data.size());
	}

	//*********************************************************
	//* 初期データは昇順に番号を割り当てる
	//*********************************************************
	private void idxs_Init(int rowCount){
		for(int i = 0 ; i<rowCount ; i++){
			idxs[i] = i;
		}
	}
	
	
	//*********************************************************
	//** @return row1が大きければ１、row2が大きければ-１、
	//* 同じであれば、０を返します。
	//*********************************************************
	public int compareRowsByColumn(int row1, int row2, int column) {
		Object o1 = getValueAt(row1, column, false);
		Object o2 = getValueAt(row2, column, false); 
		
		//数字かどうかチェック
		try {
			double d1 = Double.parseDouble(o1.toString());
			double d2 = Double.parseDouble(o2.toString());
			o1 = new Double(d1);
			o2 = new Double(d2);
		}
			catch (Exception e) {
		}
	
		//NULL値チェック
		if (o1 == null && o2 == null) {
			return 0; 
		} else if (o1 == null) {
			return -1; 
		} else if (o2 == null) { 
			return 1; 
		}
	
		// 数値の比較
		if (o1 instanceof Number) {
			Number n1 = (Number)o1;
			double d1 = n1.doubleValue();
			Number n2 = (Number)o2;
			double d2 = n2.doubleValue();
	
			if (d1 < d2) {
				return -1;
			} else if (d1 > d2) {
				return 1;
			} else {
				return 0;
			}
		//日付の比較
		} else if (o1 instanceof Date) {
			Date d1 = (Date)o1;
			long n1 = d1.getTime();
			Date d2 = (Date)o2;
			long n2 = d2.getTime();
	
			if (n1 < n2) {
				return -1;
			} else if (n1 > n2) {
				return 1;
			} else {
				return 0;
			}
		//文字列比較
		} else if (o1 instanceof String) {
			String s1 = (String)o1;
			String s2 = (String)o2;
			String s1e = null;
			String s2e = null;
			try {
				//データベースのソート順にあわせてEUCでソートする
				s1e = new String(s1.getBytes("EUC_JP"),"8859_1");
				s2e = new String(s2.getBytes("EUC_JP"),"8859_1");
			}
			catch (Exception e) {
			}
			int result = s1e.compareTo(s2e);
	
			if (result < 0) {
				return -1;
			} else if (result > 0) {
				return 1;
			} else {
				return 0;
			}
			//Booleanの比較
			} else if (o1 instanceof Boolean) {
				Boolean bool1 = (Boolean)o1;
			boolean b1 = bool1.booleanValue();
				Boolean bool2 = (Boolean)o2;
			boolean b2 = bool2.booleanValue();
	
			if (b1 == b2) {
				return 0;
			} else if (b1) {
				return 1;
			} else {
				return -1;
			}
			// プログレスバーの比較
			}else	if (o1 instanceof Struct_CostBar) {
				Struct_CostBar n1 = (Struct_CostBar)o1;
				double d1 = n1.getRealvalue();
				Struct_CostBar n2 = (Struct_CostBar)o2;
				double d2 = n2.getRealvalue();
		
				if (d1 < d2) {
					return -1;
				} else if (d1 > d2) {
					return 1;
				} else {
					return 0;
			}
		//その他オブジェクトhは文字列表現に任せる
		} else {
			String s1 = o1.toString();
			String s2 = o2.toString();
			int result = s1.compareTo(s2);
			
			if (result < 0) {
				return -1;
			} else if (result > 0) {
				return 1;
			} else {
				return 0;
			}
		}
	}
	
	//*********************************************************
	//* 行の比較
	//*********************************************************
	public int compare(int row1, int row2) {
		comp++;
		int result = compareRowsByColumn(row1, row2, sortCol);
		if (result != 0) {
			return ascend ? result : -result;
		}
			return 0;
		}
	
	//*********************************************************
	//* 比較結果配列のAllocate
	//*********************************************************
	public void reallocateIndexes() {
		int rowCount = getRowCount();
	
		idxs = new int[rowCount];
	
		//デフォルト値
		for (int row = 0; row < rowCount; row++) {
			idxs[row] = row;
		}
	}
	
	//*********************************************************
	//* イベント
	//*********************************************************
	public void tableChanged(TableModelEvent e) {
		reallocateIndexes();
		fireTableChanged(e);
	}
	
	//*********************************************************
	//* ソート開始
	//*********************************************************
	public void sort(Object sender) {
		comp = 0;
		shuttlesort((int[])idxs.clone(), idxs, 0, idxs.length);
	}
	
	//*********************************************************
	//* ソート
	//*********************************************************
	public void shuttlesort(int from[], int to[], int low, int high) {
		if (high - low < 2) {
			return;
		}
		int middle = (low + high)/2;
		shuttlesort(to, from, low, middle);
		shuttlesort(to, from, middle, high);
		
		int p = low;
		int q = middle;
		
		if (high - low >= 4 && compare(from[middle-1], from[middle]) <= 0) {
			for (int i = low; i < high; i++) {
				to[i] = from[i];
			}
			return;
		}
				
		for (int i = low; i < high; i++) {
			if (q >= high || (p < middle && compare(from[p], from[q]) <= 0)) {
					to[i] = from[p++];
			}
			else {
					to[i] = from[q++];
			}
		}
	}
	
	//*********************************************************
	//* スワップ
	//*********************************************************
	public void swap(int i, int j) {
		int tmp = idxs[i];
		idxs[i] = idxs[j];
		idxs[j] = tmp;
	}

	
	//*********************************************************
	//* 値の取得
	//*********************************************************
	public Object getValueAt(int aRow, int aColumn) {
		return super.getValueAt(idxs[aRow], aColumn);
	}
	
	//*********************************************************
	//* 値の取得
	//*********************************************************
	public Object getValueAt(int aRow, int aColumn, boolean sorted) {
	if (sorted == true)
		return getValueAt(aRow, aColumn);
	else
		return super.getValueAt(aRow, aColumn);
	}
	
	
	//*********************************************************
	//* 値の設定
	//*********************************************************
	public void setValueAt(Object aValue, int aRow, int aColumn) {
		super.setValueAt(aValue, idxs[aRow], aColumn);
	}
	
	//*********************************************************
	//* 行の追加
	//*********************************************************
	public void addRow(Object[] ary){
		super.addRow(ary);
		reallocateIndexes();
	}
	
	//*********************************************************
	//* ソート開始
	//*********************************************************
	public void sortByColumn(int column) {
		sortByColumn(column, true);
	}
	
	//*********************************************************
	//* ソート開始
	//*********************************************************
	public void sortByColumn(int column, boolean ascending) {
		this.ascend = ascending;
		sortCol = column;
		sort(this);
		fireTableChanged(new TableModelEvent(this)); 
	}
	
	//*********************************************************
	//* テーブルのヘッダをクリックするとソートを開始する。
	//*********************************************************
	public void addMouseListenerToHeaderInTable(JTable table) { 
		final JTable tableView = table; 
		tableView.setColumnSelectionAllowed(false); 
		//クリック時のヘッダー表示
		final DefaultTableCellRenderer columnRenderer = new DefaultTableCellRenderer() {
			public Component getTableCellRendererComponent(JTable table,
			Object value, boolean isSelected, boolean hasFocus, int row, int column)
			{
				//項目名を薄いグレー表示にする
				setBackground(Color.LIGHT_GRAY);
			   	//央寄せ
				setHorizontalAlignment(SwingConstants.CENTER);
				return super.getTableCellRendererComponent(table, value, isSelected, 
				hasFocus, row, column);
			}
		};
		//テーブルの項目名をクリックするとソートを開始する。
		MouseAdapter listMouseListener = new MouseAdapter() {
		public void mouseClicked(MouseEvent e) {
			TableColumnModel columnModel = tableView.getColumnModel();
			int viewColumn = columnModel.getColumnIndexAtX(e.getX()); 
			int column = tableView.convertColumnIndexToModel(viewColumn); 
				if (e.getClickCount() == 1 && column != -1) {
					//シフトを押すと昇順降順を入れ替える
		//			int shiftPressed = e.getModifiers()&InputEvent.SHIFT_MASK; 
		//			boolean ascending = (shiftPressed == 0); 
		//			tableView.changeSelection(0, column, false, false);
		//			sortByColumn(column, ascending); 
					//１回クリックすると昇順ソート　ただし、同じカラムを降順ソート後にクリックすると昇順ソートする　
					if(column != sortCol || switch_desc == true){
						sortByColumn(column, true); 
						switch_desc = false;
					}
					//２回クリックすると降順ソート
					else{
						sortByColumn(column, false);
						switch_desc = true;
					}
				
				}
				//クリックされた項目名をグレー表示する
				JTableHeader header = (JTableHeader)e.getSource();
				TableColumnModel colModel = header.getColumnModel();
				for (int i = 0; i < colModel.getColumnCount(); i++) {
					TableColumn tc = colModel.getColumn(i);
					if (i == column)
						tc.setHeaderRenderer(columnRenderer);
					else
						tc.setHeaderRenderer(null);
				}
					header.repaint();
				}
		};
		JTableHeader th = tableView.getTableHeader(); 
		th.addMouseListener(listMouseListener); 
	}



}
