package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;


import structure.Struct_System_Config;

public class Tool_System_Config_IO {
	
	boolean blnload = false;
	
	String				filename;
	Struct_System_Config sc;

	
	public  Tool_System_Config_IO(String filename){
		 this.filename =  filename;
	 }
	

	//ロード	
	private void loadXml(){

		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			sc = new Struct_System_Config();
			sc.init();
			blnload = true;
			return;
		}

		try {
			is  = new FileInputStream(filename);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);
			
			sc = (Struct_System_Config) xml.readObject();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
		blnload = true;
	}	
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		xml.writeObject(sc);
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
	}
	
	public Struct_System_Config getStruct_System_Config(){

		if(blnload == false){
			loadXml();
		}
		
		return sc;
	}
	
	
}
