package tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintStream;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;

public class Tool_Task {

	private String task = new String();
	

	private long last_active_time;
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	
	//コンストラクタ
	public Tool_Task(){
	}
	public Tool_Task(String task){
		this.task= task;
	}
	
	//２重起動チェック
	public boolean dualCheck(){

    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
   	
        	ff.setPrefix(task);
    	
    	File[] files = fl.listFiles(ff);
    	
    	
		if(files.length > 0){
			//２重起動あり
			return true;
		}
		//２重起動なし
		return false;
	
	}
	
	//タスク登録
	public boolean taskBorn(){
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_Task() + task + "_active");
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}

		File file = new File(addr.getDir_current() + addr.getDir_Task() + task + "_wait");
    	if(file.exists() == true){
        	file.delete();
    	}
		return true;
	
	}
/*
	//タスクの更新日付を最新状態にする
	public void taskTouch(){
    	File fl = new File(addr.getDir_current() + addr.getDir_Task() + task + "_active");
    	fl.setLastModified(System.currentTimeMillis());
   
	}
*/
	public void taskDead(){
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
   	
        	ff.setPrefix(task);
    	
    	File[] files = fl.listFiles(ff);
		for(int i=0; i<files.length; i++) {
			files[i].delete();
		}
	
	}
	
	
	
	public boolean taskWait(){
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_Task() + task + "_wait");
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + task + "_active");
    	if(file.exists() == true){
        	file.delete();
    	}
    	
		return true;

}

	
	
	//新規書き込みメッセージ専用のタスク登録
	public boolean New_dualCheck(){
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
   	
        	ff.setPrefix("new_");
    	
    	File[] files = fl.listFiles(ff);
    	
    	
		if(files.length > 0){
			//２重起動あり
			return true;
		}
		//２重起動なし
		return false;
	}
	
  	//新規書き込みメッセージ専用のタスク登録
	public boolean taskNewBorn(){
    	task = "new_active" ;
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + task);
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_Task() + task);
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		
    	task = "new_wait" ;
    	file = new File(addr.getDir_current() + addr.getDir_Task() + task);
    	if(file.exists() == true){
        	file.delete();
    	}
	
		return true;
	
	}

	public boolean taskNewWait(){
	    task = "new_wait" ;
	    File file = new File(addr.getDir_current() + addr.getDir_Task() + task);
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_Task() + task);
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		
    	task = "new_active" ;
    	file = new File(addr.getDir_current() + addr.getDir_Task() + task);
    	if(file.exists() == true){
        	file.delete();
    	}
    	
		return true;

}
	
	public void taskNewDead(){
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
   	
        ff.setPrefix("new_");
    	
    	File[] files = fl.listFiles(ff);
		for(int i=0; i<files.length; i++) {
			files[i].delete();
		}
	
	}
	

	//書き込みタスクの状態を返す
	public boolean writeTaskExec(){
		//書き込みタスクが存在して、かつアイコン化状態（＝最小化）ではない場合は、trueを返す
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + "new_active");
    	if(file.exists() == true){
    		return true;
    	}
		return false;
		
	}

	//タスク実行走数
/*
	public int xtaskExecNumbers(){
		
    	//書き込みタスクが存在して、かつアイコン化状態（＝最小化）ではない場合は、ゼロを返す
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + "new_active");
    	if(file.exists() == true){
    		return 0;
    	}

    	//自身のタスクがアイコン化状態（＝最小化）の場合は、ゼロを返す
    	file = new File(addr.getDir_current() + addr.getDir_Task() + task + "_wait");
    	if(file.exists() == true){
    		return 0;
    	}

    	//タスクの取得
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setSuffix("_active");
    	File[]  files = fl.listFiles(ff);

    	//****************************************************************************
    	//* 直近のタイマー間隔にアクションを発生させたタスクは存在するかをチェック
    	//****************************************************************************
    	setStandard();
    	
    	long last_time = System.currentTimeMillis() - sysconfig.getCost_timer();
    	last_active_time = 0;
    	for(int i=0;i<files.length ; i++){
    		//自身のファイルはアクションがあってもよい
    		if(files[i].getName().toString().equals(task + "_active")){
    			continue;
    		}

    		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "real time      =" + System.currentTimeMillis());
    		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "last time      =" + last_time);
    		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "mod  time      =" + files[i].lastModified());
    		
    		//最後のタイマーから現在までに、どれかのタスクにアクションがある場合は、コストを放棄する。
    		if(last_time < files[i].lastModified()){
    			//最初のタスクを発見
    			if(last_active_time == 0){
        			last_active_time = files[i].lastModified();
    			}
    			//２番目以降のタスクを発見した場合、一番古い更新日付に置き換える
    			else if(last_active_time > files[i].lastModified()){
        			last_active_time = files[i].lastModified();
    			}
    		}
    	}
    	
    	//読み込みタスクの走数を返す
    	return files.length;
	}
*/	
	//タスク実行走数
	public int taskExecNumbers(){
		
    	//書き込みタスクが存在して、かつアイコン化状態（＝最小化）ではない場合は、ゼロを返す
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + "new_active");
    	if(file.exists() == true){
    		return 0;
    	}

    	//自身のタスクがアイコン化状態（＝最小化）の場合は、ゼロを返す
    	file = new File(addr.getDir_current() + addr.getDir_Task() + task + "_wait");
    	if(file.exists() == true){
    		return 0;
    	}

    	//タスクの取得
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setSuffix("_active");
    	File[]  files = fl.listFiles(ff);
    	
    	//読み込みタスクの走数を返す
    	return files.length;
	}	

	
  	//割り込み専用のタスク登録
	public boolean taskWaitBorn(){
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_Task() + "wait_active");
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
	
		return true;
	
	}	
  	//割り込み専用のタスク解除
	public void taskWaitDead(){
    	File file = new File(addr.getDir_current() + addr.getDir_Task() +  "wait_active" );
    	
    	if( file.exists() == true){
			file.delete();
		}
	
	}
	//割り込みタスクの起動チェック
	public boolean taskWaitCheck(){
    	File file = new File(addr.getDir_current() + addr.getDir_Task() + "wait_active");
    	
    	if( file.exists() == true){
			return true;
		}
    	return false;
	}
	public boolean taskAllExec(){
    	//タスクの取得
    	File fl = new File(addr.getDir_current() + addr.getDir_Task());
    	File[] files = fl.listFiles();

    	if(files != null && files.length > 0)
    	{
    		//何かのタスクが起動中
    		return true;
    		
    	}
    	else{
    		//すべてのタスクが停止中
        	return false;
    	}

	}
	
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}
	public long getLast_active_time() {
		return last_active_time;
	}
	
}
