package tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.swing.JOptionPane;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;

public class Tool_Task_Socket {

	String filename = new String();
	
	int max_timer = 10;	//１０回までカウントする
	int interval  = 30;	//１回３０秒スリープする。

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	
	//コンストラクタ
	public Tool_Task_Socket(){
	}
	
	//タスク登録
	public boolean sendTaskBorn(){
    	//現在日付
    	long nowtime = System.currentTimeMillis();

    	//日付のフォーマット変換
    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
//    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
    	filename ="send_" +  dfm.format(nowtime);

		
		try{
		    FileWriter fw = new FileWriter(addr.getDir_current() + addr.getDir_task_socket() + filename);
		    fw.close();
		}catch(Exception e){	    
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}

		return true;
	
	}
	
	//タスク解除
	public void sendTaskDead(){
    	File file = new File(addr.getDir_current() + addr.getDir_task_socket() + filename);
    	if(file.exists() == true){
    		file.delete();
    	}
		
	}
	

	//最古タスクなら実行可
	//リターンコード
	//		0.強制終了
	//		1.実行待ち
	//		2.実行可
	public byte submit_Judgment(){

    	//タスクの取得
    	File fl = new File(addr.getDir_current() + addr.getDir_task_socket());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("send_");
    	File[]  files = fl.listFiles(ff);

    	if(files == null || files.length == 0){
    		return 0;
    	}
    	
    	long save_lastModified 	= 0;
    	int  save_number		= 0;
    	for(int i=0 ; i<files.length ; i++){
    		//初回
    		if(save_lastModified == 0){
    			save_lastModified = files[i].lastModified();
    			save_number = i;
    		}
    		//２回目以降
    		else if(save_lastModified > files[i].lastModified()){
    			save_lastModified = files[i].lastModified();
    			save_number = i;
    		}
    	}
    	
    	if(filename.equals(files[save_number].getName().toString()) == true){
        	return 2;
    	}
		return 1;
    	
	}	

	public boolean forceDead(){

    	//タスクの取得
    	File fl = new File(addr.getDir_current() + addr.getDir_task_socket());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("send_");
    	File[]  files = fl.listFiles(ff);

    	if(files == null || files.length == 0){
    		return true;
    	}
    	
    	long save_lastModified 	= 0;
    	int  save_number		= 0;
    	for(int i=0 ; i<files.length ; i++){
    		if(files[i].exists() == true){
        		files[i].delete();
    		}
    	}
		JOptionPane.showMessageDialog(null, "送信および送信待ちアプリケーションが終了しないため、終了状態に強制変更しました.\n" +
				"このアプリケーションの常駐プログラムが終了していない可能性があります.\n"+
				"コンピュータをシャットダウンまたはログオフしてから、起動をトライしてください", 
				"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 

    	return false;	
    	
	}		
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}

	
	//ゲッター
	public int getInterval() {
		return interval;
	}

	public int getMax_timer() {
		return max_timer;
	}
	
}
