package mailcost_main;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.TitledBorder;

import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class xxxGui_PanelProject extends JInternalFrame implements ActionListener{
	
    JPanel contentPane;
	JScrollPane src;
	JTextField tf;					//プロジェクトの入力領域
    JTable table = new JTable();	//参加プロジェクトの表示

//	Tool_JTable_IO t;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	String 	filename	= addr.getDir_current() + addr.getFile_project_info();
	
	boolean blnaction = false;		//操作時ＯＮ
	
	//画面表示なし
	public xxxGui_PanelProject(String parm){
/*
		t = new Tool_JTable_IO(filename);
		t.putColum(new Struct_Entry_Project().getColData_short());
		t.loadXml();
        DefaultTableModel model;
		model = t.getDefaultTableModele();
		table = new JTable(model);
*/
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		
		
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(filename);
		t.loadXml();
		Object[][] Objdata = t.getObj();
		DefaultTableModel tableModel ; 
		if(Objdata.length == 0){
			tableModel = new DefaultTableModel(new Struct_Entry_Project().getColData(),0);
		}
		else{
			tableModel = new DefaultTableModel(Objdata ,new Struct_Entry_Project().getColData());				
		}

	   	table.setModel(tableModel);
	
	
	}

	//画面表示あり
	public xxxGui_PanelProject(){
		
		super("プロジェクト設定",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
		setLocation(50, 50);
		setSize(550,300);
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);

        //ラベル
        JLabel lbl1 = new JLabel();
		lbl1.setText("プロジェクト");
		lbl1.setBounds(10, 10, 300, 28);
		contentPane.add(lbl1);
		
        //参加プロジェクト入力域
		tf = new JTextField();
		tf.setBorder(new TitledBorder("ホストネーム or ＩＰアドレス"));
		tf.setBounds(30, 40, 300, 50);
		contentPane.add(tf);

        //参加ボタン
		JButton btn_add = new JButton("参加");
		btn_add.setBounds(350, 40, 70, 50);
		contentPane.add(btn_add);
		btn_add.addActionListener(this);	

        //取消ボタン
		JButton btn_del = new JButton("取消");
		btn_del.setBounds(430, 40, 70, 50);
		contentPane.add(btn_del);
		btn_del.addActionListener(this);	

        //ラベル
		JLabel lbl2 = new JLabel();
		lbl2.setText("参加プロジェクト");
		lbl2.setBounds(10,110, 300, 28);
		contentPane.add(lbl2);
		
		//プロジェクトのセーブデータをロード
/*
		t = new Tool_JTable_IO(filename);
		t.putColum(new Struct_Entry_Project().getColData_short());
		t.loadXml();
        DefaultTableModel model;
		model = t.getDefaultTableModele();
		table = new JTable(model);
*/		

		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(filename);
		t.loadXml();
		Object[][] Objdata = t.getObj_short();
		DefaultTableModel tableModel ; 
		
		if(Objdata.length == 0){
			tableModel = new DefaultTableModel(new Struct_Entry_Project().getColData_short(),0);
		}
		else{
			tableModel = new DefaultTableModel(Objdata ,new Struct_Entry_Project().getColData_short());				
		}

	   	table.setModel(tableModel);		
		
		//プロジェクトを表示
		src = new JScrollPane(table);
		src.setBounds(30, 140, 400, 100);
		contentPane.add(src);
		
		this.setVisible(true);
		
		
	}
	//クローズ前処理
	public void doDefaultCloseAction() {
//        final int result = JOptionPane.showConfirmDialog
//                                       (null,"", "",JOptionPane.YES_NO_OPTION);
//        if (JOptionPane.YES_OPTION == result) {
//            super.doDefaultCloseAction();
//        }

		//操作済み
		if(blnaction==true){
//			Tool_JTable_IO t = new Tool_JTable_IO(filename);
//			t.putJTable(table);
//			t.saveXml();
		}
		
		super.doDefaultCloseAction();
    }

	public void actionPerformed(ActionEvent e) {
	    String answer = e.getActionCommand();
	    if(answer.equals("参加")){
	    	//入力値なし
	    	if(tf.getText().length() == 0) {
	    		JOptionPane.showInternalMessageDialog(this, "ホストネーム または ＩＰアドレスを入力してください。", 
	    				"プロジェクトの参加", JOptionPane.INFORMATION_MESSAGE); 
	    		return;
	    	}

	    	int introw = kenSaku();
	    	
	    	if(introw > 0){
	    		JOptionPane.showInternalMessageDialog(this, "重複するプロジェクトは登録できません。", 
	    				"プロジェクトの参加", JOptionPane.INFORMATION_MESSAGE); 
	    		return;
	    	}
	    	
	    	//プロジェクトディレクトリ作成
//	    	String strdir = "D:\\project\\" + tf.getText();
	    	String strdir = addr.getDir_current() + addr.getDir_project() + tf.getText();

	    	//念のため、過去のディレクトリを消す
	    	Tool_DirDel dirdel = new Tool_DirDel(strdir);
	    	if(dirdel.delete() == false){
	    		JOptionPane.showInternalMessageDialog(this, "過去のプロジェクトディレクトリが削除できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    		return;
	    	}
	    	
	    	File mydir = new File(strdir);
	    	if(mydir.mkdirs() == false){
	    		JOptionPane.showInternalMessageDialog(this, "プロジェクトディレクトリが作成できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    	}
	    	
	    	mydir = new File(strdir+addr.getDir_draft());
	    	if(mydir.mkdirs() == false){
	    		JOptionPane.showInternalMessageDialog(this, "ドラフトディレクトリが作成できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    	}

	    	mydir = new File(strdir+addr.getDir_send());
	    	if(mydir.mkdirs() == false){
	    		JOptionPane.showInternalMessageDialog(this, "センドディレクトリが作成できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    	}
	    	
	    	mydir = new File(strdir + addr.getFs() + addr.getDir_costrecive());
	    	if(mydir.mkdirs() == false){
	    		JOptionPane.showInternalMessageDialog(this, "レシーブディレクトリが作成できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    	}

	    	mydir = new File(strdir + addr.getFs() + addr.getDir_costsend());
	    	if(mydir.mkdirs() == false){
	    		JOptionPane.showInternalMessageDialog(this, "センドディレクトリが作成できません。", 
	    				"プロジェクトの参加", JOptionPane.ERROR_MESSAGE); 
	    	}

	    	//jtableへの追加
	    	Object[] rowdata = {tf.getText(),new Date(System.currentTimeMillis())};
	    	DefaultTableModel model;
	    	model = (DefaultTableModel)table.getModel();
	    	model.insertRow(model.getRowCount(),rowdata);

	    	//操作実施
	    	blnaction = true;
	    	
	    }
	    else if(answer.equals("取消")){
	    	//入力値なし
	    	if(tf.getText().length() == 0) {
	    		JOptionPane.showInternalMessageDialog(this, "ホストネーム または ＩＰアドレスを入力してください。", 
	    				"プロジェクトの取消", JOptionPane.INFORMATION_MESSAGE); 
	    		return;
	    	}

	    	if(table.getRowCount()==0){
	    		JOptionPane.showInternalMessageDialog(this, "プロジェクトはありません。", 
	    				"プロジェクトの取消", JOptionPane.INFORMATION_MESSAGE); 
	    		return;
	    	}
	    	
	    	//jtableの検索
	    	int introw = kenSaku();
	    	
	    	if(introw < 0){
	    		JOptionPane.showInternalMessageDialog(this, "対象のプロジェクトはありません。", 
	    				"プロジェクトの取消", JOptionPane.INFORMATION_MESSAGE); 
	    		return;
	    	}
	    	
	    	//プロジェクトディレクトリ削除
//	    	String strdir = "D:\\project\\" + tf.getText();
	    	String strdir = addr.getDir_current() + addr.getDir_project() + tf.getText();
	    	Tool_DirDel dirdel = new Tool_DirDel(strdir);
	    	if(dirdel.delete() == false){
	    		JOptionPane.showInternalMessageDialog(this, "プロジェクトディレクトリが削除できません。", 
	    				"プロジェクトの取消", JOptionPane.ERROR_MESSAGE); 
	    		return;
	    	}

	    	//jtableの削除
	        DefaultTableModel model;
	    	model = (DefaultTableModel)table.getModel();
    		model.removeRow(introw);
	    	
	    	//操作実施
	    	blnaction = true;
	    }
	}

	//最新のプロジェクトを返す
	public ArrayList getProject(){
		ArrayList arryproject = new ArrayList();		
		int rc = table.getRowCount();
		if(rc == 0){
			return arryproject;
		}
		for(int i=0;i<rc;i++){
			arryproject.add(table.getValueAt(i,0));
		}
		return arryproject;
	}
	
	private int kenSaku(){
    	for(int i=0;i<table.getRowCount();i++){
    		//マッチング
	    	String s1 = tf.getText();
	    	String s2 = table.getValueAt(i,0).toString();
	    	if(s1.equals(s2)){
				return i;
    		}
    	}
    	return -1;
	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}	

}
