package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Business_Year_days;
import structure.Struct_Session;
import beansApp.AdminBusinessYeardays_IO;
import beansApp.AdminProject_IO;

public class AdminBusinessYearDays extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameaadminbusinessyeardays");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");

	private String title = "年間営業日数の登録・変更";

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}
		
		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		//***************************************
		//* 年間営業日数ファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("business_year_daysFile");
		AdminBusinessYeardays_IO abyd = new AdminBusinessYeardays_IO();
		abyd.setFilePath(filePath);
		byte loadrtn = abyd.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_Business_Year_days[] sbyd = (Struct_Business_Year_days[])abyd.getData();
			String[] years  = new String[sbyd.length];
			String[] days   = new String[sbyd.length];
			
			for(int i=0;i<sbyd.length ; i++){
				years[i]	= String.valueOf(sbyd[i].getYear());
				days[i]		= String.valueOf(sbyd[i].getDays());
			}	

			request.setAttribute("YEARS",	years);
			request.setAttribute("DAYS" ,	days);
			request.setAttribute("MSG", "年間営業日数を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			String[] years  = new String[5];
			String[] days   = new String[5];
			for(int i=0;i<5 ; i++){
				years[i]	= new String();
				days[i]		= new String();
			}	
			request.setAttribute("YEARS",	years);
			request.setAttribute("DAYS" ,	days);
			request.setAttribute("MSG", "年間営業日数ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title );
			request.setAttribute("MSG", "年間営業日数ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			
		
	}

	//***********************************************
	//* 実行呼び出し、doPost
	//***********************************************
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}

		
		//***************************************************************************
		//* 行削除作成
		//***************************************************************************
		if(request.getParameter("delete") != null){
			String years[] 	=  request.getParameterValues("years");
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows == null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスに１件もチェックがありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			if(delrows.length == years.length){
				dataSet(request);
				request.setAttribute("MSG", "全件削除はできません。１行以上残してください");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			String days[] 	=  request.getParameterValues("days");

			//行削除チェックボックスの復元
			boolean temp_delrows[]	= new boolean[years.length];
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
				
			}
			
			//* 削除後データ域の確保
			int new_line = years.length-delrows.length;
			String new_years[] 	= new String[new_line];
			String new_days[] 	= new String[new_line];
			
			//* 削除後データの作成
			String deldata = new String();
			int datacount = 0;
			for(int i=0;i<years.length;i++){
				if(temp_delrows[i] == false){
					new_years[datacount]	=	years[i];
					new_days[datacount]		=	days[i];
					datacount++;
				}else{
					if(years[i] != null && years[i].length() > 0){
						deldata += years[i]+"<br>";
					}else{
						deldata +="---空行または役割未入力---<br>";
					}
				}
			}
			
			request.setAttribute("YEARS",	new_years);
			request.setAttribute("DAYS",	new_days);
			
			request.setAttribute("MSG", delrows.length+
								"件削除しました。削除データは以下のとおりです<br>"+
								deldata+
								"(削除を反映するには、登録・変更が必要です)");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* 空行作成
		//***************************************************************************
		else if(request.getParameter("addrows") != null){
			String years[] 	=  request.getParameterValues("years");
			String days[] 	=  request.getParameterValues("days");
			String delrows[] 	=  request.getParameterValues("delrows");
			
			if(years.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}
			
			String new_years[] 	= new String[years.length+10];
			String new_days[] 	= new String[days.length+10];
			boolean new_delrows[]	= new boolean[years.length+10];
			for(int i=0;i<years.length+10;i++){
				if(i<years.length){
					new_years[i] = years[i];
					new_days[i]  = days[i];
				}else{
					new_years[i] = new String();
					new_days[i]  = new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}
			
			request.setAttribute("YEARS",	new_years);
			request.setAttribute("DAYS",	new_days);
			request.setAttribute("DELROWS",	new_delrows);
			
			request.setAttribute("MSG", "空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* デフォルト表示
		//***************************************************************************
		else if(request.getParameter("default") != null){
			AdminBusinessYeardays_IO abyd = new AdminBusinessYeardays_IO();
			abyd.init();
			Struct_Business_Year_days[] sbyd = (Struct_Business_Year_days[])abyd.getData();
			
			String[] years  = new String[sbyd.length];
			String[] days   = new String[sbyd.length];
			
			for(int i=0;i<sbyd.length ; i++){
				years[i]	= String.valueOf(sbyd[i].getYear());
				days[i]		= String.valueOf(sbyd[i].getDays());
			}	

			request.setAttribute("YEARS",	years);
			request.setAttribute("DAYS" ,	days);
			request.setAttribute("MSG", "年間営業日数を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",title );
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************************************************
			//* 行削除チェック
			//***************************************************************************
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows != null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスにチェックがあります");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			String years[] 	=  request.getParameterValues("years");
			String days[] 	=  request.getParameterValues("days");

			//******************************************************
			//* データ有無チェック
			//******************************************************
			boolean isdata = false;
			for(int i=0;i<years.length;i++){
				//******************************************************
				//* 西暦年　ナル値チェック
				//******************************************************
				if(years[i] != null && years[i].length() > 0){
					isdata = true;
					break;
				}

				//******************************************************
				//* 営業日数　ナル値チェック
				//******************************************************
				if(days[i] != null && days[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 西暦年または営業日数のどちらかが未入力かをチェック
			//******************************************************
			int datacount = 0;
			for(int i=0;i<years.length;i++){
				boolean yearsdata = false;
				if(years[i] != null && years[i].length() > 0){
					yearsdata = true;
				}
				boolean daysdata = false;
				if(days[i] != null && days[i].length() > 0){
					daysdata = true;
				}

				if(yearsdata == true && daysdata == false ){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の営業日数が未入力です");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}
				else if(yearsdata == false && daysdata == true){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の西暦年が未入力です");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}
				else if(yearsdata == true && daysdata == true){
					datacount++;
				}
			}
			
			for(int i=0;i<years.length;i++){
				//******************************************************
				//* 西暦年　ニューメリックチェック
				//******************************************************
				int minimum = 2007;
				int maximum = 2999;
				if(years[i] == null || years[i].length() == 0){
					//データなし行は無視
					continue;
				}
				else if(numericCHK(years[i],minimum,maximum) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の西暦年に誤りがあります。入力値＝"+years[i]+"　下限値＝"+minimum+"　上限値＝"+maximum);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
				//******************************************************
				//* 営業日数　ニューメリックチェック
				//******************************************************
				minimum = 1;
				maximum = 366;
				if(days[i] == null || days[i].length() == 0){
					//データなし行は無視
					continue;
				}
				else if(numericCHK(days[i],minimum,maximum) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の営業日数に誤りがあります。入力値＝"+days[i]+"　下限値＝"+minimum+"　上限値＝"+maximum);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
			}

			//******************************************************
			//* 西暦年　重複チェック
			//******************************************************
			for(int i=0;i<years.length-1;i++){
				for(int j=i+1; j<years.length;j++){
					if(years[j] == null || years[j].length() == 0){
						//データなし行は無視
						continue;
					}
					else if(years[i].equals(years[j]) ){
						dataSet(request);
						request.setAttribute("MSG", (i+1)+"番目と"+ (j+1) + "番目の西暦年が重複しています");
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						updatemode(request,scon,session);
						return;
					}
				}
			}
			
			//********************************************************
			//* 登録・更新データの準備
			//********************************************************
			int line = 0;
			int temp1_years[] 	= new int[datacount];
			int temp1_days[] 	= new int[datacount];
			for(int i=0;i<years.length;i++){
				if(years[i] != null && years[i].length() > 0){
					temp1_years[line] = Integer.valueOf(years[i]).intValue();
					temp1_days[line] = Integer.valueOf(days[i]).intValue();
					line++;
				}
			}
			
			//* 西暦昇順
			int[] temp2_years = new int[datacount];
			int[] temp2_days  = new int[datacount];
			
			for(int i=0;i<datacount ;i++){
				temp2_years[i]= temp1_years[i];
				temp2_days[i] = temp1_days[i];
				int save = i;
				for(int j=0;j<datacount ;j++){
					if(i == j){
						continue;
					}
					else if(temp2_years[i]	 > 	temp1_years[j]	){
						temp2_years[i]= temp1_years[j];
						temp2_days[i]= temp1_days[j];

						save = j;
					}
				}
				temp1_years[save] = 9999;	
			}

			String[] new_years = new String[datacount];
			String[] new_days  = new String[datacount];
			Struct_Business_Year_days[] newdata = new Struct_Business_Year_days[datacount];
			for(int i=0;i<datacount;i++){
				newdata[i] = new Struct_Business_Year_days();
				newdata[i].setYear(temp2_years[i]);
				newdata[i].setDays(temp2_days[i]);
				new_years[i] = String.valueOf(temp2_years[i]);
				new_days[i]  = String.valueOf(temp2_days[i]);
			}
			
			//********************************************************
			//* 年間営業日数ファイルのアクセス準備
			//********************************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("business_year_daysFile");
			AdminBusinessYeardays_IO  abyd = new AdminBusinessYeardays_IO();
			abyd.setFilePath(filePath);
			abyd.setData(newdata);
			//********************************************************
			//* 年間営業日数ファイルの更新
			//********************************************************
			if(abyd.save() == false){
				request.setAttribute("TITLE",title );
				request.setAttribute("MSG", "年間営業日数の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}

			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			request.setAttribute("YEARS",	new_years);
			request.setAttribute("DAYS",	new_days);
			request.setAttribute("MSG", "年間営業日数を登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
	}
	

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("YEARS",	request.getParameterValues("years"));
		request.setAttribute("DAYS",	request.getParameterValues("days"));
		
		String delrows[] 	=  request.getParameterValues("delrows");

		//行削除チェックボックスに入力がある場合
		if(delrows != null){
			boolean temp_delrows[]	= new boolean[request.getParameterValues("years").length];

			//行削除チェックボックスの復元
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			request.setAttribute("DELROWS",	temp_delrows);			
		}
	
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;
	
	}

	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
	
	}
	
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}
	
}
