package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import structure.Struct_Business_Year_days;

public class AdminBusinessYeardays_IO {
	private String		FilePath;
	private Struct_Business_Year_days[] 	data;	

	//ロード
	//1...ロード成功
	//2...ファイルなし
	//3...ロード失敗
	public byte load(){
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 data =  (Struct_Business_Year_days[]) xml.readObject();

			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
	   		xml.writeObject(data);
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}

	public void init(){
		data = null;
		data = new Struct_Business_Year_days[5];
		data[0] = new Struct_Business_Year_days();
		data[0].setYear(2007);
		data[0].setDays(245);
		
		data[1] = new Struct_Business_Year_days();
		data[1].setYear(2008);
		data[1].setDays(245);

		data[2] = new Struct_Business_Year_days();
		data[2].setYear(2009);
		data[2].setDays(245);
		
		data[3] = new Struct_Business_Year_days();
		data[3].setYear(2010);
		data[3].setDays(245);

		data[4] = new Struct_Business_Year_days();
		data[4].setYear(2011);
		data[4].setDays(245);
		
	}

	

	
	
	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	public Struct_Business_Year_days[] getData() {
		return data;
	}

	
	public void setData(Struct_Business_Year_days[] data) {
		this.data = data;
	}

	
	
	
	
}
