package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;

import structure.Struct_Community;
import structure.Struct_Community_Menber;



public class AdminCommunityMenber_IO {

	private String 		FilePath;

//	ArrayList al;
	ArrayList<Struct_Community_Menber> al;
	
	//ロード	
	//		1...ロード成功
	//		2...ファイルなし
	//		3...ロード失敗
	
	//ロード	
	public byte load(){
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}
		

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);
		   		
	   		Object data[][] ;
	   		
	   		data = (Object[][])xml.readObject();
	   		al = new  ArrayList();
			for(int i=0;i<data.length;i++){	
				Struct_Community_Menber scd = new Struct_Community_Menber();
			
				scd.setCommunity(data[i][0].toString());
				scd.setUserid(data[i][1].toString());
				scd.setUser_fullname(data[i][2].toString());
				try {
					scd.setNode(data[i][3].toString());
				} catch (NullPointerException s) {
					//AllMenberはノードがNULLのための措置
				}
				
				al.add(scd);
			}
			 
			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
 			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
	 			return 3;
			}
		}
		return 1;
	}
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
			
			
	   		Object data[][] = new Object[al.size()][4];
			for(int i=0;i<data.length;i++){	
				data[i][0] = al.get(i).getCommunity();
				data[i][1] = al.get(i).getUserid();
				data[i][2] = al.get(i).getUser_fullname();
				if(al.get(i).getNode() != null && al.get(i).getNode().length() > 0){
					data[i][3] = al.get(i).getNode();
				}else{
					data[i][3] = new String();
				}
			}
			
			xml.writeObject(data);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				return false;
			}
		}
		return true;
	}		
	
	public ArrayList getdata(){
		return al;
	}
	public ArrayList getdata(String community){
		if(al == null || al.size() == 0){
			return null;
		}
		ArrayList dummy = new ArrayList();
		for(int i=0 ; i<al.size() ; i++){
			String data = ((Struct_Community_Menber)al.get(i)).getCommunity();
			if(data.equals(community)){
				dummy.add(al.get(i));
			}
		}
		return dummy;
	}

	public ArrayList getCommunity(String menber){
		if(al == null || al.size() == 0){
			return null;
		}
		ArrayList dummy = new ArrayList();
		for(int i=0 ; i<al.size() ; i++){
			String data = ((Struct_Community_Menber)al.get(i)).getUserid();
			if(data.equals(menber)){
				dummy.add(al.get(i));
			}
		}
		return dummy;
	}

	public  void putdata(ArrayList al){
		this.al = al;
	}

	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	
	
}
