package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_System_Config;
import beansApp.AdminConfig_IO;
import beansApp.AdminProject_IO;

public class AdminConfig extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminconfig");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "コンフィグの登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		//***************************************
		//* コンフィグフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("configFile");
		AdminConfig_IO ac = new AdminConfig_IO();
		ac.setFilePath(filePath);
		byte loadrtn = ac.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_System_Config ssc = (Struct_System_Config)ac.getData();
			
			request.setAttribute("TIMER_MAIN"	,	String.valueOf(ssc.getTimer_main()/1000));
			request.setAttribute("TIMER_SERVER"	,	String.valueOf(ssc.getTimer_server()/1000));
			request.setAttribute("TIMER_OUT"	,	String.valueOf(ssc.getTimer_out()/1000));
			request.setAttribute("COST_TIMER"	,	String.valueOf(ssc.getCost_timer()/1000));
			if(ssc.isTestmode() == true){
				request.setAttribute("TESTMODE"		,	"on");
			}
			if(ssc.isStandardmode() == true){
				request.setAttribute("STANDERDMODE"		,	"on");
			}
			request.setAttribute("PORT"			,	String.valueOf(ssc.getPort()));
			request.setAttribute("BUFFSIZE"		,	String.valueOf(ssc.getBuffsize()));
			if(ssc.isStart_relay() == true){
				request.setAttribute("START_RELAY"	,	"on");
			}
			request.setAttribute("TIMER_RELAY"		,	String.valueOf(ssc.getTimer_relay()));
			request.setAttribute("MAX_RELAY_KEEPOUT",	String.valueOf(ssc.getMax_relay_keeptime()));
			if(ssc.isEnd_server() == true){
				request.setAttribute("END_SERVER"	,	"on");
			}
			//byte⇒string変換
			request.setAttribute("LOGMODE"		,	String.valueOf(ssc.getLogmode()));			

			request.setAttribute("MSG", "コンフィグファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TIMER_MAIN"		,	new String());
			request.setAttribute("TIMER_SERVER"		,	new String());
			request.setAttribute("TIMER_OUT"		,	new String());
			request.setAttribute("COST_TIMER"		,	new String());
			request.setAttribute("PORT"				,	new String());
			request.setAttribute("BUFFSIZE"			,	new String());
			request.setAttribute("TIMER_RELAY"		,	new String());
			request.setAttribute("MAX_RELAY_KEEPOUT",	new String());
			request.setAttribute("TIMER_RELAY"		,	new String());
			request.setAttribute("LOGMODE"			,	"1");
			request.setAttribute("MSG", "コンフィグファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コンフィグファイルファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
	
	}
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		
/*		
		//全リクエストオブジェクト取得
		if(true){
			java.util.Enumeration en = request.getParameterNames();
			String msg = new String("<ul>");
	        while (en.hasMoreElements()) {
	            String name = (String)en.nextElement();
	            String values[] = request.getParameterValues(name);
	            for (int i = 0; i < values.length; i++) {
	                String value = new String(values[i].getBytes("8859_1"), "JISAutoDetect");
	                msg += "<li>" + name + "=" + value;
	            }
	            msg += "<hr>";
	        }
	        msg += "</ul><br>";;
	        msg +=  request.getAttribute("submit");
			request.setAttribute("MSG", msg);
			getServletContext().getRequestDispatcher("/servlet/frameadminconfig").forward(request, response);			
			return;
		}
*/		
		//デフォルト値表示を選択した場合
		if(request.getParameter("default") != null){
			Struct_System_Config ssc = new Struct_System_Config();
			ssc.init();

			request.setAttribute("TIMER_MAIN"	,	String.valueOf(ssc.getTimer_main()/1000));
			request.setAttribute("TIMER_SERVER"	,	String.valueOf(ssc.getTimer_server()/1000));
			request.setAttribute("TIMER_OUT"	,	String.valueOf(ssc.getTimer_out()/1000));
			request.setAttribute("COST_TIMER"	,	String.valueOf(ssc.getCost_timer()/1000));
			if(ssc.isTestmode() == true){
				request.setAttribute("TESTMODE"		,	"on");
			}
			if(ssc.isStandardmode() == true){
				request.setAttribute("STANDERDMODE"		,	"on");
			}
			request.setAttribute("PORT"			,	String.valueOf(ssc.getPort()));
			request.setAttribute("BUFFSIZE"		,	String.valueOf(ssc.getBuffsize()));
			if(ssc.isStart_relay() == true){
				request.setAttribute("START_RELAY"	,	"on");
			}
			request.setAttribute("TIMER_RELAY"		,	String.valueOf(ssc.getTimer_relay()));
			request.setAttribute("MAX_RELAY_KEEPOUT",	String.valueOf(ssc.getMax_relay_keeptime()));
			if(ssc.isEnd_server() == true){
				request.setAttribute("END_SERVER"	,	"on");
			}
			//byte⇒string変換
			request.setAttribute("LOGMODE"		,	String.valueOf(ssc.getLogmode()));			
			
			request.setAttribute("MSG", "デフォルト値を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}
		//***************************************
		//* 更新モードチェック
		//***************************************
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
										"更新モードの切り替えが必要です"	);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//******************************************************
		//* 表示タイマー　ナル値チェック
		//******************************************************
		String timer_main = (String) request.getParameter("timer_main");
		if(timer_main == null || timer_main.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "表示タイマーが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 受信サーバのタイマー　ナル値チェック
		//******************************************************
		String timer_server = (String) request.getParameter("timer_server");
		if(timer_server == null || timer_server.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "受信タイマーが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 受信タイムアウト　ナル値チェック
		//******************************************************
		String timer_out = (String) request.getParameter("timer_out");
		if(timer_out == null || timer_out.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "タイムアウトが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* コスト計算間隔　ナル値チェック
		//******************************************************
		String cost_timer = (String) request.getParameter("cost_timer");
		if(cost_timer == null || cost_timer.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "コストタイマーが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 接続元ポート　ナル値チェック
		//******************************************************
		String port = (String) request.getParameter("port");
		if(port == null || port.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "接続元ポートが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* バッファサイズ　ナル値チェック
		//******************************************************
		String buffsize = (String) request.getParameter("buffsize");
		if(buffsize == null || buffsize.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "バッファサイズが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 中継送信タイマー　ナル値チェック
		//******************************************************
		String timer_relay = (String) request.getParameter("timer_relay");
		if(timer_relay == null || timer_relay.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "中継送信タイマーが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 最大中継保持時間　ナル値チェック
		//******************************************************
		String max_relay_keeptime = (String) request.getParameter("max_relay_keeptime");
		if(max_relay_keeptime == null || max_relay_keeptime.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "最大中継保持時間が未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//***************************************
		//* 表示タイマー　ニューメリックチェック
		//***************************************
		int minimum = 5;
		int maximum = 600;
		if(numericCHK(timer_main,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "表示タイマーに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//*****************************************
		//* 受信サーバ　ニューメリックチェック
		//*****************************************
		minimum = 5;
		maximum = 600;
		if(numericCHK(timer_server,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "受信タイマーに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//******************************************
		//* 受信タイムアウト　ニューメリックチェック
		//******************************************
		minimum = 5;
		maximum = 120;
		if(numericCHK(timer_out,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "受信タイムアウトに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//*******************************************
		//* コスト計算間隔　ニューメリックチェック
		//*******************************************
		minimum = 5;
		maximum = 60;
		if(numericCHK(cost_timer,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "コストタイマーに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//********************************************
		//* 接続元ポート　ニューメリックチェック
		//********************************************
		minimum = 1025;
		maximum = 65535;
		if(numericCHK(port,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "接続元ポートに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//*******************************************
		//* バッファサイズ　ニューメリックチェック
		//*******************************************
		minimum = 1024;
		maximum = 4096;
		if(numericCHK(buffsize,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "バッファサイズに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//******************************************
		//* 中継送信タイマー　ニューメリックチェック
		//******************************************
		minimum = 1;
		maximum = 60;
		if(numericCHK(timer_relay,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "中継送信タイマーに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//*****************************************
		//* 最大中継保持時間　ニューメリックチェック
		//*****************************************
		minimum = 1;
		maximum = 4;
		if(numericCHK(max_relay_keeptime,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "最大中継保持時間に誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//****************************
		//* データ準備
		//****************************
		Struct_System_Config ssc = new Struct_System_Config();
		ssc.setTimer_main(Integer.valueOf(timer_main).intValue()*1000);
		ssc.setTimer_server(Integer.valueOf(timer_server).intValue()*1000);
		ssc.setTimer_out(Integer.valueOf(timer_out).intValue()*1000);
		ssc.setCost_timer(Integer.valueOf(cost_timer).intValue()*1000);

		if(request.getParameter("testmode").equals("test") == true){
			ssc.setTestmode(true);
		}else{
			ssc.setTestmode(false);
		}

		if(request.getParameter("standardmode").equals("yes") == true){
			ssc.setStandardmode(true);
		}else{
			ssc.setStandardmode(false);
		}
		
		ssc.setPort(Integer.valueOf(port).intValue());
		ssc.setBuffsize(Integer.valueOf(buffsize).intValue());

		if(request.getParameter("start_relay").equals("yes") == true){
			ssc.setStart_relay(true);
		}else{
			ssc.setStart_relay(false);
		}

		ssc.setTimer_relay(Integer.valueOf(timer_relay).intValue());
		ssc.setMax_relay_keeptime(Integer.valueOf(max_relay_keeptime).intValue());
		
		if(request.getParameter("end_server").equals("yes") == true){
			ssc.setEnd_server(true);
		}else{
			ssc.setEnd_server(false);
		}

		String dmymode1 = (String)request.getParameter("logmode");
		int dmymode2    = Integer.valueOf(dmymode1).intValue();
		byte logmode = new Integer(dmymode2).byteValue();
		ssc.setLogmode(logmode);

		//****************************
		//* コンフィグフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("configFile");
		AdminConfig_IO ac = new AdminConfig_IO();
		ac.setFilePath(filePath);
		ac.setData(ssc);
		
		if(ac.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コンフィグの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//****************************
		//* プロジェクトファイルの日時を更新する
		//****************************
		if(projectTimestamp(request,response,scon,session) == false){
			return;
		}
		
		dataSet(request);
		request.setAttribute("MSG", "コンフィグを登録・変更しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
	}


	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("TIMER_MAIN", 			request.getParameter("timer_main"));
		request.setAttribute("TIMER_SERVER", 		request.getParameter("timer_server"));
		request.setAttribute("TIMER_OUT", 			request.getParameter("timer_out"));
		request.setAttribute("COST_TIMER", 			request.getParameter("cost_timer"));
		
		if(request.getParameter("testmode").equals("test") == true){
			request.setAttribute("TESTMODE", 			"on");
		}
		
		if(request.getParameter("standardmode").equals("yes") == true){
			request.setAttribute("STANDERDMODE", 			"on");
		}

		request.setAttribute("PORT", 				request.getParameter("port"));
		request.setAttribute("BUFFSIZE",			request.getParameter("buffsize"));

		if(request.getParameter("start_relay").equals("yes") == true){
			request.setAttribute("START_RELAY", 			"on");
		}

		request.setAttribute("TIMER_RELAY", 		request.getParameter("timer_relay"));
		request.setAttribute("MAX_RELAY_KEEPOUT", 	request.getParameter("max_relay_keeptime"));

		if(request.getParameter("end_server").equals("yes") == true){
			request.setAttribute("END_SERVER", 			"on");
		}

		request.setAttribute("LOGMODE", request.getParameter("logmode"));
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	private boolean projectCheck(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
	throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		

		return true;

	}
	
	
	
	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);

		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			//ロードＯＫ
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
		
	}
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}


}
