package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import structure.Struct_System_Config;

public class AdminConfig_IO {

	private String 		FilePath;
	private Struct_System_Config sc;
	
	
	//ロード
	//		1...ロード成功
	//		2...ファイルなし
	//		3...ロード失敗
	public byte load(){

		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}

		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}

		try {
			is  = new FileInputStream(FilePath);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);
			
			sc = (Struct_System_Config) xml.readObject();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}	
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		xml.writeObject(sc);
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}
	
	public Struct_System_Config getData(){
		return sc;
	}
	public  void setData(Struct_System_Config ssc){
		sc = ssc;
	}

	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}
}
