package admin;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_History;
import structure.Struct_Session;
import beansApp.AdminHistory_IO;

public class AdminDistribution extends HttpServlet{
	
	private String title = "ディストリビューション ダウンロード配布ファイル作成";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}
		
		ServletConfig config =getServletConfig();		
		getServletContext().getRequestDispatcher("/servlet/frameadmindistribution").forward(request, response);			
		return;
	
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{


		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}
		
		String command = request.getParameter("command");
		
		//***************************************************************************
		//* 作成
		//***************************************************************************
		if(command.equals("execute")){
			//***************************************
			//* ヒストリーフィアルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("HistoryFile");
			AdminHistory_IO ah = new AdminHistory_IO();
			ah.setFilePath(filePath);
			ArrayList<Struct_History> data = null;;
			byte loadrtn = ah.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				data= ah.getData();
				
			}else if(loadrtn == (byte)2){
				//* ファイルなし
				
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "ヒストリーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
				return;
			}						
			String lastversion = new String();
			if(data != null && data.size()>0){
				lastversion 		= double2String_keta2(data.get(0).getVersion());
			}else{
				lastversion 		= "未作成";
			}
			
			request.setAttribute("LASTVERSION",	lastversion);
			request.setAttribute("VERSION", 	new String());
			request.setAttribute("TITLE", 		new String());
			request.setAttribute("DETAIL", 		new String());
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadmindistributionmake").forward(request, response);			
			return;	
		}
		//***************************************************************************
		//* 閲覧
		//***************************************************************************
		else if(command.equals("History")){

			//***************************************
			//* ヒストリーフィアルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("HistoryFile");
			AdminHistory_IO ah = new AdminHistory_IO();
			ah.setFilePath(filePath);
			ArrayList<Struct_History> data;
			byte loadrtn = ah.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				data= ah.getData();
				
			}else if(loadrtn == (byte)2){
				//* ファイルなし
				request.setAttribute("MSG", "ヒストリーフファイルは未作成です");
				getServletContext().getRequestDispatcher("/servlet/frameadmindistribution").forward(request, response);			
				return;
				
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "ヒストリーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
				return;
			}						
			
			String[] version = new String[data.size()];
			String[] lastupdate = new String[data.size()];
			String[] title = new String[data.size()];
			String[] detail = new String[data.size()];
			
   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
			for(int i=0;i<data.size();i++){
				version[i] 		= double2String_keta2(data.get(i).getVersion());
				lastupdate[i]	= dfm.format(data.get(i).getLastupdate());
				title[i]		= data.get(i).getTitle();
			}
			request.setAttribute("VERSION"		,	version);
			request.setAttribute("LASTUPDATE"	,	lastupdate);
			request.setAttribute("TITLE"		,	title);
			getServletContext().getRequestDispatcher("/servlet/frameadmindistributionhistorymenu").forward(request, response);			
			return;	
		}

	}
	
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	
	private String double2String_keta2(double number){
		DecimalFormat dfuc = new DecimalFormat("#0.00");
		return(dfuc.format(number));
		
	}	

}
