package admin;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_History;
import structure.Struct_Session;
import beansApp.AdminHistory_IO;

public class AdminDistributionHistoryView extends HttpServlet{
	
	private String title = "ディストリビューション ダウンロード配布ファイル作成";
	

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}

		ServletConfig config =getServletConfig();		
		
		//***************************************************************************
		//* 表示
		//***************************************************************************
		if(request.getParameter("view") != null){
			String select 	=  request.getParameter("select");
			if(select == null){
				dataSet(request);
				request.setAttribute("MSG", "選択がありません");
				getServletContext().getRequestDispatcher("/servlet/frameadmindistributionhistorymenu").forward(request, response);			
				return;				
			}

			//***************************************
			//* ヒストリーフィアルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("HistoryFile");
			AdminHistory_IO ah = new AdminHistory_IO();
			ah.setFilePath(filePath);
			ArrayList<Struct_History> data;
			byte loadrtn = ah.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				data= ah.getData();
				
			}else if(loadrtn == (byte)2){
				request.setAttribute("TITLE", title );
				request.setAttribute("MSG", "ヒストリーファイルのロードは未作成です");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE", title );
				request.setAttribute("MSG", "ヒストリーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
				return;
			}			
			
			double versiondbl = Double.valueOf(request.getParameter("version")).doubleValue();

			String version 		= new String();
			String title		= new String();
			String detail		= new String();
			String lastupdate	= new String();
			
   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
			
			for(int i=0;i<data.size();i++){
				if(versiondbl == data.get(i).getVersion()){
					version 	= double2String_keta2(data.get(i).getVersion());
					title		= data.get(i).getTitle();
					detail		= data.get(i).getDetail();
					lastupdate	= dfm.format(data.get(i).getLastupdate());
					break;
				}
			}
				
			request.setAttribute("VERSION"		,	version);
			request.setAttribute("TITLE"		,	title);
			request.setAttribute("DETAIL"		,	detail);
			request.setAttribute("LASTUPDATE"	,	lastupdate);
			
			request.setAttribute("MSG", "ヒストリーファイルを表示しました");
			getServletContext().getRequestDispatcher("/servlet/frameadmindistributionhistory").forward(request, response);			
			return;			
		}
		//***************************************************************************
		//* メニュー
		//***************************************************************************
		else if(request.getParameter("menu")  != null){
			getServletContext().getRequestDispatcher("/servlet/frameadmindistribution").forward(request, response);			
			return;	
		}

	}
	
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("VERSION"		,request.getParameterValues("version"));
		request.setAttribute("LASTUPDATE"	,request.getParameterValues("lastupdate"));
		request.setAttribute("TITLE"		,request.getParameterValues("title"));
	
	}
	
	private String double2String_keta2(double number){
		DecimalFormat dfuc = new DecimalFormat("#0.00");
		return(dfuc.format(number));
		
	}	
	
}
