package admin;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.File_Separator;
import structure.Struct_History;
import structure.Struct_Session;
import tool.Tool_DirDel;
import tool.Tool_FileCopy;
import beansApp.AdminHistory_IO;
import beansApp.AdminProject_IO;

public class AdminDistributionMake extends HttpServlet{
	private String urlbackward 	= new String("/servlet/frameadmindistribution");
	private String urlfoward 		= new String("/servlet/frameadmindistributionmake");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "ディストリビューション ダウンロード配布ファイル作成";
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}
		
//		ServletConfig config =getServletConfig();
		
		//***************************************************************************
		//* 作成
		//***************************************************************************
		if(request.getParameter("execute") != null){
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE", title );
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}

			//******************************************************
			//* バージョン　ナル値チェック
			//******************************************************
			String version = (String) request.getParameter("version");
			if(version == null || version.length() == 0){
				dataSet(request);
				request.setAttribute("MSG", "バージョンが未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}

			//******************************************************
			//* タイトル　ナル値チェック
			//******************************************************
			String title = (String) request.getParameter("title");
			if(title == null || title.length() == 0){
				dataSet(request);
				request.setAttribute("MSG", "タイトルが未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}

			
			//******************************************************
			//* バージョン　ニューメリックチェック
			//******************************************************
			double minimum = 1.0;
			double maximum = 9999.0;
			byte keta		=	2;
			if(smallnumberCHK(version,minimum,maximum,keta) == false){
				dataSet(request);
				request.setAttribute("MSG", "バージョンに誤りがあります。 バージョン＝"+version+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double versiondbl = Double.valueOf(version).doubleValue();
			
			//******************************************************
			//* 概要　容量チェック
			//******************************************************
			String detail = (String) request.getParameter("detail");
			if(detail != null && detail.length() > 500){
				dataSet(request);
				request.setAttribute("MSG", "概要は半角500文字まで入力可能です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}

			//***************************************
			//* ヒストリーフィアルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("HistoryFile");
			AdminHistory_IO ah = new AdminHistory_IO();
			ah.setFilePath(filePath);
			ArrayList<Struct_History> data;
			byte loadrtn = ah.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				data= ah.getData();
				
			}else if(loadrtn == (byte)2){
				//* ファイルなし
				data= new ArrayList();
			}else{
				//* ロード失敗
				request.setAttribute("TITLE", title );
				request.setAttribute("MSG", "ヒストリーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			
			
			if(data.size() > 0){
				//******************************************************
				//* バージョン　チェック
				//******************************************************
				if(data.get(0).getVersion() >= versiondbl){
					dataSet(request);
					request.setAttribute("MSG", "バージョンを戻すことはできません<br>最新バージョン＝"+data.get(0).getVersion());
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
			}
			//ファイル有無チェック
			if(fileCheck(scon,session,request,response) == false){
				return;
			}


			//#0.00に正規化	
			version = double2String_keta2(versiondbl);
			//本体作成
			if(bodyMake(scon,session,request,response,version) == false){
				return;
			}
			
			//３世代は残す
			if(data.size()>4){
				generationManagement(scon,data);
			}
			
			//更新データ準備
			Struct_History sh = new Struct_History();
			sh.setVersion(versiondbl);
			sh.setLastupdate(System.currentTimeMillis());
			sh.setTitle(title);

			if(detail != null){
				sh.setDetail(detail);
			}else{
				sh.setDetail(new String());
			}
			
			data.add(0, sh);
			ah.putData(data);
			
			if(ah.save() == false){
				request.setAttribute("TITLE", title );
				request.setAttribute("MSG", "ダウンロード配布ファイルの作成に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			request.setAttribute("MSG", "ダウンロード配布ファイルを作成しました");
			request.setAttribute("LASTVERSION",	request.getParameter("lastversion"));
			request.setAttribute("VERSION", 	version);
			request.setAttribute("TITLE", 		title);
			request.setAttribute("DETAIL", 		detail);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
		
		}
		//***************************************************************************
		//* メニュー
		//***************************************************************************
		else if(request.getParameter("menu")  != null){
			getServletContext().getRequestDispatcher(urlbackward).forward(request, response);			
			return;	
		}
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){

		request.setAttribute("LASTVERSION",	request.getParameter("lastversion"));
		request.setAttribute("VERSION", 	request.getParameter("version"));
		request.setAttribute("TITLE", 		request.getParameter("title"));
		request.setAttribute("DETAIL", 		request.getParameter("detail"));
	
	
	}

	private boolean smallnumberCHK(String string,double minimum,double maximum,byte keta){

		//* 少数桁チェック
		int period = string.indexOf(".");
		if(period > 0){
			if( (string.length() - period -1)  > keta){
				return false;
			}
		}
		
		double dummy;
		
		try {
			dummy = Double.parseDouble(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}
	private String double2String_keta2(double number){
		DecimalFormat dfuc = new DecimalFormat("#0.00");
		return(dfuc.format(number));
		
	}	

	
	private boolean fileCheck(ServletContext scon,
									HttpSession session,
									HttpServletRequest request,
									HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* プロジェクトファイルの存在チェック
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* コンフィグファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("configFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "コンフィグファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* 評価基準ファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("evalrankFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "評価基準ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* 職種ファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("positionFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "職種ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* 職種別単価ファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("poscostFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "職種別単価ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* 年間営業日数ファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("business_year_daysFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "年間営業日数ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* ユーザー初期情報ファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("userinitFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "ユーザー初期情報ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* メンバーファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("menberFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* コミュニティファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "コミュニティファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* コミュニティメンバーファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityMenberFile");
		if(new File(filePath).exists() == false){
			dataSet(request);
			request.setAttribute("MSG", "コミュニティメンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		return true;
	}

	private boolean bodyMake(ServletContext scon,
								HttpSession session,
								HttpServletRequest request,
								HttpServletResponse response,
								String version)
	throws IOException, ServletException{

		//ＯＳ依存のファイルセパレータ
		File_Separator fs = new File_Separator();
		
		//ディレクトリクリア
		String mailcostDir = scon.getInitParameter("mailcostDir") + "_" + 
								version.replace(".", "_") + fs.getFs();
		Tool_DirDel dirdel = new Tool_DirDel(mailcostDir);
		if(dirdel.delete() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリのクリアに失敗しました<br>path="+mailcostDir);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		if( new File(mailcostDir).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+mailcostDir);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		String filePath = mailcostDir+"buff_recieve";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"buff_send";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"buff_relay";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"log";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"pgm";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"project";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"task";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = mailcostDir+"task_socket";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		filePath = mailcostDir+"icon";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		//***************************************
		//* アイコンコピー
		//***************************************
		String indir  = scon.getInitParameter("clienticonDir");
		String outdir = mailcostDir+"icon"+fs.getFs();
		
    	File[] files=new File(indir).listFiles();

    	String infilepath;
    	String outfilepath;
    	String filename;
    	File outfile;
    	for(int i=0;i<files.length;i++){
    		//コピー元
    		infilepath = files[i].getAbsolutePath();
    		//コピー先
    		filename = files[i].getName();
    		outfilepath =outdir+filename;
    		outfile = new File(outfilepath);
    		//コピー実行
    		if(new Tool_FileCopy().copyFile(files[i], outfile) == false){
    			request.setAttribute("TITLE", title );
    			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
    									"<br>outfile="+outfilepath);
    			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
    			return false;
    		}
    		
    	}
		
		//***************************************
		//* プログラムコピー
		//***************************************
		indir  = scon.getInitParameter("clientsourceDir");
		outdir = mailcostDir+"pgm"+fs.getFs();
		
    	files=new File(indir).listFiles();

    	for(int i=0;i<files.length;i++){
    		//コピー元
    		infilepath = files[i].getAbsolutePath();
    		//コピー先
    		filename = files[i].getName();
    		outfilepath =outdir+filename;
    		outfile = new File(outfilepath);
    		//コピー実行
    		if(new Tool_FileCopy().copyFile(files[i], outfile) == false){
    			request.setAttribute("TITLE", title );
    			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
    									"<br>outfile="+outfilepath);
    			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
    			return false;
    		}
    		
    	}
		
		//***************************************
		//* 設定ファイルコピー
		//***************************************
		indir  = scon.getInitParameter("masterDir");
		outdir = mailcostDir;

    	files=new File(indir).listFiles();
    

    	ArrayList <String>excludefile = new ArrayList<String>();
		//メンバーファイルは対象外
    	excludefile.add(scon.getInitParameter("menberFile"));
		//コミュニティファイルは対象外
    	excludefile.add(scon.getInitParameter("communityFile"));
		//コミュニティメンバーファイルは対象外
    	excludefile.add(scon.getInitParameter("communityMenberFile"));
		//ヒストリーファイルは対象外
    	excludefile.add(scon.getInitParameter("HistoryFile"));
		//サーバーコンフィグは対象外
    	excludefile.add(scon.getInitParameter("serverconfigFile"));
		//サーバー情報は対象外
    	excludefile.add(scon.getInitParameter("serverFile"));
    	
    	for(int i=0;i<files.length;i++){
    		
    		//コピー先
    		filename = files[i].getName();

    		//対象外ファイルはスキップ
    		if(excludefile.indexOf(filename) > -1){
    			continue;
    		}
    		
    		//コピー元
    		infilepath = files[i].getAbsolutePath();
    		outfilepath =outdir+filename;
    		outfile = new File(outfilepath);
    		//コピー実行
    		if(new Tool_FileCopy().copyFile(files[i], outfile) == false){
    			request.setAttribute("TITLE", title );
    			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
    									"<br>outfile="+outfilepath);
    			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
    			return false;
    		}
    	}
		//******************************************************************
		//* プロジェクトディレクトリ作成
		//******************************************************************
		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		scon = getServletConfig().getServletContext();
		filePath = mailcostDir +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			//ロード成功
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "プロジェクトファイルは未作成です"+ filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}   	
    	
		String projectfilePath = mailcostDir + "project" + fs.getFs()  
									+ ap.getProject() + fs.getFs();
		if( new File(projectfilePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		

		//***************************************
		//* コミュニティ関連設定ファイルコピー
		//***************************************
		infilepath  = scon.getInitParameter("masterDir") + scon.getInitParameter("communityFile");
		outfilepath =projectfilePath + scon.getInitParameter("communityFile");
		File infile  = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		infilepath  = scon.getInitParameter("masterDir") + scon.getInitParameter("communityMenberFile");
		outfilepath =projectfilePath + scon.getInitParameter("communityMenberFile");
		infile  = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		return true;
		
	}
	
	private void generationManagement(ServletContext scon,
										ArrayList<Struct_History> data){
		//ＯＳ依存のファイルセパレータ
		File_Separator fs = new File_Separator();
		String version;
		
		//３代残す
    	DecimalFormat df = new DecimalFormat("###0.00");
    	version = df.format(data.get(2).getVersion());
		String mailcostDir = scon.getInitParameter("mailcostDir") + "_" + 
										version.replace(".", "_") + fs.getFs();
			
		Tool_DirDel dirdel = new Tool_DirDel(mailcostDir);
		dirdel.delete();
	}
	
	
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

}
