package admin;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Eval_Rank;
import structure.Struct_Session;
import beansApp.AdminEvalRank_IO;
import beansApp.AdminProject_IO;

public class AdminEvalRank  extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminevalrank");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "評価基準の登録・変更";
	
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		
		//***************************************
		//* 評価基準フィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("evalrankFile");
		AdminEvalRank_IO aer = new AdminEvalRank_IO();
		aer.setFilePath(filePath);
		byte loadrtn = aer.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList data= aer.getData();
			String[] eval_weight	= new String[data.size()];
			String[] eval_sentence	= new String[data.size()];
			for(int i=0;i<data.size() ; i++){
				Struct_Eval_Rank ser= (Struct_Eval_Rank) data.get(i);
				eval_weight[i]		= String.valueOf(ser.getEval_weight());
				eval_sentence[i]	= ser.getEval_sentence();
			}
			
			request.setAttribute("EVAL_WEIGHT",		eval_weight);
			request.setAttribute("EVAL_SENTENCE",	eval_sentence);
			request.setAttribute("MSG", "評価基準ファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;

		}else if(loadrtn == (byte)2){
			//* ファイルなし
			String[] eval_weight	= new String[6];
			String[] eval_sentence	= new String[6];

			for(int i=0;i<6 ; i++){
				eval_weight[i]		= new String();
				eval_sentence[i]	= new String();
			}	
			
			
			request.setAttribute("EVAL_WEIGHT",		eval_weight);
			request.setAttribute("EVAL_SENTENCE",	eval_sentence);
			request.setAttribute("MSG", "評価基準ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "評価基準ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
	}
	
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}

		

		//デフォルト値表示を選択した場合
		if(request.getParameter("default") != null){
			AdminEvalRank_IO  aer = new AdminEvalRank_IO();
			aer.init();
			ArrayList data= aer.getData();
			String[] eval_weight	= new String[data.size()];
			String[] eval_sentence	= new String[data.size()];
			for(int i=0;i<data.size() ; i++){
				Struct_Eval_Rank ser= (Struct_Eval_Rank) data.get(i);
				eval_weight[i]		= String.valueOf(ser.getEval_weight());
				eval_sentence[i]	= ser.getEval_sentence();
			}
			
			request.setAttribute("EVAL_WEIGHT",		eval_weight);
			request.setAttribute("EVAL_SENTENCE",	eval_sentence);
			request.setAttribute("MSG", "デフォルト値を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}
		else if(request.getParameter("execute") != null){
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			String eval_weight[] =  request.getParameterValues("eval_weight");
			String eval_sentence[] =  request.getParameterValues("eval_sentence");
			
			for(int i=0;i<6 ; i++){
				//******************************************************
				//* 評価加重値　ナル値チェック
				//******************************************************
				if(eval_weight[i] == null || eval_weight[i].length() == 0){
					dataSet(request);
					request.setAttribute("MSG", "評価ランク"+(5-i)+"の評価加重値が未入力です");
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					updatemode(request,scon,session);
					return;
				}
				//******************************************************
				//* 評価文言　ナル値チェック
				//******************************************************
				if(eval_sentence[i] == null || eval_sentence[i].length() == 0){
					dataSet(request);
					request.setAttribute("MSG", "評価ランク"+(5-i)+"の評価文言が未入力です");
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					updatemode(request,scon,session);
					return;
				}
				//******************************************************
				//* 評価加重値　ニューメリックチェック
				//******************************************************
				double minimum = 0.0;
				double maximum = 1.0;
				byte keta		=	1;
				if(smallnumberCHK(eval_weight[i],minimum,maximum,keta) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"評価ランク"+(5-i)+"の評価加重値に誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					updatemode(request,scon,session);
					return;
				}
				
			}
			
			//****************************
			//* データ準備
			//****************************
			ArrayList <Struct_Eval_Rank>al = new ArrayList();
			
			for(int i=0;i<6 ; i++){
				Struct_Eval_Rank ser = new Struct_Eval_Rank();
				ser.setEval_rank(String.valueOf(5-i));
				
				ser.setEval_weight(Double.valueOf(eval_weight[i]).doubleValue());
				ser.setEval_sentence(eval_sentence[i]);
				al.add(ser);
			}

			//****************************
			//* 評価フィアルのアクセス準備
			//****************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("evalrankFile");
			AdminEvalRank_IO  aer = new AdminEvalRank_IO();
			aer.setFilePath(filePath);
			aer.setData(al);
			Struct_Eval_Rank ser= aer.getStruct_Eval_Rank(String.valueOf(1));

			if(aer.save() == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "評価基準の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			}
			
			
			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			dataSet(request);
			request.setAttribute("MSG", "評価基準を登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
						
		}
		
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("EVAL_WEIGHT",		request.getParameterValues("eval_weight"));
		request.setAttribute("EVAL_SENTENCE",	request.getParameterValues("eval_sentence"));
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;

	}

	private boolean projectTimestamp(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		

		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;

	}

	
	
	private boolean smallnumberCHK(String string,double minimum,double maximum,byte keta){

		//* 少数桁チェック
		int period = string.indexOf(".");
		if(period > 0){
			if( (string.length() - period -1)  > keta){
				return false;
			}
		}
		
		double dummy;
		
		try {
			dummy = Double.parseDouble(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}


}
