package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;

import structure.Struct_Eval_Rank;

public class AdminEvalRank_IO {
	
	private String 		FilePath;
	private ArrayList al;	
	

	//ロード	
	//		1...ロード成功
	//		2...ファイルなし
	//		3...ロード失敗
	public byte load(){
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}
		

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 al = (ArrayList) xml.readObject();

			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
 			return 3;
		} catch (Exception e) {
 	        e.printStackTrace();
 			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
	 			return 3;
			}
		}
		return 1;
	}
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
	   		xml.writeObject(al);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
	 	        e2.printStackTrace();
				return false;
			}
		}
		return true;
	}	

	
	public void init(){
		Struct_Eval_Rank 	ser	= new Struct_Eval_Rank();
		ser.setEval_rank("5");
		ser.setEval_weight(1.0);
		ser.setEval_sentence("自分の仕事に大変役立ちました");
		al = new ArrayList();
		al.add(ser);
		ser	= new Struct_Eval_Rank();
		ser.setEval_rank("4");
		ser.setEval_weight(0.8);
		ser.setEval_sentence("自分の仕事に役立ちました");
		al.add(ser);
		ser	= new Struct_Eval_Rank();
		ser.setEval_rank("3");
		ser.setEval_weight(0.6);
		ser.setEval_sentence("大変必要な情報でした");
		al.add(ser);
		ser	= new Struct_Eval_Rank();
		ser.setEval_rank("2");
		ser.setEval_weight(0.4);
		ser.setEval_sentence("必要な情報でした");
		al.add(ser);
		ser	= new Struct_Eval_Rank();
		ser.setEval_rank("1");
		ser.setEval_weight(0.2);
		ser.setEval_sentence("参考になりました");
		al.add(ser);
		ser	= new Struct_Eval_Rank();
		ser.setEval_rank("0");
		ser.setEval_weight(0.0);
		ser.setEval_sentence("次回は送らないでください");
		al.add(ser);		
	}
	
	
	
	public ArrayList getData(){
		return al;
	}
	
	public  void setData(ArrayList al){
		this.al = al;
	}
	
	
	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}
	
	
	public Struct_Eval_Rank getStruct_Eval_Rank(String s){
		for(int j=0;j<al.size();j++){
			Struct_Eval_Rank data = (Struct_Eval_Rank)al.get(j);
			if(data.getEval_rank().equals(s) == true){
				return data;
			}
		}
		return null;
	}	
	
}
