package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;

import structure.Struct_MasterFile;

public class AdminMasterFile_IO implements Serializable{
	private String 		FilePath;
	private Struct_MasterFile smf;
	

	
	public byte load(){
		//		1...ロード成功
		//		2...ファイルなし
		//		3...ロード失敗
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
				return 2;
		}

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 Struct_MasterFile smf = (Struct_MasterFile) xml.readObject();
			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return 3;
		} catch (Exception e) {
 	        e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}

	public boolean save(){
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		if(smf == null){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

			
	   		xml.writeObject(smf);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}

	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	public Struct_MasterFile getSmf() {
		return smf;
	}

	public void setSmf(Struct_MasterFile smf) {
		this.smf = smf;
	}

	
}
