package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;

import beansApp.AdminUserPassword_IO;


public class AdminPassword extends HttpServlet{

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}

		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
		return;
		
	}
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}

		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			request.setAttribute("TITLE",	"ユーザーＩＤ＆パスワードの変更");
			request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
										"更新モードの切り替えが必要です"	);
			getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
			return;
		}
		
		//****************************
		//* 旧ユーザーＩＤ　ナル値チェック
		//****************************
		String olduid = (String) request.getParameter("olduid");
		if(olduid == null || olduid.length() == 0){
			request.setAttribute("MSG", "旧ユーザーＩＤが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 旧パスワード　ナル値チェック
		//****************************
		String oldpsw = (String) request.getParameter("oldpsw");
		if(oldpsw == null || oldpsw.length() == 0){
			request.setAttribute("MSG", "旧パスワードが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新ユーザーＩＤ　ナル値チェック
		//****************************
		String newuid = (String) request.getParameter("newuid");
		if(newuid == null || newuid.length() == 0){
			request.setAttribute("MSG", "新ユーザーＩＤが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新パスワード　ナル値チェック
		//****************************
		String newpsw = (String) request.getParameter("newpsw");
		if(newpsw == null || newpsw.length() == 0){
			request.setAttribute("MSG", "新パスワードが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 確認パスワード　ナル値チェック
		//****************************
		String cfmpsw = (String) request.getParameter("cfmpsw");
		if(cfmpsw == null || cfmpsw.length() == 0){
			request.setAttribute("MSG", "確認パスワードが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 旧ユーザーＩＤ　文字数チェック
		//****************************
		if(olduid.length()<1 || olduid.length() > 128){
			request.setAttribute("MSG", "旧ユーザーＩＤは128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 旧パスワード　文字数チェック
		//****************************
		if(oldpsw.length()<1 || oldpsw.length() > 128){
			request.setAttribute("MSG", "旧パスワードは128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新ユーザーＩＤ　文字数チェック
		//****************************
		if(newuid.length()<6 || newuid.length() > 128){
			request.setAttribute("MSG", "新ユーザーＩＤは6文字以上 128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新パスワード　文字数チェック
		//****************************
		if(newpsw.length()<6 || newpsw.length() > 128){
			request.setAttribute("MSG", "新パスワードは6文字以上 128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 確認パスワード　文字数チェック
		//****************************
		if(cfmpsw.length()<6 || cfmpsw.length() > 128){
			request.setAttribute("MSG", "確認パスワードは6文字以上 128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}

		//****************************
		//* 確認パスワード　一致チェック
		//****************************
		if(	newpsw.equals(cfmpsw) ==false	){
			request.setAttribute("MSG", "新パスワードと確認パスワードが一致しません");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		//******************************************
		//* 新ユーザーＩＤ≠新パスワード　チェック
		//******************************************
		if(	newpsw.equals(newuid) ==false	){
			request.setAttribute("MSG", "新ユーザーと新パスワードが一致します");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}

		//****************************
		//* 管理者フィアルのロード準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("adminFile");

		AdminUserPassword_IO au = new AdminUserPassword_IO();
		au.setFilePath(filePath);

		//****************************
		//* 旧ユーザー＆旧パスワードのチェック
		//****************************
		au.setUserid(olduid);
		au.setPassword(oldpsw);
		if(au.authenticate() == false){
			request.setAttribute("MSG", "旧ユーザーＩＤおよび旧パスワードが違います");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}
		
		//****************************
		//* ユーザー＆パスワードの保存
		//****************************
		au.setUserid(newuid);
		au.setPassword(newpsw);
		if(au.save() == false){
			request.setAttribute("MSG", "ユーザーＩＤおよびパスワードの変更に失敗しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
			return;
		}

		session.setAttribute("USER", au.getUserid());
		request.setAttribute("MSG", "ユーザーＩＤおよびパスワードを変更しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher("/servlet/frameadminpassword").forward(request, response);			
		return;
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
}
