package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import structure.Struct_UnitCost;

public class AdminPosCost_IO {

	
	private String		FilePath;
	private Struct_UnitCost[] 	data;	

	
	//ロード
	//1...ロード成功
	//2...ファイルなし
	//3...ロード失敗
	public byte load(){
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 data =  (Struct_UnitCost[]) xml.readObject();

			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
	   		xml.writeObject(data);
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}

	public void init(){
		data = null;
		data = new Struct_UnitCost[6];
		data[0] = new Struct_UnitCost();
		data[0].setPosition("ＰＭ");
		data.clone()[0].setUnitcost(1000000);
		data[1] = new Struct_UnitCost();
		data[1].setPosition("ＳＥ１");
		data.clone()[1].setUnitcost(800000);
		data[2] = new Struct_UnitCost();
		data[2].setPosition("ＳＥ２");
		data.clone()[2].setUnitcost(750000);
		data[3] = new Struct_UnitCost();
		data[3].setPosition("ＰＧ");
		data.clone()[3].setUnitcost(600000);
		data[4] = new Struct_UnitCost();
		data[4].setPosition("管理職");
		data.clone()[4].setUnitcost(1200000);
		data[5] = new Struct_UnitCost();
		data[5].setPosition("営業職");
		data.clone()[5].setUnitcost(600000);
	}
	
	public void unitcost_init(){
		
		data = null;
		data = new Struct_UnitCost[49];
		
		data[0] = new Struct_UnitCost();
		data[0].setPosition("ＰＭ");
		data.clone()[0].setUnitcost(1200000);
		data[1] = new Struct_UnitCost();
		data[1].setPosition("ＰＭ");
		data[1].setUnitcost(1150000);
		data[2] = new Struct_UnitCost();
		data[2].setPosition("ＰＭ");
		data[2].setUnitcost(1100000);
		data[3] = new Struct_UnitCost();
		data[3].setPosition("ＰＭ");
		data[3].setUnitcost(1050000);
		data[4] = new Struct_UnitCost();
		data[4].setPosition("ＰＭ");
		data[4].setUnitcost(1000000);
		data[5] = new Struct_UnitCost();
		data[5].setPosition("ＰＭ");
		data[5].setUnitcost(950000);
		data[6] = new Struct_UnitCost();
		data[6].setPosition("ＰＭ");
		data[6].setUnitcost(900000);
		data[7] = new Struct_UnitCost();
		data[7].setPosition("ＰＭ");
		data[7].setUnitcost(850000);
		data[8] = new Struct_UnitCost();
		data[8].setPosition("ＰＭ");
		data[8].setUnitcost(800000);

		data[9] = new Struct_UnitCost();
		data[9].setPosition("ＳＥ１");
		data[9].setUnitcost(1000000);
		data[10] = new Struct_UnitCost();
		data[10].setPosition("ＳＥ１");
		data[10].setUnitcost(950000);
		data[11] = new Struct_UnitCost();
		data[11].setPosition("ＳＥ１");
		data[11].setUnitcost(900000);
		data[12] = new Struct_UnitCost();
		data[12].setPosition("ＳＥ１");
		data[12].setUnitcost(850000);
		data[13] = new Struct_UnitCost();
		data[13].setPosition("ＳＥ１");
		data[13].setUnitcost(800000);
		data[14] = new Struct_UnitCost();
		data[14].setPosition("ＳＥ１");
		data[14].setUnitcost(750000);
		data[15] = new Struct_UnitCost();
		data[15].setPosition("ＳＥ１");
		data[15].setUnitcost(700000);
		data[16] = new Struct_UnitCost();
		data[16].setPosition("ＳＥ１");
		data[16].setUnitcost(650000);
		data[17] = new Struct_UnitCost();
		data[17].setPosition("ＳＥ１");
		data[17].setUnitcost(600000);

		data[18] = new Struct_UnitCost();
		data[18].setPosition("ＳＥ２");
		data[18].setUnitcost(950000);
		data[19] = new Struct_UnitCost();
		data[19].setPosition("ＳＥ２");
		data[19].setUnitcost(900000);
		data[20] = new Struct_UnitCost();
		data[20].setPosition("ＳＥ２");
		data[20].setUnitcost(850000);
		data[21] = new Struct_UnitCost();
		data[21].setPosition("ＳＥ２");
		data[21].setUnitcost(800000);
		data[22] = new Struct_UnitCost();
		data[22].setPosition("ＳＥ２");
		data[22].setUnitcost(750000);
		data[23] = new Struct_UnitCost();
		data[23].setPosition("ＳＥ２");
		data[23].setUnitcost(700000);
		data[24] = new Struct_UnitCost();
		data[24].setPosition("ＳＥ２");
		data[24].setUnitcost(650000);
		data[25] = new Struct_UnitCost();
		data[25].setPosition("ＳＥ２");
		data[25].setUnitcost(600000);
		data[26] = new Struct_UnitCost();
		data[26].setPosition("ＳＥ２");
		data[26].setUnitcost(550000);

		data[27] = new Struct_UnitCost();
		data[27].setPosition("ＰＧ");
		data[27].setUnitcost(800000);
		data[28] = new Struct_UnitCost();
		data[28].setPosition("ＰＧ");
		data[28].setUnitcost(750000);
		data[29] = new Struct_UnitCost();
		data[29].setPosition("ＰＧ");
		data[29].setUnitcost(700000);
		data[30] = new Struct_UnitCost();
		data[30].setPosition("ＰＧ");
		data[30].setUnitcost(650000);
		data[31] = new Struct_UnitCost();
		data[31].setPosition("ＰＧ");
		data[31].setUnitcost(600000);
		data[32] = new Struct_UnitCost();
		data[32].setPosition("ＰＧ");
		data[32].setUnitcost(550000);
		data[33] = new Struct_UnitCost();
		data[33].setPosition("ＰＧ");
		data[33].setUnitcost(450000);
		data[34] = new Struct_UnitCost();
		data[34].setPosition("ＰＧ");
		data[34].setUnitcost(400000);
		
		data[35] = new Struct_UnitCost();
		data[35].setPosition("管理職");
		data[35].setUnitcost(1600000);
		data[36] = new Struct_UnitCost();
		data[36].setPosition("管理職");
		data[36].setUnitcost(1500000);
		data[37] = new Struct_UnitCost();
		data[37].setPosition("管理職");
		data[37].setUnitcost(1400000);
		data[38] = new Struct_UnitCost();
		data[38].setPosition("管理職");
		data[38].setUnitcost(1300000);
		data[39] = new Struct_UnitCost();
		data[39].setPosition("管理職");
		data[39].setUnitcost(1200000);
		data[40] = new Struct_UnitCost();
		data[40].setPosition("管理職");
		data[40].setUnitcost(1100000);
		data[41] = new Struct_UnitCost();
		data[41].setPosition("管理職");
		data[41].setUnitcost(1000000);
		data[42] = new Struct_UnitCost();
		data[42].setPosition("管理職");
		data[42].setUnitcost(900000);
		data[43] = new Struct_UnitCost();
		data[43].setPosition("管理職");
		data[43].setUnitcost(800000);
		
		data[44] = new Struct_UnitCost();
		data[44].setPosition("営業職");
		data[44].setUnitcost(800000);
		data[45] = new Struct_UnitCost();
		data[45].setPosition("営業職");
		data[45].setUnitcost(700000);
		data[46] = new Struct_UnitCost();
		data[46].setPosition("営業職");
		data[46].setUnitcost(600000);
		data[47] = new Struct_UnitCost();
		data[47].setPosition("営業職");
		data[47].setUnitcost(500000);
		data[48] = new Struct_UnitCost();
		data[48].setPosition("営業職");
		data[48].setUnitcost(400000);			
	
		
	}
	
	
	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	public Struct_UnitCost[] getData() {
		return data;
	}
	public Struct_UnitCost[] getData(String position) {
		int datacount = 0;
		for(int i=0;i<data.length;i++){
			if(position.equals(data[i].getPosition()) == true){
				datacount++;
			}
		}
		Struct_UnitCost[] newdata = new Struct_UnitCost[datacount];
		int line =0;
		for(int i=0;i<data.length;i++){
			if(position.equals(data[i].getPosition()) == true){
				newdata[line] = new Struct_UnitCost();
				newdata[line].setPosition(data[i].getPosition());
				newdata[line].setUnitcost(data[i].getUnitcost());				
				line++;
			}
		}
		
		return newdata;
	}

	
	public void setData(Struct_UnitCost[] data) {
		this.data = data;
	}

	
	
	public void setData(String position,Struct_UnitCost[] data) {
		//既存データから更新対象の職種件数を取得する
		int deletecount = 0;
		for(int i=0 ;i<this.data.length;i++){
			if(position.equals(this.data[i].getPosition())){
				deletecount++;
			}
		}

		Struct_UnitCost[] tempdata = new Struct_UnitCost[this.data.length + data.length - deletecount];	

		int line = 0;
		//*既存データ分
		for(int i=0 ;i<this.data.length;i++){
			if(position.equals(this.data[i].getPosition()) == false){
				tempdata[line] = new Struct_UnitCost();
				tempdata[line].setPosition(this.data[i].getPosition());
				tempdata[line].setUnitcost(this.data[i].getUnitcost());
				line++;
			}
		}
		//*データ追加分
		for(int i=0 ;i<data.length;i++){
			tempdata[line] = new Struct_UnitCost();
			tempdata[line].setPosition(position);
			tempdata[line].setUnitcost(data[i].getUnitcost());
			line++;
		}
		
		this.data = tempdata;
	}

	public void updateData(Struct_UnitCost[] data) {
		//既存データの更新方法を更新後件数を取得する
		//1.職種あり単価あり	⇒　現状維持
		//2.職種あり単価なし	⇒　標準月単価を追加
		//3.職種なし			⇒　標準月単価を追加
		int datacount = 0;
		int tempcount = 0;
		boolean positionfound = false;
		boolean unitcostfound = false;
		byte[] kind = new byte[data.length];
		for(int i=0 ;i<data.length;i++){
			positionfound = false;
			unitcostfound = false;
			tempcount = 0;
			for(int j=0 ;j<this.data.length;j++){
				//職種一致
				if(this.data[j].getPosition().equals(data[i].getPosition()) ==true ){
					//単価一致
					if(this.data[j].getUnitcost() == data[i].getUnitcost()){
						unitcostfound = true;
					//職種のみ一致
					}else{
						positionfound = true;
					}
					tempcount++;
				}
			}
			//単価一致
			if(unitcostfound == true){
				kind[i]=1; 
				datacount += tempcount;
			}
			//単価はなくて、職種一致の場合、標準月単価を加算
			else if(positionfound == true){
				kind[i]=2; 
				datacount += tempcount+1;
			}
			//職種なしの場合
			else{
				kind[i]=3; 
				datacount += tempcount+1;
			}
			
		}

		Struct_UnitCost[] tempdata = new Struct_UnitCost[datacount];	

		int line = 0;
		for(int i=0 ;i<data.length;i++){
			//職種あり
			if(kind[i] == 1 || kind[i] == 2){
				for(int j=0 ;j<this.data.length;j++){
					//職種一致
					if(data[i].getPosition().equals(this.data[j].getPosition()) == true ){
						tempdata[line] = new Struct_UnitCost();
						tempdata[line].setPosition(this.data[j].getPosition());
						tempdata[line].setUnitcost(this.data[j].getUnitcost());
						line++;
					}
				}	
			}
			//単価なし
			if(kind[i] == 2 || kind[i] == 3){
				tempdata[line] = new Struct_UnitCost();
				tempdata[line].setPosition(data[i].getPosition());
				tempdata[line].setUnitcost(data[i].getUnitcost());
				line++;
			}
		}

		
		this.data = tempdata;
	}	

}
