package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_UnitCost;
import beansApp.AdminPosCost_IO;
import beansApp.AdminProject_IO;

public class AdminPosition extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminposition");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "職種の登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
	

		String[] position 	= null;
		String[] unitcost	= null;
		//***************************************
		//* 職種ファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("positionFile");
//		String filePath=config.getInitParameter("positionFile");
		AdminPosCost_IO apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		byte loadrtn = apc.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_UnitCost[] suc = (Struct_UnitCost[])apc.getData();
			position  = new String[suc.length];
			unitcost  = new String[suc.length];
			
			for(int i=0;i<suc.length ; i++){
				position[i]		= suc[i].getPosition();
				unitcost[i]		= String.valueOf(suc[i].getUnitcost()/1000);
			}	

			request.setAttribute("POSITION",	position);
			request.setAttribute("UNITCOST",	unitcost);
			request.setAttribute("MSG", "職種ファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			position 	= new String[5];
			unitcost	= new String[5];
			for(int i=0;i<5 ; i++){
				position[i] = new String();
				unitcost[i] = new String();
			}
			
			request.setAttribute("POSITION",	position);
			request.setAttribute("UNITCOST",	unitcost);
			request.setAttribute("MSG", "職種ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	"職種の登録・変更");
			request.setAttribute("MSG", "職種ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
	
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		//***************************************************************************
		//* 行削除作成
		//***************************************************************************
		if(request.getParameter("delete") != null){
			String position[] 	=  request.getParameterValues("position");
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows == null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスに１件もチェックがありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			if(delrows.length == position.length){
				dataSet(request);
				request.setAttribute("MSG", "全件削除はできません。１行以上残してください");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			String unitcost[] 	=  request.getParameterValues("unitcost");
			String newnumber[] 	=  request.getParameterValues("newnumber");

			//行削除チェックボックスの復元
			boolean temp_delrows[]	= new boolean[position.length];
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			
			//* 削除後データ域の確保
			int new_line = position.length-delrows.length;
			String new_position[] 	= new String[new_line];
			String new_unitcost[] 	= new String[new_line];
			String new_newnumber[] 	= new String[new_line];
			
			//* 削除後データの作成
			String deldata = new String();
			int datacount = 0;
			for(int i=0;i<position.length;i++){
				if(temp_delrows[i] == false){
					new_position[datacount]		=	position[i];
					new_unitcost[datacount]		=	unitcost[i];
					new_newnumber[datacount]	=	newnumber[i];
					datacount++;
				}else{
					if(position[i] != null && position[i].length() > 0){
						deldata += position[i]+"<br>";
					}else{
						deldata +="---空行または役割未入力---<br>";
					}
				}
			}
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("NEWNUMBER",	new_newnumber);
			
			request.setAttribute("MSG", delrows.length+
								"件削除しました。削除データは以下のとおりです<br>"+
								deldata+
								"(削除を反映するには、登録・変更が必要です)");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* 空行作成
		//***************************************************************************
		else if(request.getParameter("addrows") != null){
			String position[] 	=  request.getParameterValues("position");
			String unitcost[] 	=  request.getParameterValues("unitcost");
			String newnumber[] 	=  request.getParameterValues("newnumber");
			String delrows[] 	=  request.getParameterValues("delrows");
			
			if(position.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}
			
			String new_position[] 	= new String[position.length+10];
			String new_unitcost[] 	= new String[unitcost.length+10];
			String new_newnumber[] 	= new String[position.length+10];
			boolean new_delrows[]	= new boolean[position.length+10];
			for(int i=0;i<position.length+10;i++){
				if(i<position.length){
					new_position[i] = position[i];
					new_unitcost[i] = unitcost[i];
					new_newnumber[i] = newnumber[i];
				}else{
					new_position[i] = new String();
					new_unitcost[i] = new String();
					new_newnumber[i] = new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("NEWNUMBER",	new_newnumber);
			request.setAttribute("DELROWS",	new_delrows);
			
			request.setAttribute("MSG", "空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* ソート
		//***************************************************************************
		else if(request.getParameter("sort") != null){

			String newnumber[] =  request.getParameterValues("newnumber");
			String position[] =  request.getParameterValues("position");
			String unitcost[] =  request.getParameterValues("unitcost");

			String delrows[] 	=  request.getParameterValues("delrows");
			boolean temp_delrows[]	= new boolean[position.length];

			//行削除チェックボックスに入力がある場合
			if(delrows != null){
				//行削除チェックボックスの復元
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					temp_delrows[line]=true;
				}
			}
			
			boolean isdata = false;
			//******************************************************
			//* データ有無チェック
			//******************************************************
			for(int i=0;i<position.length;i++){
				//******************************************************
				//* 職種　ナル値チェック
				//******************************************************
				if(position[i] != null && position[i].length() > 0){
					isdata = true;
					break;
				}
				//******************************************************
				//* 標準月単価　ナル値チェック
				//******************************************************
				if(unitcost[i] != null && unitcost[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			
			boolean sort_submit = false;
			for(int i=0;i<position.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					continue;
				}
				//******************************************************
				//* 新番号　ニューメリックチェック
				//******************************************************
				else if(numericCHK(newnumber[i],1,9999) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の新番号に誤りがあります");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}else{
					sort_submit = true;
				}
			}
			if(sort_submit == false){
				dataSet(request);
				request.setAttribute("MSG", "新番号が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 新番号　作成
			//******************************************************
			double[] sortnumber = new double[position.length];
			for(int i=0;i<position.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					sortnumber[i] = (i+1.99999);
				}
				else{
					double addpoint = 0;
					double tempnumber = Double.valueOf(newnumber[i]).doubleValue();
					for(int j=0; j<i; j++){
						if(sortnumber[j] < tempnumber){
							//*整数桁が小さい場合は無視
						}
						else if(sortnumber[j] >= (tempnumber+0.99999)){
							//*整数桁が大きい場合は無視
						}
						else{
							//*0～0.999999の間
							if( addpoint < (sortnumber[j]-tempnumber) ){
								addpoint = sortnumber[j]-tempnumber;
							}
						}
					}
					sortnumber[i] = tempnumber + addpoint + 0.00001;
				}
			}
			//******************************************************
			//* 新番号　ソード
			//******************************************************
			String new_position[] = new String[position.length];
			String new_unitcost[] = new String[unitcost.length];
			boolean new_delrows[]	= new boolean[position.length];

			for(int i=0;i<position.length;i++){
				double minimum = sortnumber[0];
				int number = 0;
				//最小値を検索する
				for(int j=0; j<position.length; j++){
					if(sortnumber[j] < minimum){
						minimum = sortnumber[j];
						number	= j;
					}
				}
				//************************************
				//* 最小値を代入
				//************************************
				//職種
				if(position[number] != null && position[number].length() > 0){
					new_position[i] = position[number];
				}else{
					new_position[i] = new String();
				}
				//標準月単価
				if(unitcost[number] != null && unitcost[number].length() > 0){
					new_unitcost[i]	= unitcost[number];
				}else{
					new_unitcost[i] = new String();
				}
				//行削除
				if(temp_delrows[number] == true){
					new_delrows[i] = true;
				}

				//最小値の抹消
				sortnumber[number] = 99999;
			}
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("MSG", "順番を入れ替えました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
		}
		//***************************************************************************
		//* デフォルト表示
		//***************************************************************************
		else if(request.getParameter("default") != null){
			AdminPosCost_IO  apc = new AdminPosCost_IO();
			apc.init();
			Struct_UnitCost[] suc = apc.getData();
			
			String new_position[] 	= new String[suc.length];
			String new_unitcost[] 	= new String[suc.length];
			
			for(int i=0;i<suc.length ; i++){
				new_position[i]	= suc[i].getPosition();
				new_unitcost[i]	=String.valueOf( suc[i].getUnitcost()/1000);
			}
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);

			request.setAttribute("MSG", "デフォルト値を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//***************************************************************************
		//* デフォルト更新
		//***************************************************************************
		else if(request.getParameter("doubledefault") != null){

			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}

			//********************************************************
			//* 職種ファイルのアクセス準備
			//********************************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("positionFile");
			AdminPosCost_IO  apc = new AdminPosCost_IO();
			apc.init();
			apc.setFilePath(filePath);
			//********************************************************
			//* 職種ファイルの更新
			//********************************************************
			if(apc.save() == false){
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "職種ファイルのセーブに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		
		
			//********************************************************
			//* 職種別単価ファイルのアクセス準備
			//********************************************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("poscostFile");
			apc.unitcost_init();
			apc.setFilePath(filePath);
			//********************************************************
			//* 職種別単価ファイルの更新
			//********************************************************
			if(apc.save() == false){
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "職種別単価ファイルのセーブに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		

			//****************************
			//* プロジェクトファイルの日時を更新する
			//****************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			//********************************************************
			//* デフォルト表示
			//********************************************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("positionFile");
			apc = new AdminPosCost_IO();

			apc.init();
			Struct_UnitCost[] suc = apc.getData();
			
			String new_position[] 	= new String[suc.length];
			String new_unitcost[] 	= new String[suc.length];
			
			for(int i=0;i<suc.length ; i++){
				new_position[i]	= suc[i].getPosition();
				new_unitcost[i]	=String.valueOf( suc[i].getUnitcost()/1000);
			}
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);

			request.setAttribute("MSG", "職種および職種別単価にデフォルト値を登録しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}
		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){
			
			//***************************************************************************
			//* 行削除チェック
			//***************************************************************************
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows != null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスにチェックがあります");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//***************************************************************************
			//* 新番号チェック
			//***************************************************************************
			String newnumber[] =  request.getParameterValues("newnumber");
			for(int i=0;i<newnumber.length;i++){
				if(newnumber[i] != null && newnumber[i].length() > 0){
					dataSet(request);
					request.setAttribute("MSG", "新番号が入力されています。番号＝"+(i+1)+"　入力値="+newnumber[i]);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
					
				}
				
			}

			
			
			String position[] 	=  request.getParameterValues("position");
			String unitcost[] 	=  request.getParameterValues("unitcost");

			//******************************************************
			//* データ有無チェック
			//******************************************************
			boolean isdata = false;
			for(int i=0;i<position.length;i++){
				//******************************************************
				//* 職種　ナル値チェック
				//******************************************************
				if(position[i] != null && position[i].length() > 0){
					isdata = true;
					break;
				}

				//******************************************************
				//* 標準月単価　ナル値チェック
				//******************************************************
				if(unitcost[i] != null && unitcost[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 職種または標準月単価のどちらかが未入力かをチェック
			//******************************************************
			int datacount = 0;
			for(int i=0;i<position.length;i++){
				boolean positiondata = false;
				if(position[i] != null && position[i].length() > 0){
					positiondata = true;
				}
				boolean unitcostdata = false;
				if(unitcost[i] != null && unitcost[i].length() > 0){
					unitcostdata = true;
				}

				if(positiondata == true && unitcostdata == false ){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の標準月単価が未入力です");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}
				else if(positiondata == false && unitcostdata == true){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の職種が未入力です");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}
				else if(positiondata == true && unitcostdata == true){
					datacount++;
				}
			}
			
			//******************************************************
			//* 標準月単価　ニューメリックチェック
			//******************************************************
			for(int i=0;i<position.length;i++){
				int minimum = 1;
				int maximum = 99999;
				if(unitcost[i] == null || unitcost[i].length() == 0){
					//データなし行は無視
					continue;
				}
				else if(numericCHK(unitcost[i],minimum,maximum) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の標準月単価に誤りがあります。入力値＝"+unitcost[i]+"　下限値＝"+minimum+"　上限値＝"+maximum);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
			}

			//******************************************************
			//* 職種　重複チェック
			//******************************************************
			for(int i=0;i<position.length-1;i++){
				for(int j=i+1; j<position.length;j++){
					if(position[j] == null || position[j].length() == 0){
						//データなし行は無視
						continue;
					}
					else if(position[i].equals(position[j]) == true){
						dataSet(request);
						request.setAttribute("MSG", (i+1)+"番目と"+ (j+1) + "番目の職種が重複しています");
						updatemode(request,scon,session);
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}
				}
			}
			
			//********************************************************
			//* 登録・更新データの準備
			//********************************************************
			int line = 0;
			String new_position[] 	= new String[datacount];
			String new_unitcost[] 	= new String[datacount];
			for(int i=0;i<position.length;i++){
				if(position[i] != null && position[i].length() > 0){
					new_position[line] = position[i];
					new_unitcost[line] = unitcost[i];
					line++;
				}
			}
			Struct_UnitCost[] newdata = new Struct_UnitCost[datacount];
			for(int i=0;i<datacount;i++){
				newdata[i] = new Struct_UnitCost();
				newdata[i].setPosition(new_position[i]);
				newdata[i].setUnitcost(Integer.valueOf(new_unitcost[i]).intValue()*1000);
			}
			
			//********************************************************
			//* 職種ファイルのアクセス準備
			//********************************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("positionFile");
			AdminPosCost_IO  apc = new AdminPosCost_IO();
			apc.setFilePath(filePath);
			apc.setData(newdata);
			//********************************************************
			//* 職種ファイルの更新
			//********************************************************
			if(apc.save() == false){
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "職種ファイルのセーブに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			

			//********************************************************
			//* 職種別単価ファイルのアクセス準備
			//********************************************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("poscostFile");
			apc.setFilePath(filePath);
			byte loadrtn = apc.load();
			if(loadrtn == (byte)1){
				//* ロード成功
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				apc.setData(newdata);
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			apc.updateData(newdata);
			//********************************************************
			//* 職種別単価ファイルの更新
			//********************************************************
			if(apc.save() == false){
				request.setAttribute("TITLE",	"職種の登録・変更");
				request.setAttribute("MSG", "職種別単価ファイルのセーブに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			

			//****************************
			//* プロジェクトファイルの日時を更新する
			//****************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			
			request.setAttribute("POSITION",	new_position);
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("MSG", "職種を登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}

	private void dataSet(HttpServletRequest request){
		request.setAttribute("NEWNUMBER",	request.getParameterValues("newnumber"));
		request.setAttribute("POSITION",	request.getParameterValues("position"));
		request.setAttribute("UNITCOST",	request.getParameterValues("unitcost"));
		
		String delrows[] 	=  request.getParameterValues("delrows");

		//行削除チェックボックスに入力がある場合
		if(delrows != null){
			boolean temp_delrows[]	= new boolean[request.getParameterValues("position").length];

			//行削除チェックボックスの復元
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			request.setAttribute("DELROWS",	temp_delrows);			
		}
	
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;

	}

	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
	
	}
	
	
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}

}
