package admin;

import java.io.IOException;
import java.util.StringTokenizer;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_User;

import beansApp.AdminProject_IO;
import beansApp.AdminUser_IO;


public class AdminProject extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminproject");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "プロジェクトの登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		ServletConfig config =getServletConfig();

		String assistMSG = new String();

		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			request.setAttribute("PROJECT"	,	ap.getProject());
			request.setAttribute("IPADDRESS",	ap.getIp_address());
			request.setAttribute("USERID"	,	ap.getUserid());
			request.setAttribute("MSG", "プロジェクトファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("PROJECT"	,	new String());
			request.setAttribute("IPADDRESS",	new String());
			request.setAttribute("USERID"	,	new String());
			request.setAttribute("MSG", "プロジェクトファイルは未作成です"+ filePath);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
	}

		
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* 更新モードチェック
		//***************************************
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
										"更新モードの切り替えが必要です"	);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}

		//********************************************
		//* リクエストオブジェクトパラメータより取得
		//********************************************
		String project = (String) request.getParameter("project");
		String ip_address = (String) request.getParameter("ip_address");
		String userid = (String) request.getParameter("userid");
		//********************************************
		//* リクエストオブジェクトパラメータに保存
		//********************************************
		request.setAttribute("PROJECT", project);
		request.setAttribute("IPADDRESS", ip_address);
		request.setAttribute("USERID", userid);
		
		
		//****************************
		//* プロジェクト名　ナル値チェック
		//****************************
		if(project == null || project.length() == 0){
			request.setAttribute("MSG", "プロジェクト名が未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		//****************************
		//* ＩＰアドレス　ナル値チェック
		//****************************
		if(ip_address == null || ip_address.length() == 0){
			request.setAttribute("MSG", "ＩＰアドレスが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//****************************
		//* プロジェクトＩＤ　ナル値チェック
		//****************************
		if(userid == null || userid.length() == 0){
			request.setAttribute("MSG", "プロジェクトＩＤが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//****************************
		//* プロジェクト名　文字数チェック
		//****************************
		if(project.length()<6 || project.length() > 128){
			request.setAttribute("MSG", "プロジェクト名は6文字以上 128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//****************************
		//* プロジェクトＩＤ　文字数チェック
		//****************************
		if(userid.length()<6 || userid.length() > 128){
			request.setAttribute("MSG", "プロジェクトＩＤは6文字以上 128文字以下です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//****************************
		//* ＩＰアドレス　フォーマットチェック
		//****************************
		if(ipAddressCHK(ip_address) == false){
			request.setAttribute("MSG", "ＩＰアドレスに誤りがあります");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		ap.setProject(project);
		ap.setIp_address(ip_address);
		ap.setUserid(userid);
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//***************************************
		//*サーバユーザーファイルのアクセス準備
		//***************************************
		Struct_User sui =  new Struct_User();
		sui.setUserid(userid);
		sui.setUser_fullname(project);
		sui.setNode(ip_address);
		sui.setLast_send_number(-1);
		sui.setLast_system_send_number(-1);
		
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("serverFile");
		AdminUser_IO aui = new AdminUser_IO();
		aui.setFilePath(filePath);
		aui.setData(sui);
		//***************************************
		//*サーバユーザーファイルの更新
		//***************************************
		if(aui.save() == false){
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "サーバーユーザーの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		
		
		request.setAttribute("MSG", "プロジェクトを登録・変更しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	
	private boolean ipAddressCHK(String ip_address){
		 StringTokenizer st = new StringTokenizer(ip_address, ".");
		    StringBuffer sb = new StringBuffer();
		    if(st.countTokens()!= 4){
	            return false;
		    }
		    for(int i=0;i<4;i++){
		        // "192.168.0.1"をコンマ区切りにし、各数値ごとに２進変換する
		        int ipnum = new Integer(st.nextToken()).intValue();
		        if(ipnum>=0&&ipnum<=255){
		        }else{
		            return false;
		        }
		    }
		return true;
	}
	
	
}
