package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

import structure.Struct_Entry_Project;

public class AdminProject_IO implements Serializable{
	private String 		FilePath;
	
	private String			project;		
	private String 		ip_address;		
	private String 		userid;			

	
	public byte load(){
		//		1...ロード成功
		//		2...ファイルなし
		//		3...ロード失敗
		
		if(FilePath == null || FilePath.length() == 0){
			return 3;
		}
		
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			 project 	= new String();
			 ip_address = new String();
			 userid 	= new String();
				return 2;
		}

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 ArrayList al = (ArrayList) xml.readObject();

			 Struct_Entry_Project pro = (Struct_Entry_Project)al.get(0);
			 project 	= pro.getProject();
			 ip_address = pro.getIp_address();
			 userid 	= pro.getUserid();
			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return 3;
		} catch (Exception e) {
 	        e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}

	public boolean save(){
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		if(project == null || project.length() == 0){
			return false;
		}
		if(ip_address == null || ip_address.length() == 0){
			return false;
		}
		if(userid == null || userid.length() == 0){
			return false;
		}
		
		 Struct_Entry_Project pro = new Struct_Entry_Project();;
		 pro.setProject(project);
		 pro.setIp_address(ip_address);
		 pro.setUserid(userid);

		 long nowtime = System.currentTimeMillis();
		 pro.setLastupdate(nowtime);
		
		
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

			
			ArrayList<Struct_Entry_Project> al= new ArrayList();
			al.add(pro);
	   		xml.writeObject(al);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}

	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	public String getIp_address() {
		return ip_address;
	}

	public void setIp_address(String ip_address) {
		this.ip_address = ip_address;
	}

	public String getProject() {
		return project;
	}

	public void setProject(String project) {
		this.project = project;
	}

	public String getUserid() {
		return userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}	
	
}
