package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_System_Config;
import beansApp.AdminConfig_IO;

public class AdminServerConfig extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminserverconfig");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "サーバーコンフィグの登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		
		//***************************************
		//* コンフィグフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("serverconfigFile");
		AdminConfig_IO ac = new AdminConfig_IO();
		ac.setFilePath(filePath);
		byte loadrtn = ac.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_System_Config ssc = (Struct_System_Config)ac.getData();
			
			request.setAttribute("TIMER_SERVER"	,	String.valueOf(ssc.getTimer_server()/1000));
			request.setAttribute("TIMER_OUT"	,	String.valueOf(ssc.getTimer_out()/1000));
			if(ssc.isStandardmode() == true){
				request.setAttribute("STANDERDMODE"		,	"on");
			}
			request.setAttribute("PORT"			,	String.valueOf(ssc.getPort()));
			request.setAttribute("BUFFSIZE"		,	String.valueOf(ssc.getBuffsize()));
			//byte⇒string変換
			request.setAttribute("LOGMODE"		,	String.valueOf(ssc.getLogmode()));			

			request.setAttribute("MSG", "サーバーコンフィグファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TIMER_SERVER"		,	new String());
			request.setAttribute("TIMER_OUT"		,	new String());
			request.setAttribute("PORT"				,	new String());
			request.setAttribute("BUFFSIZE"			,	new String());
			request.setAttribute("TIMER_RELAY"		,	new String());
			request.setAttribute("MAX_RELAY_KEEPOUT",	new String());
			request.setAttribute("TIMER_RELAY"		,	new String());
			request.setAttribute("LOGMODE"			,	"1");
			request.setAttribute("MSG", "サーバーコンフィグファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "サーバーコンフィグファイルファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
	
	}
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		
		//デフォルト値表示を選択した場合
		if(request.getParameter("default") != null){
			Struct_System_Config ssc = new Struct_System_Config();
			ssc.serverinit();

			request.setAttribute("TIMER_SERVER"	,	String.valueOf(ssc.getTimer_server()/1000));
			request.setAttribute("TIMER_OUT"	,	String.valueOf(ssc.getTimer_out()/1000));
			if(ssc.isStandardmode() == true){
				request.setAttribute("STANDERDMODE"		,	"on");
			}
			request.setAttribute("PORT"			,	String.valueOf(ssc.getPort()));
			request.setAttribute("BUFFSIZE"		,	String.valueOf(ssc.getBuffsize()));
			//byte⇒string変換
			request.setAttribute("LOGMODE"		,	String.valueOf(ssc.getLogmode()));			
			
			request.setAttribute("MSG", "デフォルト値を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}
		//***************************************
		//* 更新モードチェック
		//***************************************
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
										"更新モードの切り替えが必要です"	);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//******************************************************
		//* 受信サーバのタイマー　ナル値チェック
		//******************************************************
		String timer_server = (String) request.getParameter("timer_server");
		if(timer_server == null || timer_server.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "受信タイマーが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 受信タイムアウト　ナル値チェック
		//******************************************************
		String timer_out = (String) request.getParameter("timer_out");
		if(timer_out == null || timer_out.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "タイムアウトが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* 接続元ポート　ナル値チェック
		//******************************************************
		String port = (String) request.getParameter("port");
		if(port == null || port.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "接続元ポートが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//******************************************************
		//* バッファサイズ　ナル値チェック
		//******************************************************
		String buffsize = (String) request.getParameter("buffsize");
		if(buffsize == null || buffsize.length() == 0){
			dataSet(request);
			request.setAttribute("MSG", "バッファサイズが未入力です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//*****************************************
		//* 受信サーバ　ニューメリックチェック
		//*****************************************
		int minimum = 5;
		int maximum = 600;
		if(numericCHK(timer_server,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "受信タイマーに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//******************************************
		//* 受信タイムアウト　ニューメリックチェック
		//******************************************
		minimum = 5;
		maximum = 120;
		if(numericCHK(timer_out,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "受信タイムアウトに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}

		
		//********************************************
		//* 接続元ポート　ニューメリックチェック
		//********************************************
		minimum = 1025;
		maximum = 65535;
		if(numericCHK(port,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "接続元ポートに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//*******************************************
		//* バッファサイズ　ニューメリックチェック
		//*******************************************
		minimum = 1024;
		maximum = 4096;
		if(numericCHK(buffsize,minimum,maximum) == false){
			dataSet(request);
			request.setAttribute("MSG", "バッファサイズに誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}


		//****************************
		//* データ準備
		//****************************
		Struct_System_Config ssc = new Struct_System_Config();
		ssc.setTimer_main(0);
		ssc.setTimer_server(Integer.valueOf(timer_server).intValue()*1000);
		ssc.setTimer_out(Integer.valueOf(timer_out).intValue()*1000);
		ssc.setCost_timer(0);

		ssc.setTestmode(false);

		if(request.getParameter("standardmode").equals("yes") == true){
			ssc.setStandardmode(true);
		}else{
			ssc.setStandardmode(false);
		}
		
		ssc.setPort(Integer.valueOf(port).intValue());
		ssc.setBuffsize(Integer.valueOf(buffsize).intValue());

		ssc.setStart_relay(false);

		ssc.setTimer_relay(0);
		ssc.setMax_relay_keeptime(0);
		
		ssc.setEnd_server(false);

		String dmymode1 = (String)request.getParameter("logmode");
		int dmymode2    = Integer.valueOf(dmymode1).intValue();
		byte logmode = new Integer(dmymode2).byteValue();
		ssc.setLogmode(logmode);

		//****************************
		//* コンフィグフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("serverconfigFile");
		AdminConfig_IO ac = new AdminConfig_IO();
		ac.setFilePath(filePath);
		ac.setData(ssc);
		
		if(ac.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "サーバーコンフィグの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		dataSet(request);
		request.setAttribute("MSG", "サーバーコンフィグを登録・変更しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
	}


	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("TIMER_SERVER", 		request.getParameter("timer_server"));
		request.setAttribute("TIMER_OUT", 			request.getParameter("timer_out"));
		
		if(request.getParameter("standardmode").equals("yes") == true){
			request.setAttribute("STANDERDMODE", 			"on");
		}

		request.setAttribute("PORT", 				request.getParameter("port"));
		request.setAttribute("BUFFSIZE",			request.getParameter("buffsize"));

		request.setAttribute("TIMER_RELAY", 		request.getParameter("timer_relay"));


		request.setAttribute("LOGMODE", request.getParameter("logmode"));
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}


}
