package beansApp;

import java.beans.*;
import java.io.*;

public class AdminStatus_IO {

	private String				filename;
	

	//true:稼働状態　false:非稼動状態
//	boolean blnstatus = false;


	private final  String EXECUTING 	= "EXECUTING";
	private final  String ENDwaiting 	= "END waiting";
	private final  String END 			= "END";
	private final  String PAUSEwaiting	= "PAUSE waiting";
	private final  String PAUSE		= "PAUSE";
	
	private String status;
	
	
	public AdminStatus_IO(String filename){
		this.filename=filename;

	}
	
	//ロード	
	private void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
//			blnstatus 			=	 false;
			status 			=	 "END";
			return;
		}
		
		//書き込み中との競合を考慮して３回チャレンジする
		for(int i=0 ;i<3 ; i++){
			boolean success = false;
			try {
				 is = new FileInputStream(filename);
				 bis = new BufferedInputStream(is);
				 xml = new XMLDecoder(bis);
				 status	=	 (String) xml.readObject();
				 success = true;
				 
		    } catch (Exception e) {
		    	if(i > 1){
					e.printStackTrace();
		    	}
			}finally{
				try{
					xml.close();
				} catch(Exception e2){
					e2.printStackTrace();
				}
				if(success == true){
					return;
				}
			}
			sleep();
			
		}


		
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
//	   		xml.writeObject(Boolean.toString(blnstatus));
	   		xml.writeObject(status);
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
	}

	public boolean getExecute() {
		loadXml();
		if(status.equals(EXECUTING)){
			return true;
		}
		return false;
	}

	public boolean getEnd() {
		loadXml();
		if(status.equals(END)){
			return true;
		}
		return false;
	}
	
	public boolean getEndWait() {
		loadXml();
		if(status.equals(ENDwaiting)){
			return true;
		}
		return false;
	}
	
	
	public void setExecute() {
		this.status = EXECUTING;
		 saveXml();
	}

	public void setEnd() {
		this.status = END;
		 saveXml();
	}
	
	public void setEndWait() {
		this.status =ENDwaiting;
		 saveXml();
	}
	
	private void sleep(){
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} 
		
	}

	public String getStatus() {
		return status;
	}
	
	
	public void setPause() {
		this.status = PAUSE;
		 saveXml();
	}

	public boolean getPAUSE() {
		loadXml();
		if(status.equals(PAUSE)){
			return true;
		}
		return false;
	}

	public void setPauseWait() {
		this.status = PAUSEwaiting;
		 saveXml();
	}

	public boolean getPauseWait() {
		loadXml();
		if(status.equals(PAUSEwaiting)){
			return true;
		}
		return false;
	}

	
	
	
	
	
	
	
/*	public void setBlnstatus(boolean blnstatus) {
		this.blnstatus = blnstatus;
		saveXml();
	}

	public boolean isBlnstatus() {
		loadXml();
		return blnstatus;
	}
*/
	

	
	
}
