package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_UnitCost;
import beansApp.AdminPosCost_IO;
import beansApp.AdminProject_IO;

public class AdminUnitCost extends HttpServlet{
	private String urlbackward 	= new String("adminunitcostmenu");
	private String urlfoward 		= new String("/servlet/frameadminunitcost");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "職種別単価の登録・変更";
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		//***************************************************************************
		//* 職種選択メニュー
		//***************************************************************************
		if(request.getParameter("menu") != null){
			response.sendRedirect(urlbackward);
			return;	
			
		}
		//***************************************************************************
		//* 行削除作成
		//***************************************************************************
		if(request.getParameter("delete") != null){
			String unitcost[] 	=  request.getParameterValues("unitcost");
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows == null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスに１件もチェックがありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			//行削除チェックボックスの復元
			boolean temp_delrows[]	= new boolean[unitcost.length];
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
				
			}
			
			//* 削除後データ域の確保
			int new_line = unitcost.length-delrows.length;
			String new_position[] 	= new String[new_line];
			String new_unitcost[] 	= new String[new_line];
			String new_newnumber[] 	= new String[new_line];
			
			//* 削除後データの作成
			String deldata = new String();
			int datacount = 0;
			for(int i=0;i<unitcost.length;i++){
				if(temp_delrows[i] == false){
					new_unitcost[datacount]		=	unitcost[i];
					datacount++;
				}else{
					if(unitcost[i] != null && unitcost[i].length() > 0){
						deldata += unitcost[i]+"<br>";
					}else{
						deldata +="---空行または役割未入力---<br>";
					}
				}
			}

			//標準月単価の復元
			String standerdcost = request.getParameter("standerd");
			boolean[] standerd = new boolean[new_unitcost.length];
			for(int i=0;i<new_unitcost.length ;i++){
				if(standerdcost.equals(new_unitcost[i]) == true){
					standerd[i] = true;
					break;
				}
			}

			request.setAttribute("POSITION",	request.getParameter("position"));
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("STANDERD",	standerd);
			request.setAttribute("MSG", delrows.length+
								"件削除しました。削除データは以下のとおりです<br>"+
								deldata+
								"(削除を反映するには、登録・変更が必要です)");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}		
		//***************************************************************************
		//* 前空行作成
		//***************************************************************************
		else if(request.getParameter("addrowsbefore") != null){
			String unitcost[] 	=  request.getParameterValues("unitcost");
			String delrows[] 	=  request.getParameterValues("delrows");
			
			if(unitcost.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}
			
			String new_unitcost[] 	= new String[unitcost.length+10];
			boolean new_delrows[]	= new boolean[unitcost.length+10];
			for(int i=0;i<unitcost.length+10;i++){
				if(i>9){
					new_unitcost[i] = unitcost[i-10];
				}else{
					new_unitcost[i] = new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}
			
			//標準月単価の復元
			String standerdcost = request.getParameter("standerd");
			boolean[] standerd = new boolean[new_unitcost.length];
			for(int i=0;i<new_unitcost.length ;i++){
				if(standerdcost.equals(new_unitcost[i]) == true){
					standerd[i] = true;
					break;
				}
			}			
			
			request.setAttribute("POSITION",	request.getParameter("position"));
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("STANDERD",	standerd);
			
			request.setAttribute("MSG", "前空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* 後空行作成
		//***************************************************************************
		else if(request.getParameter("addrowsafter") != null){
			String unitcost[] 	=  request.getParameterValues("unitcost");
			String delrows[] 	=  request.getParameterValues("delrows");
			
			if(unitcost.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}
			
			String new_unitcost[] 	= new String[unitcost.length+10];
			boolean new_delrows[]	= new boolean[unitcost.length+10];
			for(int i=0;i<unitcost.length+10;i++){
				if(i<unitcost.length){
					new_unitcost[i] = unitcost[i];
				}else{
					new_unitcost[i] = new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}
			
			//標準月単価の復元
			String standerdcost = request.getParameter("standerd");
			boolean[] standerd = new boolean[new_unitcost.length];
			for(int i=0;i<new_unitcost.length ;i++){
				if(standerdcost.equals(new_unitcost[i]) == true){
					standerd[i] = true;
					break;
				}
			}			
			
			request.setAttribute("POSITION",	request.getParameter("position"));
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("STANDERD",	standerd);
			
			request.setAttribute("MSG", "後空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}		
		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************************************************
			//* 行削除チェック
			//***************************************************************************
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows != null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスにチェックがあります");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			
			String position 	=  request.getParameter("position");
			String unitcost[] 	=  request.getParameterValues("unitcost");

			//******************************************************
			//* 実データの取得
			//* 標準月単価　ニューメリックチェック
			//******************************************************
			int datacount = 0;
			int minimum = 1;
			int maximum = 99999;
			for(int i=0;i<unitcost.length;i++){
				if(unitcost[i] == null || unitcost[i].length() ==0){
					continue;
				}
				else if(numericCHK(unitcost[i],minimum,maximum) == false){
					dataSet(request);
					request.setAttribute("MSG", i+"番目の単価に誤りがあります。下限値＝"+minimum+"　上限値＝"+maximum);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}else{
					datacount++;
				}
			}

			//******************************************************
			//* 単価　重複チェック
			//******************************************************
			for(int i=0;i<unitcost.length-1;i++){
				for(int j=i+1; j<unitcost.length;j++){
					if(unitcost[i] == null || unitcost[i].length() ==0){
						continue;
					}
					if(unitcost[j] == null || unitcost[j].length() ==0){
						continue;
					}
					else if(Integer.valueOf(unitcost[i]).intValue()
							 == Integer.valueOf(unitcost[j]).intValue()){
						dataSet(request);
						request.setAttribute("MSG", i+"番目と"+ j + "番目の単価が重複しています");
						updatemode(request,scon,session);
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}
				}
			}
			
			//********************************************************
			//* 登録・更新データの準備
			//********************************************************
			//* 実データ抽出
			int line = 0;
			int[] temp1_unitcost = new int[datacount];
			for(int i=0;i<unitcost.length;i++){
				if(unitcost[i] != null && unitcost[i].length() > 0){
					temp1_unitcost[line] = Integer.valueOf(unitcost[i]).intValue();
					line++;
				}
			}

			//* コスト降順
			int[] temp2_unitcost = new int[datacount];
			for(int i=0;i<datacount ;i++){
				temp2_unitcost[i]= temp1_unitcost[i];
				int save = i;
				for(int j=0;j<datacount ;j++){
					if(i == j){
						continue;
					}
					else if(temp2_unitcost[i] < temp1_unitcost[j]){
						temp2_unitcost[i]= temp1_unitcost[j];
						save = j;
					}
				}
				temp1_unitcost[save] = 0;	
			}
			
			String new_unitcost[] 	= new String[datacount];
			Struct_UnitCost[] newdata = new Struct_UnitCost[datacount];
			for(int i=0;i<datacount;i++){
				newdata[i] = new Struct_UnitCost();
				newdata[i].setUnitcost(temp2_unitcost[i]*1000);
				new_unitcost[i] = String.valueOf(temp2_unitcost[i]);
			}
			
			
			//********************************************************
			//* 職種別単価ファイルのアクセス準備
			//********************************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("poscostFile");
//			ServletConfig config =getServletConfig();
//			String filePath=config.getInitParameter("poscostFile");
			AdminPosCost_IO  apc = new AdminPosCost_IO();
			apc.setFilePath(filePath);
			byte loadrtn = apc.load();
			if(loadrtn == (byte)1){
				//* ロード成功
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				dataSet(request);
				request.setAttribute("MSG", "職種別単価ファイルは未作成です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			apc.setData(position,newdata);

			if(apc.save() == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種別単価の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			
			request.setAttribute("POSITION",	position);
			request.setAttribute("UNITCOST",	new_unitcost);
			
			//標準月単価の復元
			String standerdcost = request.getParameter("standerd");
			boolean[] standerd = new boolean[new_unitcost.length];
			for(int i=0;i<new_unitcost.length ;i++){
				if(standerdcost.equals(new_unitcost[i]) == true){
					standerd[i] = true;
					break;
				}
			}
			request.setAttribute("STANDERD",	standerd);
			
			request.setAttribute("MSG", "職種別単価を登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}		
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("POSITION",	request.getParameter("position"));
		request.setAttribute("UNITCOST",	request.getParameterValues("unitcost"));
		
		//標準月単価の復元
		String[] unitcost = request.getParameterValues("unitcost");
		String standerdcost = request.getParameter("standerd");
		boolean[] standerd = new boolean[unitcost.length];
		for(int i=0;i<unitcost.length ;i++){
			if(standerdcost.equals(unitcost[i]) == true){
				standerd[i] = true;
				break;
			}
		}
		request.setAttribute("STANDERD",	standerd);
		
		String delrows[] 	=  request.getParameterValues("delrows");
		//行削除チェックボックスに入力がある場合
		if(delrows != null){
			boolean temp_delrows[]	= new boolean[unitcost.length];

			//行削除チェックボックスの復元
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			request.setAttribute("DELROWS",	temp_delrows);			
		}
	

	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

	
	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;
	
	}
	
	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
		
	}
		
		
	
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}
	
}
