package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_UnitCost;
import beansApp.AdminPosCost_IO;
import beansApp.AdminProject_IO;

public class AdminUnitCostMenu extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminunitcostmenu");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "職種別単価の登録・変更";
	
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		//***************************************
		//* 職種ファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("positionFile");
		AdminPosCost_IO apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		byte loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_UnitCost[] suc = (Struct_UnitCost[])apc.getData();
			String[] position  = new String[suc.length];
			String[] unitcost  = new String[suc.length];
			
			for(int i=0;i<suc.length ; i++){
				position[i]		= suc[i].getPosition();
				unitcost[i]		= String.valueOf(suc[i].getUnitcost()/1000);
			}	

			request.setAttribute("POSITION",	position);
			request.setAttribute("UNITCOST",	unitcost);
			request.setAttribute("MSG", "職種ファイルを表示しました<br>編集したい職種を選択してください");
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
		
		
	}
	
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}

	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
	throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;
	
	}
		
	
}
