package admin;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;
import structure.Struct_UnitCost;
import beansApp.AdminPosCost_IO;

public class AdminUnitCostView extends HttpServlet{
	
	private String title = "職種別単価の登録・変更";
	

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}
		
		String select 	=  request.getParameter("select");
		if(select == null){
			dataSet(request);
			request.setAttribute("MSG", "選択がありません");
			getServletContext().getRequestDispatcher("/servlet/frameadminunitcostmenu").forward(request, response);			
			return;				
		}

		//***************************************
		//* 表示する職種と標準単価
		//***************************************
		String position[] 		= request.getParameterValues("position");
		String unitcost[] 		= request.getParameterValues("unitcost");
		String position_select  = position[Integer.valueOf(select).intValue()];
		String unitcost_select  = unitcost[Integer.valueOf(select).intValue()];
		
		//***************************************
		//* 職種別単価ファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("poscostFile");
		AdminPosCost_IO apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		byte loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_UnitCost[] suc = (Struct_UnitCost[])apc.getData(position_select);
			String[] new_unitcost  = new String[suc.length];
			boolean[] standerd = new boolean[suc.length];
			
			//* コスト降順
			int[] temp1_unitcost = new int[suc.length];
			int[] temp2_unitcost = new int[suc.length];
			for(int i=0;i<suc.length ;i++){
				temp1_unitcost[i]=suc[i].getUnitcost();
			}
			for(int i=0;i<suc.length ;i++){
				temp2_unitcost[i]= temp1_unitcost[i];
				int save = i;
				for(int j=0;j<suc.length ;j++){
					if(i == j){
						continue;
					}
					else if(temp2_unitcost[i] < temp1_unitcost[j]){
						temp2_unitcost[i]= temp1_unitcost[j];
						save = j;
					}
				}
				temp1_unitcost[save] = 0;	
			}
			
			for(int i=0;i<suc.length ;i++){
//				new_unitcost[i] = String.valueOf(suc[i].getUnitcost()/1000);
				new_unitcost[i] = String.valueOf(temp2_unitcost[i]/1000);
				if(unitcost_select.equals(new_unitcost[i]) == true){
					standerd[i] = true;
				}
			}
			
			request.setAttribute("POSITION",	position_select);
			request.setAttribute("UNITCOST",	new_unitcost);
			request.setAttribute("STANDERD",	standerd);
			
			request.setAttribute("MSG", "職種別単価を表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher("/servlet/frameadminunitcost").forward(request, response);			
			return;
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルは未作成です");
			getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
			return;
		}				
	}
	
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("POSITION",	request.getParameterValues("position"));
		request.setAttribute("UNITCOST",	request.getParameterValues("unitcost"));
		
		String select[] 	=  request.getParameterValues("select");

		//選択チェックボックスに入力がある場合
		if(select != null){
			boolean temp_select[]	= new boolean[request.getParameterValues("position").length];

			//行削除チェックボックスの復元
			for(int i=0;i<select.length;i++){
				int line = Integer.valueOf(select[i]).intValue();
				temp_select[line]=true;
			}
			request.setAttribute("SELECT",	temp_select);			
		}
	}
	
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	
}
