package admin;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Business_Year_days;
import structure.Struct_Eval_Rank;
import structure.Struct_Session;
import structure.Struct_UnitCost;
import structure.Struct_User;
import beansApp.AdminBusinessYeardays_IO;
import beansApp.AdminEvalRank_IO;
import beansApp.AdminPosCost_IO;
import beansApp.AdminProject_IO;
import beansApp.AdminUser_IO;

public class AdminUserInit extends HttpServlet{
	private String urlfoward 		= new String("/servlet/frameadminuserinit");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "ユーザー初期情報の登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		ServletConfig config =getServletConfig();

		String assistMSG = new String();
		
		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
//		String filePath=config.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			//プロジェクトファイルの正常アクセス確認	
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}		
		
		//********************************************************
		//* 職種ファイルのアクセス準備
		//********************************************************
		Struct_UnitCost[] positionFileData = null;
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("positionFile");
//		filePath=config.getInitParameter("positionFile");
		AdminPosCost_IO  apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			positionFileData = (Struct_UnitCost[])apc.getData();
			
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//***************************************
		//* 職種別単価ファイルのアクセス準備
		//***************************************
		String [] new_position = null;
		String [] new_unitcost = null;
		
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("poscostFile");
//		filePath=config.getInitParameter("poscostFile");
		apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			int totalline = apc.getData().length;
			new_position  = new String[totalline];
			new_unitcost  = new String[totalline];
			boolean[] standerd = new boolean[totalline];
				
			int line = 0;
			//職種ファイルのデータのループ
			for(int k=0;k<positionFileData.length;k++){
				
				//職種ファイルのデータ毎に職種別単価を抽出する
				Struct_UnitCost[] suc = apc.getData(positionFileData[k].getPosition());

				//* コスト降順
				int[] temp1_unitcost = new int[suc.length];
				int[] temp2_unitcost = new int[suc.length];
				for(int i=0;i<suc.length ;i++){
					temp1_unitcost[i]=suc[i].getUnitcost();
				}
				for(int i=0;i<suc.length ;i++){
					temp2_unitcost[i]= temp1_unitcost[i];
					int save = i;
					for(int j=0;j<suc.length ;j++){
						if(i == j){
							continue;
						}
						else if(temp2_unitcost[i] < temp1_unitcost[j]){
							temp2_unitcost[i]= temp1_unitcost[j];
							save = j;
						}
					}
					temp1_unitcost[save] = 0;	
				}
				
				//ソート後を出力
				for(int i=0;i<suc.length ;i++){
					new_position[line] = positionFileData[k].getPosition();
					new_unitcost[line] = String.valueOf(temp2_unitcost[i]/1000);
					if(positionFileData[k].getUnitcost() == temp2_unitcost[i] ){
						standerd[line] = true;
					}
					line++;
				}
				
			}

			//表示用単価
			String[] new_unitcost_view  = new String[totalline];
			int digit = 5;			//表示文字数
			int datalength;
			for(int i=0;i<totalline;i++){
				datalength = new_unitcost[i].length();
				if(datalength == digit){
					new_unitcost_view[i] = new_position[i];
				}
				new_unitcost_view[i] = new String();
				for(int j=0;j<(digit-datalength);j++){
//					new_unitcost_view[i] += "&lt;";
//					new_unitcost_view[i] += "&nbsp;";
					new_unitcost_view[i] += "_";
				}
				new_unitcost_view[i] += new_unitcost[i];
			}
			
			//職種と職種別単価と標準月単価マークを
			//事前にリクエストオブジェクトに登録する
			request.setAttribute("POSITION",new_position);
			request.setAttribute("UNITCOST",new_unitcost);
			request.setAttribute("UNITCOST_VIEW",new_unitcost_view);
			request.setAttribute("STANDERD",standerd);
			
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
		
		//***************************************
		//* 年間営業日数ファイルのアクセス準備
		//***************************************
		String[] years = null;
		String[] days  = null;
		
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("business_year_daysFile");
//		filePath=config.getInitParameter("business_year_daysFile");
		AdminBusinessYeardays_IO abyd = new AdminBusinessYeardays_IO();
		abyd.setFilePath(filePath);
		loadrtn = abyd.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_Business_Year_days[] sbyd = (Struct_Business_Year_days[])abyd.getData();
			years  = new String[sbyd.length];
			days   = new String[sbyd.length];
			
			for(int i=0;i<sbyd.length ; i++){
				years[i]	= String.valueOf(sbyd[i].getYear());
				days[i]		= String.valueOf(sbyd[i].getDays());
			}	
			request.setAttribute("YEARS",	years);
			request.setAttribute("DAYS" ,	days);
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "年間営業日数ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "年間営業日数ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			

		//***************************************
		//* 評価基準フィアルのアクセス準備
		//***************************************
		String[] eval_weight;
		String[] eval_sentence;
		String[] eval_rank;

		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("evalrankFile");
//		filePath=config.getInitParameter("evalrankFile");
		AdminEvalRank_IO aer = new AdminEvalRank_IO();
		aer.setFilePath(filePath);
		loadrtn = aer.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList data= aer.getData();
			eval_weight		= new String[data.size()];
			eval_sentence	= new String[data.size()];
			eval_rank		= new String[data.size()];
			for(int i=0;i<data.size() ; i++){
				Struct_Eval_Rank ser= (Struct_Eval_Rank) data.get(i);
				eval_weight[i]		= String.valueOf(ser.getEval_weight());
				eval_sentence[i]	= ser.getEval_sentence();
				eval_rank[i]		= ser.getEval_rank();
			}
			request.setAttribute("EVAL_WEIGHT"	,	eval_weight);
			request.setAttribute("EVAL_SENTENCE",	eval_sentence);
			request.setAttribute("EVAL_RANK"	,	eval_rank);

			
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "評価基準ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "評価基準ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}		
		
		
		//***************************************
		//*ユーザーファイルのアクセス準備
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("userinitFile");
//		filePath=config.getInitParameter("userinitFile");
		AdminUser_IO aui = new AdminUser_IO();
		aui.setFilePath(filePath);
		loadrtn = aui.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_User sui = (Struct_User)aui.getData();


			//***************************************************
			//* 職種と単価の存在チェック
			//***************************************************
			String posision_select   = sui.getStruct_unitccost().getPosition();
			String unitcost_select  = String.valueOf(sui.getStruct_unitccost().getUnitcost()/1000);
			
			boolean found = false;
			for(int i=0;i<new_position.length ;i++){
				if(posision_select.equals(new_position[i]) == true &&
						unitcost_select.equals(new_unitcost[i])	==true)	{
					found = true;
					break;
				}
				
			}
			//見つからない場合
			if(found = false){
				assistMSG = "<br>前回設定した職種と単価はマスターに存在しません。職種＝"+posision_select+" 単価＝"+unitcost_select;
				posision_select = new_position[0];
				unitcost_select = new_unitcost[0];
			}
			request.setAttribute("POSITION_SELECT",	posision_select);
			request.setAttribute("UNITCOST_SELECT",	unitcost_select);
			
			//***************************************************
			//*年間営業日数の存在チェック
			//***************************************************
			boolean[] days_chk = new boolean[years.length];
			String business_year_days = String.valueOf(sui.getBusiness_year_days());	
			
			Calendar cal = Calendar.getInstance(); 
			String yyyy = String.valueOf(cal.get(Calendar.YEAR));

			String days_select=new String(); 
			found = false;
			//当年が一致するか検索
			int line = 0;
			for(int i=0;i<years.length; i++){
				if(yyyy.equals(years[i])){
					if(business_year_days.equals(days[i])){
						days_chk[i]=true;
						days_select = days[i];
						found = true;
					}
					line = i;
					break;
				}
			}
			//見つからない場合は過去年が一致するか検索
			if(found == false && (line != 0)){
				for(int i=line-1;i>-1; i--){
					if(business_year_days.equals(days[i])){
						assistMSG = "<br>前回設定した年間営業日数は当年にはなく、過去年に存在します。当年＝"+yyyy;
						days_chk[i]=true;
						days_select = days[i];
						found = true;
					}
					
				}
			}
			//過去年でも見つからない場合
			if(found == false ){
				assistMSG = "<br>前回設定した年間営業日数は当年および過去年に存在しません。前回の年間営業日数＝"+business_year_days;
				days_select = days[0];
				days_chk[0]=true;
				
			}
			
			request.setAttribute("DAYS_CHK",	days_chk);
			request.setAttribute("DAYS_SELECT",	days_select);
			
			StructUser2Html(sui,config,request,response);
			

			request.setAttribute("MSG", "ユーザー初期情報を表示しました"+assistMSG);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("POSITION_SELECT",	new_position[0]);
			request.setAttribute("UNITCOST_SELECT",	new_unitcost[0]);

			
			//***************************************************
			//*年間営業日数の存在チェック
			//***************************************************
			boolean[] days_chk = new boolean[years.length];
			
			Calendar cal = Calendar.getInstance(); 
			String yyyy = String.valueOf(cal.get(Calendar.YEAR));

			String days_select=new String(); 
			boolean found = false;
			//当年が一致するか検索
			int line = 0;
			for(int i=0;i<years.length; i++){
				if(yyyy.equals(years[i])){
					days_chk[i]=true;
					days_select = days[i];
					found = true;
					line = i;
					break;
				}
			}
			//見つからない場合
			if(found == true){
				days_select = days[0];
				days_chk[0]=true;
			}
			request.setAttribute("DAYS_CHK",	days_chk);
			request.setAttribute("DAYS_SELECT",	days_select);

			
			request.setAttribute("WORKINGTIME",	new String());
			request.setAttribute("UNITCOST_SECOND",	new String()	);

			//***************************************************
			//*レベル１表示
			//***************************************************
			request.setAttribute("NORMAL_MAXTIME",	new String());
			request.setAttribute("NORMAL_KIND"	 ,	new String());
			request.setAttribute("NORMAL_MAXCOST",	new String());

			//***************************************************
			//*レベル２表示
			//***************************************************
			request.setAttribute("SEMI_WARNING_MAXTIME",new String());
			request.setAttribute("SEMI_WARNING_KIND"   ,new String());
			request.setAttribute("SEMI_WARNING_MAXCOST",new String());
			
			//***************************************************
			//*レベル３表示
			//***************************************************
			request.setAttribute("WARNING_MAXTIME"	,	new String());
			request.setAttribute("WARNING_KIND"		,	new String());
			request.setAttribute("WARNING_MAXCOST"	,	new String());
			
			//***************************************************
			//*レベル４表示
			//***************************************************
			request.setAttribute("SEMI_ABNORMAL_MAXTIME"	,	new String());
			request.setAttribute("SEMI_ABNORMAL_KIND"		,	new String());
			request.setAttribute("SEMI_ABNORMAL_MAXCOST"	,	new String());

			//***************************************************
			//*レベル５表示
			//***************************************************
			request.setAttribute("ABNORMAL_MAXTIME"	,	new String());
			request.setAttribute("ABNORMAL_KIND"	,	new String());
			request.setAttribute("ABNORMAL_MAXCOST"	,	new String());

			request.setAttribute("EVAL_SELECT"	,"0"	);

			//***************************************************
			//*書き込みコスト
			//***************************************************
			request.setAttribute("WRITE_MAXCOST"	,new String());
			request.setAttribute("WRITE_MAXTIME"	,new String());
			
			//***************************************************
			//*読み込みコスト
			//***************************************************
			request.setAttribute("READ_MAXCOST"	,new String());
			request.setAttribute("READ_MAXTIME"	,new String());
			
			//***************************************************
			//*総コスト（書き込みコスト＋読み込みコスト）
			//***************************************************
			request.setAttribute("REAL_MAXCOST"	,new String());
			request.setAttribute("REAL_MAXTIME"	,new String());
			
			//***************************************************
			//*評価された評価額
			//***************************************************
			request.setAttribute("MYEVAL_MAXCOST"	,new String());
			request.setAttribute("MYEVAL_MAXTIME"	,new String());

			//***************************************************
			//*評価した評価額
			//***************************************************
			request.setAttribute("OTHEREVAL_MAXCOST"	,new String());
			request.setAttribute("OTHEREVAL_MAXTIME"	,new String());
			
			//***************************************************
			//*貢献コスト
			//***************************************************
			request.setAttribute("CONT_MAXCOST"	,new String());
			request.setAttribute("CONT_MAXTIME"	,new String());

			//***************************************************
			//*貢献後コスト
			//***************************************************
			request.setAttribute("TOTAL_MAXCOST"	,new String());
			request.setAttribute("TOTAL_MAXTIME"	,new String());			
			
			request.setAttribute("MSG", "ユーザー初期情報ファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "ユーザー初期情報ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
		
	}
	//******************************************************
	//* ユーザー初期情報登録・変更画面からの呼び出し doGet
	//******************************************************
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		ServletConfig config =getServletConfig();

		String assistMSG = new String();

		//デフォルト値表示を選択した場合
		if(request.getParameter("default") != null){
			//***************************************
			//* プロジェクトフィアルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("projectFile");
			AdminProject_IO ap = new AdminProject_IO();
			ap.setFilePath(filePath);
			byte loadrtn = ap.load();

			if(loadrtn == (byte)1){
				//プロジェクトファイルの正常アクセス確認	
			}else if(loadrtn == (byte)2){
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "プロジェクトファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		
			
			//********************************************************
			//* 職種ファイルのアクセス準備
			//********************************************************
			Struct_UnitCost[] positionFileData = null;
			
			filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("positionFile");
			AdminPosCost_IO  apc = new AdminPosCost_IO();
			apc.setFilePath(filePath);
			loadrtn = apc.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				positionFileData = (Struct_UnitCost[])apc.getData();
				
				
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種ファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
				
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************
			//* 職種別単価ファイルのアクセス準備
			//***************************************
			String [] new_position = null;
			String [] new_unitcost = null;
			
			filePath = scon.getInitParameter("masterDir") +
			scon.getInitParameter("poscostFile");
			apc = new AdminPosCost_IO();
			apc.setFilePath(filePath);
			loadrtn = apc.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				int totalline = apc.getData().length;
				new_position  = new String[totalline];
				new_unitcost  = new String[totalline];
				boolean[] standerd = new boolean[totalline];
					
				int line = 0;
				//職種ファイルのデータのループ
				for(int k=0;k<positionFileData.length;k++){
					
					//職種ファイルのデータ毎に職種別単価を抽出する
					Struct_UnitCost[] suc = apc.getData(positionFileData[k].getPosition());

					//* コスト降順
					int[] temp1_unitcost = new int[suc.length];
					int[] temp2_unitcost = new int[suc.length];
					for(int i=0;i<suc.length ;i++){
						temp1_unitcost[i]=suc[i].getUnitcost();
					}
					for(int i=0;i<suc.length ;i++){
						temp2_unitcost[i]= temp1_unitcost[i];
						int save = i;
						for(int j=0;j<suc.length ;j++){
							if(i == j){
								continue;
							}
							else if(temp2_unitcost[i] < temp1_unitcost[j]){
								temp2_unitcost[i]= temp1_unitcost[j];
								save = j;
							}
						}
						temp1_unitcost[save] = 0;	
					}
					
					//ソート後を出力
					for(int i=0;i<suc.length ;i++){
						new_position[line] = positionFileData[k].getPosition();
						new_unitcost[line] = String.valueOf(temp2_unitcost[i]/1000);
						if(positionFileData[k].getUnitcost() == temp2_unitcost[i] ){
							standerd[line] = true;
						}
						line++;
					}
					
				}

				//表示用単価
				String[] new_unitcost_view  = new String[totalline];
				int digit = 5;			//表示文字数
				int datalength;
				for(int i=0;i<totalline;i++){
					datalength = new_unitcost[i].length();
					if(datalength == digit){
						new_unitcost_view[i] = new_position[i];
					}
					new_unitcost_view[i] = new String();
					for(int j=0;j<(digit-datalength);j++){
//						new_unitcost_view[i] += "&lt;";
//						new_unitcost_view[i] += "&nbsp;";
						new_unitcost_view[i] += "_";
					}
					new_unitcost_view[i] += new_unitcost[i];
				}
				
				//職種と職種別単価と標準月単価マークを
				//事前にリクエストオブジェクトに登録する
				request.setAttribute("POSITION",new_position);
				request.setAttribute("UNITCOST",new_unitcost);
				request.setAttribute("UNITCOST_VIEW",new_unitcost_view);
				request.setAttribute("STANDERD",standerd);
				
				
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種別単価ファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
				
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}				
			
			//***************************************
			//* 年間営業日数ファイルのアクセス準備
			//***************************************
			String[] years = null;
			String[] days  = null;
			
			filePath = scon.getInitParameter("masterDir") +
			scon.getInitParameter("business_year_daysFile");
			AdminBusinessYeardays_IO abyd = new AdminBusinessYeardays_IO();
			abyd.setFilePath(filePath);
			loadrtn = abyd.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				Struct_Business_Year_days[] sbyd = (Struct_Business_Year_days[])abyd.getData();
				years  = new String[sbyd.length];
				days   = new String[sbyd.length];
				
				for(int i=0;i<sbyd.length ; i++){
					years[i]	= String.valueOf(sbyd[i].getYear());
					days[i]		= String.valueOf(sbyd[i].getDays());
				}	
				request.setAttribute("YEARS",	years);
				request.setAttribute("DAYS" ,	days);
				
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "年間営業日数ファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "年間営業日数ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			

			//***************************************
			//* 評価基準フィアルのアクセス準備
			//***************************************
			String[] eval_weight;
			String[] eval_sentence;
			String[] eval_rank;
			
			filePath = scon.getInitParameter("masterDir") +
			scon.getInitParameter("evalrankFile");
			AdminEvalRank_IO aer = new AdminEvalRank_IO();
			aer.setFilePath(filePath);
			loadrtn = aer.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				ArrayList data= aer.getData();
				eval_weight		= new String[data.size()];
				eval_sentence	= new String[data.size()];
				eval_rank		= new String[data.size()];
				for(int i=0;i<data.size() ; i++){
					Struct_Eval_Rank ser= (Struct_Eval_Rank) data.get(i);
					eval_weight[i]		= String.valueOf(ser.getEval_weight());
					eval_sentence[i]	= ser.getEval_sentence();
					eval_rank[i]		= ser.getEval_rank();
				}
				request.setAttribute("EVAL_WEIGHT"	,	eval_weight);
				request.setAttribute("EVAL_SENTENCE",	eval_sentence);
				request.setAttribute("EVAL_RANK"	,	eval_rank);

				
			}else if(loadrtn == (byte)2){
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "評価基準ファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "評価基準ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		
			
			//***************************************
			//*ユーザーファイルのアクセス準備
			//***************************************
			filePath = scon.getInitParameter("masterDir") +
			scon.getInitParameter("userinitFile");
			AdminUser_IO aui = new AdminUser_IO();
			aui.init();
			//* ロード成功
			Struct_User sui = (Struct_User)aui.getData();

			//***************************************************
			//* 職種と単価の存在チェック
			//***************************************************
			String posision_select   = sui.getStruct_unitccost().getPosition();
			String unitcost_select  = String.valueOf(sui.getStruct_unitccost().getUnitcost()/1000);
			
			boolean found = false;
			for(int i=0;i<new_position.length ;i++){
				if(posision_select.equals(new_position[i]) == true &&
						unitcost_select.equals(new_unitcost[i])	==true)	{
					found = true;
					break;
				}
				
			}
			//見つからない場合
			if(found = false){
				assistMSG = "<br>デフォルトの職種と単価はマスターに存在しません。職種＝"+posision_select+" 単価＝"+unitcost_select;
				posision_select = new_position[0];
				unitcost_select = new_unitcost[0];
			}
			request.setAttribute("POSITION_SELECT",	posision_select);
			request.setAttribute("UNITCOST_SELECT",	unitcost_select);
			
			//***************************************************
			//*年間営業日数の存在チェック
			//***************************************************
			boolean[] days_chk = new boolean[years.length];
			String business_year_days = String.valueOf(sui.getBusiness_year_days());	
			
			Calendar cal = Calendar.getInstance(); 
			String yyyy = String.valueOf(cal.get(Calendar.YEAR));

			String days_select=new String(); 
			found = false;
			//当年が一致するか検索
			int line = 0;
			for(int i=0;i<years.length; i++){
				if(yyyy.equals(years[i])){
					if(business_year_days.equals(days[i])){
						days_chk[i]=true;
						days_select = days[i];
						found = true;
					}
					line = i;
					break;
				}
			}
			//見つからない場合は過去年が一致するか検索
			if(found == false && (line != 0)){
				for(int i=line-1;i>-1; i--){
					if(business_year_days.equals(days[i])){
						assistMSG = "<br>デフォルトの年間営業日数は当年にはなく、過去年に存在します。当年＝"+yyyy;
						days_chk[i]=true;
						days_select = days[i];
						found = true;
					}
				}
			}
			//過去年でも見つからない場合
			if(found == false ){
				assistMSG = "<br>デフォルトの年間営業日数は当年および過去年に存在しません。デフォルトの年間営業日数＝"+business_year_days;
				days_select = days[0];
				days_chk[0]=true;
				
			}
			
			request.setAttribute("DAYS_CHK",	days_chk);
			request.setAttribute("DAYS_SELECT",	days_select);

			StructUser2Html(sui,config,request,response);
			
			request.setAttribute("MSG", "デフォルト値を表示しました"+assistMSG);
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
			
		}
		//登録・変更
		else if(request.getParameter("execute") != null){
			String dummy;
			//***********************************************************************
			//* データ準備
			//***********************************************************************
			Struct_User sui =  new Struct_User();
			
			//ユーザーＩＤ
			sui.setUserid(request.getParameter("userid"));
			//ユーザー名称
			sui.setUser_fullname(request.getParameter("user_fullname"));
			//ノード
			sui.setNode(request.getParameter("node"));

			//*********************************************
			//* 職種と単価の取得・分離・設定
			//*********************************************
			String data = request.getParameter("positionunit");
			int datalength=data.length();
			String number="0123456789";
			//数字以外の文字が現れたら終了するループ
			int separater = 0;
			for(int i=0;i<datalength;i++){
				dummy = data.substring(i,i+1);
				if(number.indexOf(dummy) < 0){
					separater = i;
					break;
				}
			}
			Struct_UnitCost su = new Struct_UnitCost();
			su.setPosition(data.substring(separater,datalength));
			su.setUnitcost(Integer.valueOf(data.substring(0,separater)).intValue()*1000);
			sui.setStruct_unitccost(su);
			
			//年間営業日数
			dummy = (String) request.getParameter("BusinessYeardays");
			sui.setBusiness_year_days(Integer.valueOf(dummy).intValue());

			//最終送信番号
			sui.setLast_send_number(-1);
			//最終送信番号
			sui.setLast_system_send_number(-1);

			//１日の労働時間
			sui.setWorking_time(Double.valueOf(request.getParameter("working_time")).doubleValue());
			//１秒あたりの単価
			sui.setUnit_cost(Double.valueOf(request.getParameter("unitcost_second")).doubleValue());

			//表示レベル１
			sui.setNormal_maxtime(Double.valueOf(request.getParameter("normal_maxtime")).doubleValue());
			dummy = request.getParameter("normal_maxcost").replaceAll(",", "");
			sui.setNormal_maxcost(Integer.valueOf(dummy).intValue());
			sui.setNormal_kind(request.getParameter("normal_kind"));
			
			//表示レベル２
			sui.setSemi_warning_maxtime(Double.valueOf(request.getParameter("semi_warning_maxtime")).doubleValue());
			dummy = request.getParameter("semi_warning_maxcost").replaceAll(",", "");
			sui.setSemi_warning_maxcost(Integer.valueOf(dummy).intValue());
			sui.setSemi_warning_kind(request.getParameter("semi_warning_kind"));
			
			//表示レベル３
			sui.setWarning_maxtime(Double.valueOf(request.getParameter("warning_maxtime")).doubleValue());
			dummy = request.getParameter("warning_maxcost").replaceAll(",", "");
			sui.setWarning_maxcost(Integer.valueOf(dummy).intValue());
			sui.setWarning_kind(request.getParameter("warning_kind"));

			//表示レベル４
			sui.setSemi_abnormal_maxtime(Double.valueOf(request.getParameter("semi_abnormal_maxtime")).doubleValue());
			dummy = request.getParameter("semi_abnormal_maxcost").replaceAll(",", "");
			sui.setSemi_abnormal_maxcost(Integer.valueOf(dummy).intValue());
			sui.setSemi_abnormal_kind(request.getParameter("semi_abnormal_kind"));
			
			//表示レベル５
			sui.setAbnormal_maxtime(Double.valueOf(request.getParameter("abnormal_maxtime")).doubleValue());
			dummy = request.getParameter("abnormal_maxcost").replaceAll(",", "");
			sui.setAbnormal_maxcost(Integer.valueOf(dummy).intValue());
			sui.setAbnormal_kind(request.getParameter("abnormal_kind"));

			//標準単価の表示
			if(request.getParameter("std_chk").equals("yes")){
				sui.setStd_chk(true);
			}else{
				sui.setStd_chk(false);
			}

			//標準基準
			sui.setEval_rank(request.getParameter("evalrank"));
			
			
			//書き込みコスト
			sui.setWrite_maxtime(Double.valueOf(request.getParameter("write_maxtime")).doubleValue());
			dummy = request.getParameter("write_maxcost").replaceAll(",", "");
			sui.setWrite_maxcost(Integer.valueOf(dummy).intValue());

			//読み込みコスト
			sui.setRead_maxtime(Double.valueOf(request.getParameter("read_maxtime")).doubleValue());
			dummy = request.getParameter("read_maxcost").replaceAll(",", "");
			sui.setRead_maxcost(Integer.valueOf(dummy).intValue());
			
			//総合コスト
			sui.setReal_maxtime(Double.valueOf(request.getParameter("real_maxtime")).doubleValue());
			dummy = request.getParameter("real_maxcost").replaceAll(",", "");
			sui.setReal_maxcost(Integer.valueOf(dummy ).intValue());

			//評価された額
			sui.setMy_eval_maxtime(Double.valueOf(request.getParameter("myeval_maxtime")).doubleValue());
			dummy = request.getParameter("myeval_maxcost").replaceAll(",", "");
			sui.setMy_eval_maxcost(Integer.valueOf(dummy).intValue());
			
			//評価した額
			sui.setOther_eval_maxtime(Double.valueOf(request.getParameter("othereval_maxtime")).doubleValue());
			dummy = request.getParameter("othereval_maxcost").replaceAll(",", "");
			sui.setOther_eval_maxcost(Integer.valueOf(dummy).intValue());
			
			//貢献コスト
			sui.setCont_maxtime(Double.valueOf(request.getParameter("cont_maxtime")).doubleValue());
			dummy = request.getParameter("cont_maxcost").replaceAll(",", "");
			sui.setCont_maxcost(Integer.valueOf(dummy).intValue());
			
			//貢献後コスト
			sui.setTotal_maxtime(Double.valueOf(request.getParameter("total_maxtime")).doubleValue());
			dummy = request.getParameter("total_maxcost").replaceAll(",", "");
			sui.setTotal_maxcost(Integer.valueOf(dummy).intValue());

			//自動実行
			if(request.getParameter("autobatch").equals("yes")){
				sui.setAutobatch(true);
			}else{
				sui.setAutobatch(false);
			}
			
			//送信方法
			if(request.getParameter("senddirect").equals("yes")){
				sui.setSend_direct(true);
			}else{
				sui.setSend_direct(false);
			}

			//直接送信オプション
			if(request.getParameter("senddirect_option").equals("yes")){
				sui.setSend_direct_option(true);
			}else{
				sui.setSend_direct_option(false);
			}
			
			//直接送信オプション他ノード中継
			if(request.getParameter("senddirect_option_relay").equals("yes")){
				sui.setSend_direct_option_relay(true);
			}else{
				sui.setSend_direct_option_relay(false);
			}

			//直接送信オプションサーバ中継
			if(request.getParameter("senddirect_option_server").equals("yes")){
				sui.setSend_direct_option_server(true);
			}else{
				sui.setSend_direct_option_server(false);
			}
			
			//他ノード中継１
			if(request.getParameter("relay1").equals("yes")){
				//***************************************
				//* プロジェクトフィアルのアクセス準備
				//***************************************
				String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
				AdminProject_IO ap = new AdminProject_IO();
				ap.setFilePath(filePath);
				byte loadrtn = ap.load();

				if(loadrtn == (byte)1){
					//プロジェクトファイルの正常アクセス確認
				}else if(loadrtn == (byte)2){
					//* ファイルなし
					request.setAttribute("TITLE",title);
					request.setAttribute("MSG", "プロジェクトファイルは未作成です");
					getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
					return;
				}else{
					//* ロード失敗
					request.setAttribute("TITLE",title);
					request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
					getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
					return;
				}		
				
				sui.setRelay1_userid(ap.getUserid());
				sui.setRelay1_project(ap.getProject());
				sui.setRelay1_node(ap.getIp_address());
				sui.setRelay1_community(new String());
			}else{
				sui.setRelay1_userid(new String());
				sui.setRelay1_project(new String());
				sui.setRelay1_node(new String());
				sui.setRelay1_community(new String());
			}

			//他ノード中継２～５
			sui.setRelay2_userid(new String());
			sui.setRelay2_project(new String());
			sui.setRelay2_node(new String());
			sui.setRelay2_community(new String());
			sui.setRelay3_userid(new String());
			sui.setRelay3_project(new String());
			sui.setRelay3_node(new String());
			sui.setRelay3_community(new String());
			sui.setRelay4_userid(new String());
			sui.setRelay4_project(new String());
			sui.setRelay4_node(new String());
			sui.setRelay4_community(new String());
			sui.setRelay5_userid(new String());
			sui.setRelay5_project(new String());
			sui.setRelay5_node(new String());
			sui.setRelay5_community(new String());

			
			//***************************************
			//*ユーザーファイルのアクセス準備
			//***************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("userinitFile");
//			String filePath=config.getInitParameter("userinitFile");
			AdminUser_IO aui = new AdminUser_IO();
			aui.setFilePath(filePath);
			aui.setData(sui);

			//***************************************
			//*ユーザーファイルの更新
			//***************************************
			if(aui.save() == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "ユーザー初期情報の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			dataSet(scon,request,response);
			request.setAttribute("MSG", "ユーザー初期情報を登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
			
		}		
		//コスト解除を選択した場合
		else if(request.getParameter("cancel") != null){
			dataSet(scon,request,response);
			request.setAttribute("MSG", "入力禁止を解除しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
		//コスト計算を選択した場合
		else if(request.getParameter("calculate") != null){
			//単価
			String data = request.getParameter("positionunit");
			int datalength=data.length();
			String number="0123456789";
			String dummy;
			//数字以外の文字が現れたら終了するループ
			int separater = 0;
			for(int i=0;i<datalength;i++){
				dummy = data.substring(i,i+1);
				if(number.indexOf(dummy) < 0){
					separater = i;
					break;
				}
			}
			
			dummy = data.substring(0,separater);
			int unitcost = Integer.valueOf(dummy).intValue()*1000;

			//年間営業日数
			dummy = (String) request.getParameter("BusinessYeardays");
			int days_select = Integer.valueOf(dummy).intValue();

			
			//******************************************************
			//* １日の労働時間　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("working_time");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "１日の労働時間が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			
			}
			//******************************************************
			//* １日の労働時間　ニューメリックチェック
			//******************************************************
			double minimum = 1.0;
			double maximum = 24.0;
			byte keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "１日の労働時間に誤りがあります。１日の労働時間＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double working_time = Double.valueOf(dummy).doubleValue();

			
			//******************************************************
			//* 表示レベル１　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("normal_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル１の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 表示レベル１　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル１の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double normal_time = Double.valueOf(dummy).doubleValue();
			//******************************************************
			//* 表示レベル１単位　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("normal_kind");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル１の単位が未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			String normal_kind = dummy;
			
			//******************************************************
			//* 表示レベル２　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("semi_warning_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル２の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 表示レベル２　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル２の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double semi_warning_time = Double.valueOf(dummy).doubleValue();
			//******************************************************
			//* 表示レベル２単位　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("semi_warning_kind");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル２の単位が未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			String semi_warning_kind = dummy;			
			
			//******************************************************
			//* 表示レベル３　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("warning_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル２の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 表示レベル３　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル３の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double warning_time = Double.valueOf(dummy).doubleValue();
			//******************************************************
			//* 表示レベル３単位　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("warning_kind");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル３の単位が未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			String warning_kind = dummy;					
			
			//******************************************************
			//* 表示レベル４　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("semi_abnormal_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル４の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 表示レベル４　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル４の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double semi_abnormal_time = Double.valueOf(dummy).doubleValue();
			//******************************************************
			//* 表示レベル４単位　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("semi_abnormal_kind");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル４の単位が未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			String semi_abnormal_kind = dummy;		

			//******************************************************
			//* 表示レベル５　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("abnormal_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル５の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 表示レベル５　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル５の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double abnormal_time = Double.valueOf(dummy).doubleValue();
			//******************************************************
			//* 表示レベル５単位　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("abnormal_kind");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "表示レベル５の単位が未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			String abnormal_kind = dummy;				
			
			//******************************************************
			//* 書き込みコスト　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("write_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "書き込みコストの値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 書き込みコスト　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "書き込みコストの値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double write_time = Double.valueOf(dummy).doubleValue();
			
			//******************************************************
			//* 読み込みコスト　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("read_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "読み込みコストの値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 読み込みコスト　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "読み込みコストの値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double read_time = Double.valueOf(dummy).doubleValue();
			
			//******************************************************
			//* 総合コスト　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("real_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "総合コストの値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 総合コスト　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "総合コストの値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double real_time = Double.valueOf(dummy).doubleValue();
			
			//******************************************************
			//* 評価された額　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("myeval_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "評価された額の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 評価された額　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "評価された額の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double myeval_time = Double.valueOf(dummy).doubleValue();
			
			//******************************************************
			//* 評価した額　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("othereval_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "評価した額の値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 評価した額　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "評価した額の値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double othereval_time = Double.valueOf(dummy).doubleValue();

			//******************************************************
			//* 貢献コスト　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("cont_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "貢献コストの値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 貢献コスト　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "貢献コストの値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double cont_time = Double.valueOf(dummy).doubleValue();

			//******************************************************
			//* 貢献後コスト　ナル値チェック
			//******************************************************
			dummy = (String) request.getParameter("total_maxtime");
			if(dummy == null || dummy.length() == 0){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "貢献後コストの値が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//******************************************************
			//* 貢献後コスト　ニューメリックチェック
			//******************************************************
			minimum = 1.0;
			maximum = 300.0;
			keta		=	2;
			if(smallnumberCHK(dummy,minimum,maximum,keta) == false){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "貢献後コストの値に誤りがあります。値＝"+dummy+"　下限値＝"+minimum+"　上限値＝"+maximum+"　有効少数桁数＝"+keta);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			double total_time = Double.valueOf(dummy).doubleValue();
			
			
			
			//******************************************************
			//* 単価／秒　計算
			//******************************************************
			
			double unitcost_second = unitcost /	(days_select * working_time*60*60/12);

			//少数桁第４位で四捨五入
			BigDecimal bd = new BigDecimal(String.valueOf(unitcost_second));
			unitcost_second = bd.setScale(7, BigDecimal.ROUND_HALF_UP) .doubleValue();
			DecimalFormat dfuc = new DecimalFormat("#0.0000000");

			
			double normal_chkcost 			= rtnUnitcost(normal_kind,normal_time,unitcost_second,working_time);
			double semi_warning_chkcost 	= rtnUnitcost(semi_warning_kind,semi_warning_time,unitcost_second,working_time);
			double warning_chkcost			= rtnUnitcost(warning_kind,warning_time,unitcost_second,working_time);
			double semi_abnormal_chkcost	= rtnUnitcost(semi_abnormal_kind,semi_abnormal_time,unitcost_second,working_time);
			double abnormal_chkcost 		= rtnUnitcost(abnormal_kind,abnormal_time,unitcost_second,working_time);
			//******************************************************
			//* 表示レベル１　＜　表示レベル２　チェック
			//******************************************************
			if(normal_chkcost >= semi_warning_chkcost){
				dataSet(scon,request,response);
				request.setAttribute("MSG", 
						"(表示レベル１のコスト)＜(表示レベル２のコスト)にしてください<br>"+
						"(表示レベル１のコスト)＝"+normal_chkcost+
						"<br>(表示レベル２のコスト)＝"+ semi_warning_chkcost);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}			
			//******************************************************
			//* 表示レベル２　＜　表示レベル３　チェック
			//******************************************************
			if(semi_warning_chkcost >= warning_chkcost){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "(表示レベル２のコスト)＜(表示レベル３のコスト)にしてください<br>"+
						"(表示レベル２のコスト)＝"+semi_warning_chkcost+
						"<br>(表示レベル３のコスト)＝"+ warning_chkcost);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}			
			//******************************************************
			//* 表示レベル３　＜　表示レベル４　チェック
			//******************************************************
			if(warning_chkcost >= semi_abnormal_chkcost){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "(表示レベル３のコスト)＜(表示レベル４のコスト)にしてください<br>"+
						"(表示レベル３のコスト)＝"+warning_chkcost+
						"<br>(表示レベル４のコスト)＝"+ semi_abnormal_chkcost);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}			
			//******************************************************
			//* 表示レベル４　＜　表示レベル５　チェック
			//******************************************************
			if(semi_abnormal_chkcost >= abnormal_chkcost){
				dataSet(scon,request,response);
				request.setAttribute("MSG", "(表示レベル４のコスト)＜(表示レベル５のコスト)にしてください<br>"+
						"(表示レベル４のコスト)＝"+semi_abnormal_chkcost+
						"<br>(表示レベル５のコスト)＝"+ abnormal_chkcost);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}			
			
			
			//１日の労働時間	
			request.setAttribute("WORKINGTIME"		,	double2String_keta2(working_time));
			//１秒あたりの単価	
			request.setAttribute("UNITCOST_SECOND"		,dfuc.format(unitcost_second));
			
			
			//******************************************************
			//* レベル１　単価／秒　計算・設定
			//******************************************************
			String  normal_unitcost = double2String_keta0(normal_chkcost);
			request.setAttribute("NORMAL_MAXTIME"	,double2String_keta2(normal_time));
			request.setAttribute("NORMAL_MAXCOST"	,normal_unitcost);
			request.setAttribute("NORMAL_KIND"		,normal_kind);
			
			//******************************************************
			//* レベル２　単価／秒　計算・設定
			//******************************************************
			String  semi_warning_unitcost = double2String_keta0(semi_warning_chkcost);
			request.setAttribute("SEMI_WARNING_MAXTIME"	,double2String_keta2(semi_warning_time));
			request.setAttribute("SEMI_WARNING_MAXCOST"	,semi_warning_unitcost);
			request.setAttribute("SEMI_WARNING_KIND"	,semi_warning_kind);
			
			//******************************************************
			//* レベル３　単価／秒　計算・設定
			//******************************************************
			String  warning_unitcost = double2String_keta0(warning_chkcost);
			request.setAttribute("WARNING_MAXTIME"	,double2String_keta2(warning_time));
			request.setAttribute("WARNING_MAXCOST"	,warning_unitcost);
			request.setAttribute("WARNING_KIND"	,warning_kind);
			
			//******************************************************
			//* レベル４　単価／秒　計算・設定
			//******************************************************
			String  semi_abnormal_unitcost = double2String_keta0(semi_abnormal_chkcost);
			request.setAttribute("SEMI_ABNORMAL_MAXTIME",double2String_keta2(semi_abnormal_time));
			request.setAttribute("SEMI_ABNORMAL_MAXCOST",semi_abnormal_unitcost);
			request.setAttribute("SEMI_ABNORMAL_KIND"	,semi_abnormal_kind);
			
			//******************************************************
			//* レベル５　単価／秒　計算・設定
			//******************************************************
			String  abnormal_unitcost = double2String_keta0(abnormal_chkcost);
			request.setAttribute("ABNORMAL_MAXTIME"	,double2String_keta2(abnormal_time));
			request.setAttribute("ABNORMAL_MAXCOST"	,abnormal_unitcost);
			request.setAttribute("ABNORMAL_KIND"	,abnormal_kind);
			
			//******************************************************
			//* 書き込みコスト　単価／秒　計算・設定
			//******************************************************
			String  write_unitcost = double2String_keta0(rtnUnitcost("h",write_time,unitcost_second,working_time));
			request.setAttribute("WRITE_MAXTIME"	,double2String_keta2(write_time));
			request.setAttribute("WRITE_MAXCOST"	,write_unitcost);

			//******************************************************
			//* 読み込みコスト　単価／秒　計算・設定
			//******************************************************
			String  read_unitcost = double2String_keta0(rtnUnitcost("h",read_time,unitcost_second,working_time));
			request.setAttribute("READ_MAXTIME"	,double2String_keta2(read_time));
			request.setAttribute("READ_MAXCOST"	,read_unitcost);
			
			//******************************************************
			//* 総合コスト　単価／秒　計算・設定
			//******************************************************
			String  real_unitcost = double2String_keta0(rtnUnitcost("h",real_time,unitcost_second,working_time));
			request.setAttribute("REAL_MAXTIME"	,double2String_keta2(real_time));
			request.setAttribute("REAL_MAXCOST"	,real_unitcost);
			
			//******************************************************
			//* 評価された額　単価／秒　計算・設定
			//******************************************************
			String  myeval_unitcost = double2String_keta0(rtnUnitcost("h",myeval_time,unitcost_second,working_time));
			request.setAttribute("MYEVAL_MAXTIME"	,double2String_keta2(myeval_time));
			request.setAttribute("MYEVAL_MAXCOST"	,myeval_unitcost);
			
			//******************************************************
			//* 評価した額　単価／秒　計算・設定
			//******************************************************
			String  othereval_unitcost = double2String_keta0(rtnUnitcost("h",othereval_time,unitcost_second,working_time));
			request.setAttribute("OTHEREVAL_MAXTIME"	,double2String_keta2(othereval_time));
			request.setAttribute("OTHEREVAL_MAXCOST"	,othereval_unitcost);

			//******************************************************
			//* 貢献コスト　単価／秒　計算・設定
			//******************************************************
			String  cont_unitcost = double2String_keta0(rtnUnitcost("h",cont_time,unitcost_second,working_time));
			request.setAttribute("CONT_MAXTIME"	,double2String_keta2(cont_time));
			request.setAttribute("CONT_MAXCOST"	,cont_unitcost);
			
			//******************************************************
			//* 貢献後コスト　単価／秒　計算・設定
			//******************************************************
			String  total_unitcost = double2String_keta0(rtnUnitcost("h",total_time,unitcost_second,working_time));
			request.setAttribute("TOTAL_MAXTIME"	,double2String_keta2(total_time));
			request.setAttribute("TOTAL_MAXCOST"	,total_unitcost);

			
			//******************************************************
			//* 他の項目を戻す
			//******************************************************
			dataSet(scon,request,response,"calculate");
			request.setAttribute("CALCULATE_END"	,"on");
			request.setAttribute("MSG", "コストを計算しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}
		
	}
	
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void dataSet(ServletContext scon,
			HttpServletRequest request,
			HttpServletResponse response)
	throws IOException, ServletException{
		dataSet(scon,request,response,null);
	}
	
	private void dataSet(ServletContext scon,
							HttpServletRequest request,
							HttpServletResponse response,
							String command)
	throws IOException, ServletException{
		request.setAttribute("POSITION"		,request.getParameter("position_select"));

		boolean calCMD = false;
		if(command != null && command.equals("calculate")){
			calCMD = true;
		}
		
		String assistMSG = new String();
		
		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			//プロジェクトファイルの正常アクセス確認
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}		
		
		//********************************************************
		//* 職種ファイルのアクセス準備
		//********************************************************
		Struct_UnitCost[] positionFileData = null;
		
		filePath = scon.getInitParameter("masterDir") +
						scon.getInitParameter("positionFile");
		AdminPosCost_IO  apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			positionFileData = (Struct_UnitCost[])apc.getData();
			
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//***************************************
		//* 職種別単価ファイルのアクセス準備
		//***************************************
		String [] new_position = null;
		String [] new_unitcost = null;
		
		filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("poscostFile");
//		filePath=config.getInitParameter("poscostFile");
		apc = new AdminPosCost_IO();
		apc.setFilePath(filePath);
		loadrtn = apc.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			int totalline = apc.getData().length;
			new_position  = new String[totalline];
			new_unitcost  = new String[totalline];
			boolean[] standerd = new boolean[totalline];
				
			int line = 0;
			//職種ファイルのデータのループ
			for(int k=0;k<positionFileData.length;k++){
				
				//職種ファイルのデータ毎に職種別単価を抽出する
				Struct_UnitCost[] suc = apc.getData(positionFileData[k].getPosition());

				//* コスト降順
				int[] temp1_unitcost = new int[suc.length];
				int[] temp2_unitcost = new int[suc.length];
				for(int i=0;i<suc.length ;i++){
					temp1_unitcost[i]=suc[i].getUnitcost();
				}
				for(int i=0;i<suc.length ;i++){
					temp2_unitcost[i]= temp1_unitcost[i];
					int save = i;
					for(int j=0;j<suc.length ;j++){
						if(i == j){
							continue;
						}
						else if(temp2_unitcost[i] < temp1_unitcost[j]){
							temp2_unitcost[i]= temp1_unitcost[j];
							save = j;
						}
					}
					temp1_unitcost[save] = 0;	
				}
				
				//ソート後を出力
				for(int i=0;i<suc.length ;i++){
					new_position[line] = positionFileData[k].getPosition();
					new_unitcost[line] = String.valueOf(temp2_unitcost[i]/1000);
					if(positionFileData[k].getUnitcost() == temp2_unitcost[i] ){
						standerd[line] = true;
					}
					line++;
				}
				
			}

			//表示用単価
			String[] new_unitcost_view  = new String[totalline];
			int digit = 5;			//表示文字数
			int datalength;
			for(int i=0;i<totalline;i++){
				datalength = new_unitcost[i].length();
				if(datalength == digit){
					new_unitcost_view[i] = new_position[i];
				}
				new_unitcost_view[i] = new String();
				for(int j=0;j<(digit-datalength);j++){
//					new_unitcost_view[i] += "&lt;";
//					new_unitcost_view[i] += "&nbsp;";
					new_unitcost_view[i] += "_";
				}
				new_unitcost_view[i] += new_unitcost[i];
			}
			
			//職種と職種別単価と標準月単価マークを
			//事前にリクエストオブジェクトに登録する
			request.setAttribute("POSITION",new_position);
			request.setAttribute("UNITCOST",new_unitcost);
			request.setAttribute("UNITCOST_VIEW",new_unitcost_view);
			request.setAttribute("STANDERD",standerd);
			
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			HttpSession session = request.getSession(true);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "職種別単価ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
		
		//***************************************
		//* 年間営業日数ファイルのアクセス準備
		//***************************************
		String[] years = null;
		String[] days  = null;
		
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("business_year_daysFile");
		AdminBusinessYeardays_IO abyd = new AdminBusinessYeardays_IO();
		abyd.setFilePath(filePath);
		loadrtn = abyd.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			Struct_Business_Year_days[] sbyd = (Struct_Business_Year_days[])abyd.getData();
			years  = new String[sbyd.length];
			days   = new String[sbyd.length];
			
			for(int i=0;i<sbyd.length ; i++){
				years[i]	= String.valueOf(sbyd[i].getYear());
				days[i]		= String.valueOf(sbyd[i].getDays());
			}	
			request.setAttribute("YEARS",	years);
			request.setAttribute("DAYS" ,	days);
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "年間営業日数ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "年間営業日数ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			

		//***************************************
		//* 評価基準フィアルのアクセス準備
		//***************************************
		String[] eval_weight;
		String[] eval_sentence;
		String[] eval_rank;
		
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("evalrankFile");
		AdminEvalRank_IO aer = new AdminEvalRank_IO();
		aer.setFilePath(filePath);
		loadrtn = aer.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList data= aer.getData();
			eval_weight		= new String[data.size()];
			eval_sentence	= new String[data.size()];
			eval_rank		= new String[data.size()];
			for(int i=0;i<data.size() ; i++){
				Struct_Eval_Rank ser= (Struct_Eval_Rank) data.get(i);
				eval_weight[i]		= String.valueOf(ser.getEval_weight());
				eval_sentence[i]	= ser.getEval_sentence();
				eval_rank[i]		= ser.getEval_rank();
			}
			request.setAttribute("EVAL_WEIGHT"	,	eval_weight);
			request.setAttribute("EVAL_SENTENCE",	eval_sentence);
			request.setAttribute("EVAL_RANK"	,	eval_rank);

			
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "評価基準ファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			HttpSession session = request.getSession(false);
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "評価基準ファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				

		//*********************************************
		//* 職種と単価の取得・分離・設定
		//*********************************************
		String data = request.getParameter("positionunit");
		int datalength=data.length();
		String number="0123456789";
		String dummy;
		//数字以外の文字が現れたら終了するループ
		int separater = 0;
		for(int i=0;i<datalength;i++){
			dummy = data.substring(i,i+1);
			if(number.indexOf(dummy) < 0){
				separater = i;
				break;
			}
		}
		request.setAttribute("POSITION_SELECT",	data.substring(separater,datalength));
		request.setAttribute("UNITCOST_SELECT",	data.substring(0,separater));

		//***************************************************
		//*年間営業日数の存在チェック
		//***************************************************
		boolean[] days_chk = new boolean[years.length];
		
		Calendar cal = Calendar.getInstance(); 
		String yyyy = String.valueOf(cal.get(Calendar.YEAR));

		String days_select=new String(); 
		boolean found = false;
		//当年が一致するか検索
		int line = 0;
		for(int i=0;i<years.length; i++){
			if(yyyy.equals(years[i])){
				days_chk[i]=true;
				days_select = days[i];
				found = true;
				line = i;
				break;
			}
		}
		//見つからない場合
		if(found == true){
			days_select = days[0];
			days_chk[0]=true;
		}		
		request.setAttribute("DAYS_CHK",	days_chk);
		request.setAttribute("DAYS_SELECT",	days_select);
		
		if(calCMD != true){
			//１日の労働時間	
			request.setAttribute("WORKINGTIME"		,	request.getParameter("working_time"));

			//１秒あたりの単価	
			dummy = request.getParameter("unitcost_second");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("UNITCOST_SECOND"	,dummy		);
			}else{
				request.setAttribute("UNITCOST_SECOND"	,new String()		);
			}
		}


		if(request.getParameter("std_chk").equals("yes")){
			request.setAttribute("STD_CHK",	"yes"	);
		}

		//評価基準
		request.setAttribute("EVAL_SELECT"	,request.getParameter("evalrank")	);

		
		//*****************************************************************************************
		//* コスト計算の場合はスキップ
		//*****************************************************************************************
		if(calCMD != true){
			//***************************************************
			//*レベル１表示
			//***************************************************
			dummy = request.getParameter("normal_kind");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("NORMAL_KIND"	,dummy		);
			}else{
				request.setAttribute("NORMAL_KIND"	,new String()		);
			}
			request.setAttribute("NORMAL_MAXTIME",	request.getParameter("normal_maxtime"));
			dummy = request.getParameter("normal_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("NORMAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("NORMAL_MAXCOST"	,new String()		);
			}

			//***************************************************
			//*レベル２表示
			//***************************************************
			dummy = request.getParameter("semi_warning_kind");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("SEMI_WARNING_KIND"	,dummy		);
			}else{
				request.setAttribute("SEMI_WARNING_KIND"	,new String()		);
			}
			request.setAttribute("SEMI_WARNING_MAXTIME",	request.getParameter("semi_warning_maxtime"));
			dummy = request.getParameter("semi_warning_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("SEMI_WARNING_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("SEMI_WARNING_MAXCOST"	,new String()		);
			}
		
			//***************************************************
			//*レベル３表示
			//***************************************************
			dummy = request.getParameter("warning_kind");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("WARNING_KIND"	,dummy		);
			}else{
				request.setAttribute("WARNING_KIND"	,new String()		);
			}
			request.setAttribute("WARNING_MAXTIME",	request.getParameter("warning_maxtime"));
			dummy = request.getParameter("warning_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("WARNING_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("WARNING_MAXCOST"	,new String()		);
			}
		
			//***************************************************
			//*レベル４表示
			//***************************************************
			dummy = request.getParameter("semi_abnormal_kind");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("SEMI_ABNORMAL_KIND"	,dummy		);
			}else{
				request.setAttribute("SEMI_ABNORMAL_KIND"	,new String()		);
			}
			request.setAttribute("SEMI_ABNORMAL_MAXTIME",	request.getParameter("semi_abnormal_maxtime"));
			dummy = request.getParameter("semi_abnormal_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("SEMI_ABNORMAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("SEMI_ABNORMAL_MAXCOST"	,new String()		);
			}
			//***************************************************
			//*レベル５表示
			//***************************************************
			dummy = request.getParameter("abnormal_kind");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("ABNORMAL_KIND"	,dummy		);
			}else{
				request.setAttribute("ABNORMAL_KIND"	,new String()		);
			}
			request.setAttribute("ABNORMAL_MAXTIME",	request.getParameter("abnormal_maxtime"));
			dummy = request.getParameter("abnormal_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("ABNORMAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("ABNORMAL_MAXCOST"	,new String()		);
			}

			//***************************************************
			//*書き込みコスト
			//***************************************************
			dummy = request.getParameter("write_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("WRITE_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("WRITE_MAXCOST"	,new String()		);
			}
			request.setAttribute("WRITE_MAXTIME"	,request.getParameter("write_maxtime")	);

			//***************************************************
			//*読み込みコスト
			//***************************************************
			dummy = request.getParameter("read_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("READ_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("READ_MAXCOST"	,new String()		);
			}
			request.setAttribute("READ_MAXTIME"	,request.getParameter("read_maxtime")	);
		
			//***************************************************
			//*総コスト（書き込みコスト＋読み込みコスト）
			//***************************************************
			dummy = request.getParameter("real_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("REAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("REAL_MAXCOST"	,new String()		);
			}
			request.setAttribute("REAL_MAXTIME"	,request.getParameter("real_maxtime")	);
		
			//***************************************************
			//*評価された評価額
			//***************************************************
			dummy = request.getParameter("myeval_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("MYEVAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("MYEVAL_MAXCOST"	,new String()		);
			}
			request.setAttribute("MYEVAL_MAXTIME"	,request.getParameter("myeval_maxtime")	);

			//***************************************************
			//*評価した評価額
			//***************************************************
			dummy = request.getParameter("othereval_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("OTHEREVAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("OTHEREVAL_MAXCOST"	,new String()		);
			}
			request.setAttribute("OTHEREVAL_MAXTIME"	,request.getParameter("othereval_maxtime")	);
		
			//***************************************************
			//*貢献コスト
			//***************************************************
			dummy = request.getParameter("cont_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("CONT_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("CONT_MAXCOST"	,new String()		);
			}
			request.setAttribute("CONT_MAXTIME"	,request.getParameter("cont_maxtime")	);

			//***************************************************
			//*貢献後コスト
			//***************************************************
			dummy = request.getParameter("total_maxcost");
			if(dummy != null && dummy.length() > 0){
				request.setAttribute("TOTAL_MAXCOST"	,dummy		);
			}else{
				request.setAttribute("TOTAL_MAXCOST"	,new String()		);
			}
			request.setAttribute("TOTAL_MAXTIME"	,request.getParameter("total_maxtime")	);
		}
	

		//コスト集約自動実行
		if(request.getParameter("autobatch").equals("yes")){
			request.setAttribute("AUTOBATCH",	"yes"	);
		}
		//送信方法
		if(request.getParameter("senddirect").equals("yes")){
			request.setAttribute("SEND_DIRECT",	"yes"	);
		}
		//直接送信オプション
		if(request.getParameter("senddirect_option").equals("yes")){
			request.setAttribute("SEND_DIRECT_OPTION",	"yes"	);
		}
		//直接送信オプション他ノード中継
		if(request.getParameter("senddirect_option_relay").equals("yes")){
			request.setAttribute("SEND_DIRECT_OPTION_RELAY",	"yes"	);
		}
		//直接送信オプションサーバ中継
		if(request.getParameter("senddirect_option_server").equals("yes")){
			request.setAttribute("SEND_DIRECT_OPTION_SERVER",	"yes"	);
		}
		//他ノード中継１
		if(request.getParameter("relay1").equals("yes")){
			request.setAttribute("RELAY1",	"yes"	);
		}

		
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	private void StructUser2Html(Struct_User sui,
			ServletConfig config,
			HttpServletRequest request,
			HttpServletResponse response)
	throws IOException, ServletException{

		DecimalFormat dfw = new DecimalFormat("#0.00");
		request.setAttribute("WORKINGTIME",	dfw.format(sui.getWorking_time())	);
		
		dfw = new DecimalFormat("#0.0000000");
		if(sui.getUnit_cost()>0){
			request.setAttribute("UNITCOST_SECOND",	dfw.format(sui.getUnit_cost())	);
		}else{
			request.setAttribute("UNITCOST_SECOND",	new String());
		}
		
		
		//***************************************************
		//*レベル１表示
		//***************************************************
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("NORMAL_MAXTIME"	,	dfw.format(sui.getNormal_maxtime())	);
		request.setAttribute("NORMAL_KIND"		,	sui.getNormal_kind());
		if(sui.getNormal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("NORMAL_MAXCOST"	,	dfw.format(sui.getNormal_maxcost()));
		}else{
			request.setAttribute("NORMAL_MAXCOST"	,	new String());
		}

		//***************************************************
		//*レベル２表示
		//***************************************************
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("SEMI_WARNING_MAXTIME"	,	dfw.format(sui.getSemi_warning_maxtime())	);
		request.setAttribute("SEMI_WARNING_KIND"	,	sui.getSemi_warning_kind());
		if(sui.getSemi_warning_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("SEMI_WARNING_MAXCOST"	,	dfw.format(sui.getSemi_warning_maxcost()));
		}else{
			request.setAttribute("SEMI_WARNING_MAXCOST"	,	new String());
		}
		
		//***************************************************
		//*レベル３表示
		//***************************************************
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("WARNING_MAXTIME"	,	dfw.format(sui.getWarning_maxtime())	);
		request.setAttribute("WARNING_KIND"		,	sui.getWarning_kind());
		if(sui.getWarning_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("WARNING_MAXCOST"	,	dfw.format(sui.getWarning_maxcost()));
		}else{
			request.setAttribute("WARNING_MAXCOST"	,	new String());
		}
		
		//***************************************************
		//*レベル４表示
		//***************************************************
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("SEMI_ABNORMAL_MAXTIME",	dfw.format(sui.getSemi_abnormal_maxtime())	);
		request.setAttribute("SEMI_ABNORMAL_KIND"	,	sui.getSemi_abnormal_kind());
		if(sui.getSemi_abnormal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("SEMI_ABNORMAL_MAXCOST",	dfw.format(sui.getSemi_abnormal_maxcost()));
		}else{
			request.setAttribute("SEMI_ABNORMAL_MAXCOST",	new String());
		}

		//***************************************************
		//*レベル５表示
		//***************************************************
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("ABNORMAL_MAXTIME"	,	dfw.format(sui.getAbnormal_maxtime())	);
		request.setAttribute("ABNORMAL_KIND"	,	sui.getAbnormal_kind());
		if(sui.getSemi_abnormal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("ABNORMAL_MAXCOST"	,	dfw.format(sui.getAbnormal_maxcost()));
		}else{
			request.setAttribute("ABNORMAL_MAXCOST"	,	new String());
		}

		request.setAttribute("STRD_CHK"	,	sui.isStd_chk());
		request.setAttribute("EVAL_SELECT"	,sui.getEval_rank());

		//***************************************************
		//*書き込みコスト
		//***************************************************
		if(sui.getWrite_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("WRITE_MAXCOST"	,dfw.format(sui.getWrite_maxcost()));
		}else{
			request.setAttribute("WRITE_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("WRITE_MAXTIME"	,dfw.format(sui.getWrite_maxtime()));
		
		//***************************************************
		//*読み込みコスト
		//***************************************************
		if(sui.getWrite_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("READ_MAXCOST"	,dfw.format(sui.getRead_maxcost()));
		}else{
			request.setAttribute("READ_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("READ_MAXTIME"	,dfw.format(sui.getRead_maxtime()));
		
		//***************************************************
		//*総コスト（書き込みコスト＋読み込みコスト）
		//***************************************************
		if(sui.getReal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("REAL_MAXCOST"	,dfw.format(sui.getReal_maxcost()));
		}else{
			request.setAttribute("REAL_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("REAL_MAXTIME"	,dfw.format(sui.getReal_maxtime()));
		
		//***************************************************
		//*評価された評価額
		//***************************************************
		if(sui.getReal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("MYEVAL_MAXCOST"	,dfw.format(sui.getMy_eval_maxcost()));
		}else{
			request.setAttribute("MYEVAL_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("MYEVAL_MAXTIME"	,dfw.format(sui.getMy_eval_maxtime()));

		//***************************************************
		//*評価した評価額
		//***************************************************
		if(sui.getOther_eval_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("OTHEREVAL_MAXCOST"	,dfw.format(sui.getOther_eval_maxcost()));
		}else{
			request.setAttribute("OTHEREVAL_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("OTHEREVAL_MAXTIME"	,dfw.format(sui.getOther_eval_maxtime()));
		
		//***************************************************
		//*貢献コスト
		//***************************************************
		if(sui.getCont_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("CONT_MAXCOST"	,dfw.format(sui.getCont_maxcost()));
		}else{
			request.setAttribute("CONT_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("CONT_MAXTIME"	,dfw.format(sui.getCont_maxtime()));

		//***************************************************
		//*貢献後コスト
		//***************************************************
		if(sui.getTotal_maxcost()>0){
			dfw = new DecimalFormat("#,##0");
			request.setAttribute("TOTAL_MAXCOST"	,dfw.format(sui.getTotal_maxcost()));
		}else{
			request.setAttribute("TOTAL_MAXCOST"	,new String());
		}
		dfw = new DecimalFormat("#0.00");
		request.setAttribute("TOTAL_MAXTIME"	,dfw.format(sui.getTotal_maxtime()));	
		
		
		if(sui.isAutobatch() == true){
			request.setAttribute("AUTOBATCH","on");
		}
		if(sui.isSend_direct() == true){
			request.setAttribute("SEND_DIRECT","on");
		}
		if(sui.isSend_direct_option() == true){
			request.setAttribute("SEND_DIRECT_OPTION","on");
		}
		if(sui.isSend_direct_option_relay() == true){
			request.setAttribute("SEND_DIRECT_OPTION_RELAY"	,"on");
		}
		if(sui.isSend_direct_option_server() == true){
			request.setAttribute("SEND_DIRECT_OPTION_SERVER","on");
		}

		if(sui.getRelay1_node() != null && sui.getRelay1_node().length()>0){
			request.setAttribute("RELAY1"	,	"on");
		}
		
		
	}
	
	
	private double rtnUnitcost(String kind,double time,double unitcost_second,double working_time){
	//コストを計算して返す
	//引数１：単位
	//引数２：入力値
	//引数３：単価／秒
	//引数４：１日の労働時間
		
		double cost = 0;
		if(kind.equals("s")){
			//コスト算出　
			cost = unitcost_second * time * 1;
		}	
		else if(kind.equals("m")){
			cost = unitcost_second * time * 60;
		}	
		else if(kind.equals("h")){
			cost = unitcost_second * time * 60 * 60;
		}	
		else if(kind.equals("d")){
			cost = unitcost_second * time * 60 * 60 *  working_time;
		}	

		BigDecimal bd = new BigDecimal(String.valueOf(cost));
		cost = bd.setScale(0, BigDecimal.ROUND_HALF_UP) .doubleValue();
	
		return cost;
	
	}
	private String double2String_keta0(double number){
		DecimalFormat dfuc = new DecimalFormat("#,##0");
		return dfuc.format(number);
		
	}	

	private String double2String_keta2(double number){
			DecimalFormat dfuc = new DecimalFormat("#0.00");
			return(dfuc.format(number));
			
		}	
	private boolean smallnumberCHK(String string,double minimum,double maximum,byte keta){

		//* 少数桁チェック
		int period = string.indexOf(".");
		if(period > 0){
			if( (string.length() - period -1)  > keta){
				return false;
			}
		}
		
		double dummy;
		
		try {
			dummy = Double.parseDouble(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}

	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{

		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
	
	}

}
