package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;

import structure.Struct_UserPassword;

public class AdminUserPassword_IO implements Serializable{

	private String FilePath;
	private String userid;
	private String password;

	public boolean authenticate(){
		if(userid == null || userid.length() == 0){
			return false;
		}
		if(password == null || password.length() == 0){
			return false;
		}
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		Struct_UserPassword user = new Struct_UserPassword();
		
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			if(userid.equals("admin") &&
					password.equals("adminpw")){
				return true;
			}
			else{
				return false;
			}
		}

		try {
			is  = new FileInputStream(FilePath);
			bis = new BufferedInputStream(is);
			xml = new XMLDecoder(bis);
			
			user =   (Struct_UserPassword) xml.readObject();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
			}
		}
		return true;		
	}
	
	
	
	public boolean save(){
		if(userid == null || userid.length() == 0){
			return false;
		}
		if(password == null || password.length() == 0){
			return false;
		}
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
	
		Struct_UserPassword user = new Struct_UserPassword();
		user.setUserid(userid);
		user.setPassword(password);
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		xml.writeObject(user);
		   		
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			return false;
		} catch (Exception e) {
 	        e.printStackTrace();
			return false;
		}finally{
				try{
					xml.close();
				} catch(Exception e2){
					e2.printStackTrace();
					return false;
				}
		}		
		return true;
			
	}

	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getUserid() {
		return userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}
	
}
