package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import structure.Struct_UnitCost;
import structure.Struct_User;

public class AdminUser_IO {
	private String 		FilePath;
	private Struct_User data;


	
	//ロード
	//1...ロード成功
	//2...ファイルなし
	//3...ロード失敗
	public byte load(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(FilePath);

		//初回は保存データがない
		if(fl.exists()==false){
			return 2;
		}
		

		 try {
			 is = new FileInputStream(FilePath);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			data = (Struct_User) xml.readObject();

			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return 3;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return 3;
			}
		}
		return 1;
	}
	
	//セーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		xml.writeObject(data);
		  
		   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}	

	public void init(){
		data = new Struct_User();
		
		Struct_UnitCost su= new Struct_UnitCost();
		su.setPosition("ＳＥ１");
		su.setUnitcost(800000);
		data.setStruct_unitccost(su);
		
		data.setWorking_time(8.0);				//１日の労働時間少数２桁含む
		data.setNormal_maxtime(10);				//正常最大時間　　秒単位
		data.setSemi_warning_maxtime(1);		//準警告最大時間　秒単位
		data.setWarning_maxtime(1);				//警告最大時間　　秒単位
		data.setSemi_abnormal_maxtime(5);		//準異常最大時間　秒単位
		data.setAbnormal_maxtime(20.42);		//異常最大時間　　秒単位
		data.setNormal_kind("m");
		data.setSemi_warning_kind("h");
		data.setWarning_kind("d");
		data.setSemi_abnormal_kind("d");
		data.setAbnormal_kind("d");
		data.setStd_chk(false);
		data.setEval_rank("2");
		data.setWrite_maxtime(60.0);			//書き込み最大時間
		data.setRead_maxtime(60.0);				//読み取り最大時間
		data.setReal_maxtime(60.0);				//実最大時間
		data.setMy_eval_maxtime(60.0);			//評価された最大時間
		data.setOther_eval_maxtime(60.0);		//評価した最大時間
		data.setCont_maxtime(60.0);				//貢献最大時間
		data.setTotal_maxtime(60.0);			//総合最大時間
		data.setAutobatch(true);				//自動実行
		
		data.setSend_direct(true);					//42.直接送信
		data.setSend_direct_option(false);			//43.直接送信オプション
		data.setSend_direct_option_relay(false);	//44.直接送信オプション他ノード中継
		data.setSend_direct_option_server(false);	//45.直接送信オプションサーバ中継

	}
	
	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}

	
	public Struct_User getData() {
		return data;
	}
	public void setData(Struct_User data) {
		this.data = data;
	}
	
}
