package comon;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community;
import structure.Struct_Community_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminCommunity_IO;
import beansApp.AdminProject_IO;


public class ComonCommunity extends HttpServlet{
	private String urlfoward 		= new String("/servlet/framecomoncommunity");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "コミュニティの登録・変更";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		if(ss.isAdmin() ==true){
			//アドミン権限のユーザーはスルー
		}else{
			//一般ユーザーはアドミンオプションが付与されていること
			if(session.getAttribute("ADMINOPTION") == null){
				request.setAttribute("TITLE",	"メンバーの登録・変更");
				request.setAttribute("MSG", "権限がありません");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		String[] community 		= null;
		
		//***************************************
		//* コミュニティファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityFile");
		AdminCommunity_IO ac = new AdminCommunity_IO();
		ac.setFilePath(filePath);
		byte loadrtn = ac.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList<Struct_Community> alm	= ac.getdata();

			community  		= new String[alm.size()];
			
			for(int i=0;i<alm.size() ; i++){
				community[i]			= alm.get(i).getCommunity();
			}	
			
			request.setAttribute("COMMUNITY"		,	community);
			request.setAttribute("MSG", "コミュニティを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			community  		= new String[5];
			for(int i=0;i<5 ; i++){
				community[i]	= new String();
			}
			
			request.setAttribute("COMMUNITY"		,	community);
			request.setAttribute("MSG", "コミュニティファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
	
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}
		
		
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************************************************
		//* 行削除作成
		//***************************************************************************
		if(request.getParameter("delete") != null){
			String community[] 	=  request.getParameterValues("community");
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows == null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスに１件もチェックがありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			if(delrows.length == community.length){
				dataSet(request);
				request.setAttribute("MSG", "全件削除はできません。１行以上残してください");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			String newnumber[] 	=  request.getParameterValues("newnumber");

			//行削除チェックボックスの復元
			boolean temp_delrows[]	= new boolean[community.length];
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			
			//* 削除後データ域の確保
			int new_line = community.length-delrows.length;
			String new_community[] 		= new String[new_line];
			String new_newnumber[] 		= new String[new_line];
			
			//* 削除後データの作成
			String deldata = new String();
			int datacount = 0;
			for(int i=0;i<community.length;i++){
				if(temp_delrows[i] == false){
					new_community[datacount]	=	community[i];
					new_newnumber[datacount]	=	newnumber[i];

					datacount++;
				}else{
					if(community[i] != null && community[i].length() > 0){
						deldata += community[i]+"<br>";
					}else{
						deldata +="---空行または役割未入力---<br>";
					}
				}
			}
			
			request.setAttribute("COMMUNITY"	,	new_community);
			request.setAttribute("NEWNUMBER"	,	new_newnumber);
			
			request.setAttribute("MSG", delrows.length+
								"件削除しました。削除データは以下のとおりです<br>"+
								deldata+
								"(削除を反映するには、登録・変更が必要です)");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* 空行作成
		//***************************************************************************
		else if(request.getParameter("addrows") != null){
			String community[] 	=  request.getParameterValues("community");
			String newnumber[] 	=  request.getParameterValues("newnumber");
			String delrows[] 	=  request.getParameterValues("delrows");
			
			if(community.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}

			String new_community[] 		= new String[community.length+10];
			String new_newnumber[] 		= new String[community.length+10];
			boolean new_delrows[]		= new boolean[community.length+10];
			for(int i=0;i<community.length+10;i++){
				if(i<community.length){
					new_community[i] 		= community[i];
					new_newnumber[i] 		= newnumber[i];
				}else{
					new_community[i] 		= new String();
					new_newnumber[i] 		= new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}
			
			request.setAttribute("COMMUNITY",	new_community);
			request.setAttribute("NEWNUMBER",	new_newnumber);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("MSG", "空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* ソート
		//***************************************************************************
		else if(request.getParameter("sort") != null){

			String newnumber[] =  request.getParameterValues("newnumber");
			String community[] 	=  request.getParameterValues("community");
			String delrows[] 	=  request.getParameterValues("delrows");
			boolean temp_delrows[]	= new boolean[community.length];

			//行削除チェックボックスに入力がある場合
			if(delrows != null){
				//行削除チェックボックスの復元
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					temp_delrows[line]=true;
				}
			}
			
			boolean isdata = false;
			//******************************************************
			//* データ有無チェック
			//******************************************************
			for(int i=0;i<community.length;i++){
				//******************************************************
				//* コミュニティ　ナル値チェック
				//******************************************************
				if(community[i] != null && community[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			
			boolean sort_submit = false;
			for(int i=0;i<community.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					continue;
				}
				//******************************************************
				//* 新番号　ニューメリックチェック
				//******************************************************
				else if(numericCHK(newnumber[i],1,9999) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の新番号に誤りがあります");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}else{
					sort_submit = true;
				}
			}
			if(sort_submit == false){
				dataSet(request);
				request.setAttribute("MSG", "新番号が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 新番号　作成
			//******************************************************
			double[] sortnumber = new double[community.length];
			for(int i=0;i<community.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					sortnumber[i] = (i+1.99999);
				}
				else{
					double addpoint = 0;
					double tempnumber = Double.valueOf(newnumber[i]).doubleValue();
					for(int j=0; j<i; j++){
						if(sortnumber[j] < tempnumber){
							//*整数桁が小さい場合は無視
						}
						else if(sortnumber[j] >= (tempnumber+0.99999)){
							//*整数桁が大きい場合は無視
						}
						else{
							//*0～0.999999の間
							if( addpoint < (sortnumber[j]-tempnumber) ){
								addpoint = sortnumber[j]-tempnumber;
							}
						}
					}
					sortnumber[i] = tempnumber + addpoint + 0.00001;
				}
			}
			//******************************************************
			//* 新番号　ソード
			//******************************************************
			String new_community[] 		= new String[community.length];
			
			boolean new_delrows[]	= new boolean[community.length];

			for(int i=0;i<community.length;i++){
				double minimum = sortnumber[0];
				int number = 0;
				//最小値を検索する
				for(int j=0; j<community.length; j++){
					if(sortnumber[j] < minimum){
						minimum = sortnumber[j];
						number	= j;
					}
				}
				//************************************
				//* 最小値を代入
				//************************************
				//ユーザーＩＤ
				if(community[number] != null && community[number].length() > 0){
					new_community[i] = community[number];
				}else{
					new_community[i] = new String();
				}
				//行削除
				if(temp_delrows[number] == true){
					new_delrows[i] = true;
				}

				//最小値の抹消
				sortnumber[number] = 99999;
			}
			
			request.setAttribute("COMMUNITY",	new_community);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("MSG", "順番を入れ替えました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
		}
		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){
			
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************************************************
			//* 行削除チェック
			//***************************************************************************
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows != null){
				dataSet(request);
				request.setAttribute("MSG", "行削除チェックボックスにチェックがあります");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//***************************************************************************
			//* 新番号チェック
			//***************************************************************************
			String newnumber[] =  request.getParameterValues("newnumber");
			for(int i=0;i<newnumber.length;i++){
				if(newnumber[i] != null && newnumber[i].length() > 0){
					dataSet(request);
					request.setAttribute("MSG", "新番号が入力されています。番号＝"+(i+1)+"　入力値="+newnumber[i]);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
					
				}
				
			}
			String community[] 	=  request.getParameterValues("community");

			//******************************************************
			//* データ有無チェック
			//******************************************************
			int datacount = 0;
			for(int i=0;i<community.length;i++){
				//******************************************************
				//* コミュニティ　ナル値チェック
				//******************************************************
				if(community[i] != null && community[i].length() > 0){
					datacount++;
				}
			}
			if(datacount == 0){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			//******************************************************
			//* コミュニティ　重複チェック
			//******************************************************
			for(int i=0;i<community.length-1;i++){
				for(int j=i+1; j<community.length;j++){
					if(community[j] == null || community[j].length() == 0){
						//データなし行は無視
						continue;
					}
					else if(community[i].equals(community[j]) == true){
						dataSet(request);
						request.setAttribute("MSG", (i+1)+"番目と"+ (j+1) + "番目のコミュニティが重複しています");
						updatemode(request,scon,session);
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}
				}
			}
			
			//********************************************************
			//* 登録・更新データの準備
			//********************************************************
			int line = 0;
			String new_community[] 		= new String[datacount];
			ArrayList<Struct_Community> newdata = new ArrayList();

			for(int i=0;i<community.length;i++){
				if(community[i] != null && community[i].length() > 0){
					Struct_Community data = new Struct_Community();
					data.setCommunity(community[i]);
					newdata.add(data);
					new_community[line]	= community[i];
					line++;
				}
			}
			
			//********************************************************
			//*コミュニティファイルのアクセス準備
			//********************************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("communityFile");
			AdminCommunity_IO ac = new AdminCommunity_IO();
			ac.setFilePath(filePath);
			ac.putdata(newdata);

			//********************************************************
			//* コミュニティファイルの更新
			//********************************************************
			if(ac.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "コミュニティの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			
			
			//***********************************************
			//* コミュニティメンバーファイルのアクセス準備
			//***********************************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("communityMenberFile");
			AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
			acm.setFilePath(filePath);
			byte loadrtn = acm.load();

			if(loadrtn == (byte)1){
				//* ロード成功
				ArrayList<Struct_Community_Menber> commenData	= acm.getdata();
				
				//存在しないコミュニティは削除する
				for(int i=0;i<commenData.size() ;i++){
					boolean found = false;
					for(int j=0;j<newdata.size() ;j++){
						if(commenData.get(i).getCommunity().equals(newdata.get(j).getCommunity())){
							found = true;
							break;
						}
					}
					if(found == false){
						commenData.remove(i);
						i--;
					}
				}
				acm.putdata(commenData);
				if(acm.save() == false){
					request.setAttribute("TITLE",title);
					request.setAttribute("MSG", "コミュニティメンバーの登録・変更に失敗しました");
					getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
					return;
				}
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
//				request.setAttribute("TITLE",	title);
//				request.setAttribute("MSG", "コミュニティメンバーファイルは未作成です");
//				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
//				return;
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}							
			
			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			request.setAttribute("COMMUNITY",	new_community);
			request.setAttribute("MSG", "コミュニティを登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
	}

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}

	private void dataSet(HttpServletRequest request){
		request.setAttribute("COMMUNITY",	request.getParameterValues("community"));
		
		String delrows[] 	=  request.getParameterValues("delrows");

		//行削除チェックボックスに入力がある場合
		if(delrows != null){
			boolean temp_delrows[]	= new boolean[request.getParameterValues("community").length];

			//行削除チェックボックスの復元
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			request.setAttribute("DELROWS",	temp_delrows);			
		}
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	
	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;
	
	}
	
	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
		
	}
	
	
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}

}
