package comon;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community;
import structure.Struct_Community_Menber;
import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminCommunity_IO;
import beansApp.AdminMenber_IO;
import beansApp.AdminProject_IO;

public class ComonCommunityMenber extends HttpServlet{
	private String urlbackward 	= new String("comoncommunitymenbermenu");
	private String urlfoward 		= new String("/servlet/framecomoncommunitymenber");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");

	private String title = "コミュニティメンバーの登録・変更";
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトファイルの生存チェック
		//***************************************
		if(projectCheck(request,response,scon,session) == false){
			return;
		}

		//***************************************************************************
		//* コミュニティメニュー
		//***************************************************************************
		if(request.getParameter("menu") != null){
			response.sendRedirect(urlbackward);
			return;	
		}

		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){
			//***************************************
			//* 更新モードチェック
			//***************************************
			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			String community 		=  request.getParameter("community");
			String[] userid 		=  request.getParameterValues("userid");
			String[] user_fullname 	=  request.getParameterValues("user_fullname");
			String[] node 			=  request.getParameterValues("node");
			String[] chkrows 		=  request.getParameterValues("chkrows");

			//******************************************************
			//* メンバー　選択チェック
			//******************************************************
			if(chkrows.length < 2){
				dataSet(request,session);
				request.setAttribute("MSG", "コミュニティメンバーは未選択です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			
			//***********************************************
			//* コミュニティメンバーファイルのアクセス準備
			//***********************************************
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("communityMenberFile");
			AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
			acm.setFilePath(filePath);
			byte loadrtn = acm.load();
			ArrayList<Struct_Community_Menber> commenData;
			if(loadrtn == (byte)1){
				//* ロード成功
				commenData	= acm.getdata();
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				commenData	= new ArrayList();
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			
			
			//既存コミュニティのメンバー削除
			if(commenData.size() != 0){
				for(int i=0;i<commenData.size();i++){
					if(commenData.get(i).getCommunity().equals(community)){
						commenData.remove(i);
						i--;
					}
				}
			}
			//データ追加
			for(int i=0;i<chkrows.length;i++){
				int line = Integer.valueOf(chkrows[i]).intValue();
				Struct_Community_Menber scm = new Struct_Community_Menber();
				scm.setCommunity(community);
				scm.setUserid(userid[line]);
				scm.setUser_fullname(user_fullname[line]);
				scm.setNode(node[line]);
				commenData.add(scm);
			}
			
			//コミュニティメンバーをソートする
			commenData = dataSort(request,response,scon,session,commenData);
			if(commenData == null){
				return;
			}
			
			acm.putdata(commenData);
			
			if(acm.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "コミュニティメンバーの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//*****************************************
			//* プロジェクトファイルの日時を更新する
			//*****************************************
			if(projectTimestamp(request,response,scon,session) == false){
				return;
			}
			
			dataSet(request,session);
			request.setAttribute("MSG", "コミュニティメンバーを登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}		
		
	}

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}

	private void dataSet(HttpServletRequest request,HttpSession session){

		request.setAttribute("COMMUNITY"	,	request.getParameter("community"));
		request.setAttribute("USERID"		,	request.getParameterValues("userid"));
		request.setAttribute("USER_FULLNAME",	request.getParameterValues("user_fullname"));
		request.setAttribute("NODE"			,	request.getParameterValues("node"));
		
		
		String[] dummy = request.getParameterValues("userid");
		
		String chkrrows[] 	=  request.getParameterValues("chkrows");
		//行削除チェックボックスに入力がある場合
		if(chkrrows != null){
			boolean temp_chkrrows[]	= new boolean[dummy.length];

			//行削除チェックボックスの復元
			for(int i=0;i<chkrrows.length;i++){
				int line = Integer.valueOf(chkrrows[i]).intValue();
				temp_chkrrows[line]=true;
			}
			request.setAttribute("CHKROWS"	,temp_chkrrows);
		}
	
		//***********************************************
		//* 一般ユーザーの制限
		//***********************************************
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		boolean editrows[] = null;
		if(ss.isAdmin() == false && 
				session.getAttribute("ADMINOPTION") == null){
			editrows = new boolean[dummy.length];
			for(int i=0;i<dummy.length;i++){
				if(ss.getUserid().equals(dummy[i])){
					editrows[i] = true;
				}
			}
		}
		request.setAttribute("EDITROWS"	,	editrows);

	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	
	private boolean projectCheck(HttpServletRequest request,
									HttpServletResponse response,
									ServletContext scon,
									HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		return true;
	
	}
	
	private boolean projectTimestamp(HttpServletRequest request,
										HttpServletResponse response,
										ServletContext scon,
										HttpSession session)
		throws IOException, ServletException{
	
		//****************************
		//* プロジェクトフィアルのアクセス準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
		scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		
		byte loadrtn = ap.load();
		
		if(loadrtn == (byte)1){
		//ロードＯＫ
		}else if(loadrtn == (byte)2){
		//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
		//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}		
		
		if(ap.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトの登録・変更に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		return true;
		
	}
		
	private ArrayList<Struct_Community_Menber> dataSort(HttpServletRequest request,
			HttpServletResponse response,
			ServletContext scon,
			HttpSession session,
			ArrayList<Struct_Community_Menber> commenData)
		throws IOException, ServletException{
		
		//***************************************
		//* コミュニティファイルのアクセス準備
		//***************************************
		AdminCommunity_IO ac = new AdminCommunity_IO();
		ac.setFilePath(scon.getInitParameter("masterDir") +	scon.getInitParameter("communityFile"));
		byte loadrtn = ac.load();
		
		ArrayList<Struct_Community> comdata;
		if(loadrtn == (byte)1){
			//* ロード成功
			comdata	= ac.getdata();
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return null;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return null;
		}	

		//***************************************
		//* メンバーファイルのアクセス準備
		//***************************************
		AdminMenber_IO am = new AdminMenber_IO();
		am.setFilePath(scon.getInitParameter("masterDir") +	scon.getInitParameter("menberFile"));
		loadrtn = am.load();
		
		ArrayList<Struct_Menber> mendata;
		if(loadrtn == (byte)1){
			//* ロード成功
			mendata	= am.getdata();

		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return null;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return null;
		}	
		
		
		ArrayList<Struct_Community_Menber> sortdata = new ArrayList();
		boolean projectfound;
		//コミュニティのループ
		for(int i=0;i<comdata.size();i++){
			projectfound = false;
			for(int k=0;k<commenData.size();k++){
				if(commenData.get(k).getCommunity().equals(comdata.get(i).getCommunity()) &&
				commenData.get(k).getUserid().equals("allmenber")){
					//コミュニティ一斉送信を格納
					sortdata.add(commenData.get(k));
					projectfound = true;
					break;
				}
			}
			
			//プロジェクトがコミュニティメンバーにない場合はスキップ
			if(projectfound == false){
				continue;
			}
			
			//メンバーのループ
			for(int j=0;j<mendata.size();j++){
				//コミュニティとメンバーの検索
				for(int k=0;k<commenData.size();k++){
					if(commenData.get(k).getCommunity().equals(comdata.get(i).getCommunity()) &&
					commenData.get(k).getUserid().equals(mendata.get(j).getUserid())){
						//発見した場合は格納
						sortdata.add(commenData.get(k));
						break;
					}
				}
			}
			
			
		}
		
		return sortdata;
		
	}
	
}
