package comon;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community_Menber;
import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminMenber_IO;

public class ComonCommunityMenberView extends HttpServlet{
	private String urlbackward 	= new String("/servlet/framecomoncommunitymenbermenu");
	private String urlfoward 		= new String("/servlet/framecomoncommunitymenber");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "コミュニティメンバーの登録・変更";
	

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		
		String select 	=  request.getParameter("select");
		if(select == null){
			dataSet(request);
			request.setAttribute("MSG", "選択がありません");
			getServletContext().getRequestDispatcher(urlbackward).forward(request, response);			
			return;				
		}

		ArrayList<Struct_Menber> menberData = null;
		//***************************************
		//* メンバーファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("menberFile");
		AdminMenber_IO am = new AdminMenber_IO();
		am.setFilePath(filePath);
		byte loadrtn = am.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			menberData	= am.getdata();

			//一斉送信追加
			Struct_Menber stm = new Struct_Menber();
			stm.setUserid("allmenber");
			stm.setUser_fullname("コミュニティメンバー");
			stm.setNode(new String());
			menberData.add(0, stm);

		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			
		
		
		//***********************************************
		//* コミュニティメンバーファイルのアクセス準備
		//***********************************************
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("communityMenberFile");
		AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
		acm.setFilePath(filePath);
		loadrtn = acm.load();

		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList<Struct_Community_Menber> commenData	= acm.getdata(select);
			
			String[] userid 		= new String[menberData.size()];
			String[] user_fullname	= new String[menberData.size()];
			String[] node			= new String[menberData.size()];
			
			boolean[] chkrows = new boolean[menberData.size()];
			chkrows[0] = true;//一斉送信
			for(int i=0 ; i<menberData.size() ;i++){
				
				userid[i] 		= menberData.get(i).getUserid();
				user_fullname[i]= menberData.get(i).getUser_fullname();
				node[i] 		= menberData.get(i).getNode();        	  

				if(i>0 && commenData != null && commenData.size() > 0){
					//既存メンバーの復元
					for(int j=0 ; j<commenData.size() ;j++){
						if(menberData.get(i).getUserid().equals(commenData.get(j).getUserid())){
							chkrows[i] = true;
							break;
						}
					}
				}
			}

			//***********************************************
			//* 一般ユーザーの制限
			//***********************************************
			boolean editrows[] = null;
			if(ss.isAdmin() == false && 
					session.getAttribute("ADMINOPTION") == null){
				editrows = new boolean[menberData.size()];
				for(int i=0;i<menberData.size();i++){
					if(ss.getUserid().equals(menberData.get(i).getUserid())){
						editrows[i] = true;
					}
				}
			}

			request.setAttribute("EDITROWS"	,	editrows);
			request.setAttribute("COMMUNITY"	,	select);
			request.setAttribute("USERID"		,	userid);
			request.setAttribute("USER_FULLNAME",	user_fullname);
			request.setAttribute("NODE"			,	node);
			request.setAttribute("CHKROWS"		,	chkrows);
			
			request.setAttribute("MSG", "コミュニティメンバーファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし

			String[] userid 		= new String[menberData.size()];
			String[] user_fullname	= new String[menberData.size()];
			String[] node			= new String[menberData.size()];
			
			boolean[] chkrows = new boolean[menberData.size()];
			chkrows[0] = true;//一斉送信
			for(int i=0 ; i<menberData.size() ;i++){
				userid[i] 		= menberData.get(i).getUserid();
				user_fullname[i]=menberData.get(i).getUser_fullname();
				node[i] 		=     menberData.get(i).getNode();        	  
			}

			//***********************************************
			//* 一般ユーザーの制限
			//***********************************************
			boolean editrows[] = null;
			if(ss.isAdmin() == false && 
					session.getAttribute("ADMINOPTION") == null){
				editrows = new boolean[menberData.size()];
				for(int i=0;i<menberData.size();i++){
					if(ss.getUserid().equals(menberData.get(i).getUserid())){
						editrows[i] = true;
					}
				}
			}

			request.setAttribute("EDITROWS"	,	editrows);
			
			request.setAttribute("COMMUNITY"	,	select);
			request.setAttribute("USERID"		,	userid);
			request.setAttribute("USER_FULLNAME",	user_fullname);
			request.setAttribute("NODE"			,	node);
			request.setAttribute("CHKROWS"		,	chkrows);			
			request.setAttribute("MSG", "コミュニティメンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
	}
	

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}
	
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("COMMUNITY",	request.getParameterValues("community"));
		String select[] 	=  request.getParameterValues("select");

		//選択チェックボックスに入力がある場合
		if(select != null){
			boolean temp_select[]	= new boolean[request.getParameterValues("community").length];

			//選択チェックボックスの復元
			for(int i=0;i<select.length;i++){
				int line = Integer.valueOf(select[i]).intValue();
				temp_select[line]=true;
			}
			request.setAttribute("SELECT",	temp_select);			
		}
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
}
