package comon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community_Menber;
import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminMenber_IO;

public class ComonMenber extends HttpServlet{
	private String urlfoward 		= new String("/servlet/framecomonmenber");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "メンバーの登録・変更";

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		if(ss.isAdmin() ==true){
			//アドミン権限のユーザーはスルー
		}else{
			//一般ユーザーはアドミンオプションが付与されていること
			if(session.getAttribute("ADMINOPTION") == null){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "権限がありません");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
		}
		
		String[] userid 		= null;
		String[] user_fullname	= null;
		String[] node			= null;
		boolean[] adminoptionrows	= null;
		
		//***************************************
		//* メンバーファイルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("menberFile");
		AdminMenber_IO am = new AdminMenber_IO();
		am.setFilePath(filePath);
		byte loadrtn = am.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList<Struct_Menber> alm	= am.getdata();

			userid  		= new String[alm.size()];
			user_fullname  	= new String[alm.size()];
			node  			= new String[alm.size()];
			adminoptionrows	= new boolean[alm.size()];
			
			for(int i=0;i<alm.size() ; i++){
				userid[i]			= alm.get(i).getUserid();
				user_fullname[i]	= alm.get(i).getUser_fullname();
				node[i]				= alm.get(i).getNode();
				adminoptionrows[i]	= alm.get(i).isAdminoption();
			}	

			request.setAttribute("USERID"		,	userid);
			request.setAttribute("USER_FULLNAME",	user_fullname);
			request.setAttribute("NODE"			,	node);
			request.setAttribute("ADMINOPTIONROWS"	,adminoptionrows);
			
			request.setAttribute("MSG", "メンバーファイルを表示しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			userid  		= new String[5];
			user_fullname  	= new String[5];
			node  			= new String[5];
			for(int i=0;i<5 ; i++){
				userid[i] 			= new String();
				user_fullname[i]  	= new String();
				node[i]  			= new String();
			}
			
			request.setAttribute("USERID"		,	userid);
			request.setAttribute("USER_FULLNAME",	user_fullname);
			request.setAttribute("NODE"			,	node);
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",title);
			request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
	
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}
		
		//***************************************************************************
		//* 削除作成
		//***************************************************************************
		if(request.getParameter("delete") != null){
			String userid[] 	=  request.getParameterValues("userid");
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows == null){
				dataSet(request);
				request.setAttribute("MSG", "削除チェックボックスに１件もチェックがありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}

			if(delrows.length == userid.length){
				dataSet(request);
				request.setAttribute("MSG", "全件削除はできません。１行以上残してください");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			String user_fullname[] 	=  request.getParameterValues("user_fullname");
			String node[] 	=  request.getParameterValues("node");
			String newnumber[] 	=  request.getParameterValues("newnumber");

			//行削除チェックボックスの復元
			boolean temp_delrows[]	= new boolean[userid.length];
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
				
			}

			//アドミンオプションチェックボックスの復元
			String adminoptionrows[] 	=  request.getParameterValues("adminoptionrows");
			boolean temp_adminoptionrows[] = null;
			if(adminoptionrows != null){
				temp_adminoptionrows	= new boolean[userid.length];
				for(int i=0;i<adminoptionrows.length;i++){
					int line = Integer.valueOf(adminoptionrows[i]).intValue();
					temp_adminoptionrows[line]=true;
				}
			}
			
			//* 削除後データ域の確保
			int new_line = userid.length-delrows.length;
			String new_userid[] 			= new String[new_line];
			String new_user_fullname[] 		= new String[new_line];
			String new_node[] 				= new String[new_line];
			String new_newnumber[] 			= new String[new_line];
			boolean new_adminoptionrows[] 	= new boolean[new_line];
			
			//* 削除後データの作成
			String deldata = new String();
			int datacount = 0;
			for(int i=0;i<userid.length;i++){
				if(temp_delrows[i] == false){
					new_userid[datacount]			=	userid[i];
					new_user_fullname[datacount]	=	user_fullname[i];
					new_node[datacount]				=	node[i];
					new_newnumber[datacount]		=	newnumber[i];

					//アドミンオプション
					if(temp_adminoptionrows != null &&
							temp_adminoptionrows[i] == true){
						new_adminoptionrows[datacount] = true;
					}
					
					datacount++;
				}else{
					if(userid[i] != null && userid[i].length() > 0){
						deldata += userid[i]+"<br>";
					}else{
						deldata +="---空行または役割未入力---<br>";
					}
				}
			}
			
			request.setAttribute("USERID"			,	new_userid);
			request.setAttribute("USER_FULLNAME"	,	new_user_fullname);
			request.setAttribute("NODE"				,	new_node);
			request.setAttribute("NEWNUMBER"		,	new_newnumber);
			request.setAttribute("ADMINOPTIONROWS"	,	new_adminoptionrows);
			
			request.setAttribute("MSG", delrows.length+
								"件削除しました。削除データは以下のとおりです<br>"+
								deldata+
								"(削除を反映するには、登録・変更が必要です)");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* 空行作成
		//***************************************************************************
		else if(request.getParameter("addrows") != null){
			String userid[] 		=  request.getParameterValues("userid");
			String user_fullname[] 	=  request.getParameterValues("user_fullname");
			String node[] 			=  request.getParameterValues("node");
			String newnumber[] 		=  request.getParameterValues("newnumber");
			String delrows[] 		=  request.getParameterValues("delrows");
			String adminoptionrows[]=  request.getParameterValues("adminoptionrows");
			
			if(userid.length > 9990 ){
				request.setAttribute("MSG", "番号はＭＡＸ９９９９件です");
				dataSet(request);
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;	
			}

			String new_userid[] 			= new String[userid.length+10];
			String new_user_fullname[] 		= new String[userid.length+10];
			String new_node[] 				= new String[userid.length+10];
			String new_newnumber[] 			= new String[userid.length+10];
			boolean new_delrows[]			= new boolean[userid.length+10];
			boolean new_adminoptionrows[]	= new boolean[userid.length+10];
			for(int i=0;i<userid.length+10;i++){
				if(i<userid.length){
					new_userid[i] 			= userid[i];
					new_user_fullname[i] 	= user_fullname[i];
					new_node[i] 			= node[i];
					new_newnumber[i] 		= newnumber[i];
				}else{
					new_userid[i] 			= new String();
					new_user_fullname[i] 	= new String();
					new_node[i] 			= new String();
					new_newnumber[i] 		= new String();
				}
			}

			//行削除チェックボックスの復元
			if(delrows != null){
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					new_delrows[line]=true;
				}
			}

			//オプションチェックボックスの復元
			if(adminoptionrows != null){
				for(int i=0;i<adminoptionrows.length;i++){
					int line = Integer.valueOf(adminoptionrows[i]).intValue();
					new_adminoptionrows[line]=true;
				}
			}
			
			
			request.setAttribute("USERID"			,	new_userid);
			request.setAttribute("USER_FULLNAME"	,	new_user_fullname);
			request.setAttribute("NODE"				,	new_node);
			request.setAttribute("NEWNUMBER"		,	new_newnumber);
			request.setAttribute("DELROWS"			,	new_delrows);
			request.setAttribute("ADMINOPTIONROWS"	,	new_adminoptionrows);
			request.setAttribute("MSG", "空行を１０件増やしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
			
		}
		//***************************************************************************
		//* ソート
		//***************************************************************************
		else if(request.getParameter("sort") != null){

			String newnumber[] =  request.getParameterValues("newnumber");

			String userid[] 		=  request.getParameterValues("userid");
			String user_fullname[] 	=  request.getParameterValues("user_fullname");
			String node[] 			=  request.getParameterValues("node");

			String delrows[] 	=  request.getParameterValues("delrows");
			boolean temp_delrows[]	= new boolean[userid.length];

			//行削除チェックボックスに入力がある場合
			if(delrows != null){
				//行削除チェックボックスの復元
				for(int i=0;i<delrows.length;i++){
					int line = Integer.valueOf(delrows[i]).intValue();
					temp_delrows[line]=true;
				}
			}

			String adminoptionrows[] 	=  request.getParameterValues("adminoptionrows");
			boolean temp_adminoptionrows[]	= new boolean[userid.length];

			//アドミンオプションチェックボックスに入力がある場合
			if(adminoptionrows != null){
				//アドミンオプションチェックボックスの復元
				for(int i=0;i<adminoptionrows.length;i++){
					int line = Integer.valueOf(adminoptionrows[i]).intValue();
					temp_adminoptionrows[line]=true;
				}
			}
			
			
			boolean isdata = false;
			//******************************************************
			//* データ有無チェック
			//******************************************************
			for(int i=0;i<userid.length;i++){
				//******************************************************
				//* ユーザーＩＤ　ナル値チェック
				//******************************************************
				if(userid[i] != null && userid[i].length() > 0){
					isdata = true;
					break;
				}
				//******************************************************
				//* ユーザー名称　ナル値チェック
				//******************************************************
				if(user_fullname[i] != null && user_fullname[i].length() > 0){
					isdata = true;
					break;
				}
				//******************************************************
				//* ノード　ナル値チェック
				//******************************************************
				if(node[i] != null && node[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			
			boolean sort_submit = false;
			for(int i=0;i<userid.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					continue;
				}
				//******************************************************
				//* 新番号　ニューメリックチェック
				//******************************************************
				else if(numericCHK(newnumber[i],1,9999) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目の新番号に誤りがあります");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}else{
					sort_submit = true;
				}
			}
			if(sort_submit == false){
				dataSet(request);
				request.setAttribute("MSG", "新番号が未入力です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 新番号　作成
			//******************************************************
			double[] sortnumber = new double[userid.length];
			for(int i=0;i<userid.length;i++){
				if(newnumber[i] == null || newnumber[i].length() == 0){
					sortnumber[i] = (i+1.99999);
				}
				else{
					double addpoint = 0;
					double tempnumber = Double.valueOf(newnumber[i]).doubleValue();
					for(int j=0; j<i; j++){
						if(sortnumber[j] < tempnumber){
							//*整数桁が小さい場合は無視
						}
						else if(sortnumber[j] >= (tempnumber+0.99999)){
							//*整数桁が大きい場合は無視
						}
						else{
							//*0～0.999999の間
							if( addpoint < (sortnumber[j]-tempnumber) ){
								addpoint = sortnumber[j]-tempnumber;
							}
						}
					}
					sortnumber[i] = tempnumber + addpoint + 0.00001;
				}
			}
			//******************************************************
			//* 新番号　ソード
			//******************************************************
			String new_userid[] 		= new String[userid.length];
			String new_user_fullname[] 	= new String[userid.length];
			String new_node[] 			= new String[userid.length];
			
			boolean new_delrows[]			= new boolean[userid.length];
			boolean new_adminoptionrows[]	= new boolean[userid.length];

			for(int i=0;i<userid.length;i++){
				double minimum = sortnumber[0];
				int number = 0;
				//最小値を検索する
				for(int j=0; j<userid.length; j++){
					if(sortnumber[j] < minimum){
						minimum = sortnumber[j];
						number	= j;
					}
				}
				//************************************
				//* 最小値を代入
				//************************************
				//ユーザーＩＤ
				if(userid[number] != null && userid[number].length() > 0){
					new_userid[i] = userid[number];
				}else{
					new_userid[i] = new String();
				}
				//ユーザー名称
				if(user_fullname[number] != null && user_fullname[number].length() > 0){
					new_user_fullname[i]	= user_fullname[number];
				}else{
					new_user_fullname[i] = new String();
				}
				//ノード
				if(node[number] != null && node[number].length() > 0){
					new_node[i] = node[number];
				}else{
					new_node[i] = new String();
				}
				//行削除
				if(temp_delrows[number] == true){
					new_delrows[i] = true;
				}

				//アドミンオプション
				if(temp_adminoptionrows[number] == true){
					new_adminoptionrows[i] = true;
				}

				//最小値の抹消
				sortnumber[number] = 99999;
			}
			
			request.setAttribute("USERID"			,	new_userid);
			request.setAttribute("USER_FULLNAME"	,	new_user_fullname);
			request.setAttribute("NODE"				,	new_node);
			request.setAttribute("DELROWS",	new_delrows);
			request.setAttribute("ADMINOPTIONROWS",	new_adminoptionrows);
			request.setAttribute("MSG", "順番を入れ替えました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;	
		}
		//***************************************************************************
		//* 登録・更新
		//***************************************************************************
		else if(request.getParameter("execute") != null){

			String updateprm = (String) scon.getAttribute("UPDATEMODE");
			if(updateprm == null || 
				updateprm.equals(session.getId()) == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
											"更新モードの切り替えが必要です"	);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************************************************
			//* 削除チェック
			//***************************************************************************
			String delrows[] 	=  request.getParameterValues("delrows");
			if(delrows != null){
				dataSet(request);
				request.setAttribute("MSG", "削除チェックボックスにチェックがあります");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//***************************************************************************
			//* 新番号チェック
			//***************************************************************************
			String newnumber[] =  request.getParameterValues("newnumber");
			for(int i=0;i<newnumber.length;i++){
				if(newnumber[i] != null && newnumber[i].length() > 0){
					dataSet(request);
					request.setAttribute("MSG", "新番号が入力されています。番号＝"+(i+1)+"　入力値="+newnumber[i]);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
					
				}
				
			}

			String userid[] 		=  request.getParameterValues("userid");
			String user_fullname[] 	=  request.getParameterValues("user_fullname");
			String node[] 			=  request.getParameterValues("node");

			//******************************************************
			//* データ有無チェック
			//******************************************************
			boolean isdata = false;
			for(int i=0;i<userid.length;i++){
				//******************************************************
				//* ユーザーＩＤ　ナル値チェック
				//******************************************************
				if(userid[i] != null && userid[i].length() > 0){
					isdata = true;
					break;
				}
				//******************************************************
				//* ユーザ名称　ナル値チェック
				//******************************************************
				if(user_fullname[i] != null && user_fullname[i].length() > 0){
					isdata = true;
					break;
				}
				//******************************************************
				//* ノード　ナル値チェック
				//******************************************************
				if(node[i] != null && node[i].length() > 0){
					isdata = true;
					break;
				}
			}
			if(isdata == false){
				dataSet(request);
				request.setAttribute("MSG", "入力が１件もありません");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;				
			}
			
			//******************************************************
			//* 未入力チェック
			//******************************************************
			int datacount = 0;
			for(int i=0;i<userid.length;i++){
				boolean useriddata = false;
				if(userid[i] != null && userid[i].length() > 0){
					useriddata = true;
				}
				boolean user_fullnamedata = false;
				if(user_fullname[i] != null && user_fullname[i].length() > 0){
					user_fullnamedata = true;
				}
				boolean nodedata = false;
				if(node[i] != null && node[i].length() > 0){
					nodedata = true;
				}
				
				if(useriddata == false && 
					user_fullnamedata == false &&
					nodedata == false){
					continue;
				}
				else if(useriddata == false || 
						user_fullnamedata == false ||
						nodedata == false){
					String msg = new String();
					msg=(i+1)+"番目の";
					if(useriddata == false){
						msg += "[ＩＤ]";
					}
					if(user_fullnamedata == false){
						msg += "[名称]";
					}
					if(nodedata == false){
						msg += "[ノード]";
					}
					msg += "が未入力です";
					dataSet(request);
					request.setAttribute("MSG", msg);
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;				
				}
				datacount++;
			}
			
			//******************************************************
			//* ノード　フォーマットチェック
			//******************************************************
			for(int i=0;i<userid.length;i++){
				if(node[i] == null || node[i].length() == 0){
					//データなし行は無視
					continue;
				}
				else if(ipAddressCHK(node[i]) == false){
					dataSet(request);
					request.setAttribute("MSG", (i+1)+"番目のＩＰアドレスに誤りがあります<br>入力フォーマットは、xxx.xxx.xxx.xxxです");
					updatemode(request,scon,session);
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
			}

			//******************************************************
			//* ユーザーＩＤ　重複チェック
			//******************************************************
			for(int i=0;i<userid.length-1;i++){
				for(int j=i+1; j<userid.length;j++){
					if(userid[j] == null || userid[j].length() == 0){
						//データなし行は無視
						continue;
					}
					else if(userid[i].equals(userid[j]) == true){
						dataSet(request);
						request.setAttribute("MSG", (i+1)+"番目と"+ (j+1) + "番目のユーザーＩＤが重複しています");
						updatemode(request,scon,session);
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}
				}
			}
			//******************************************************
			//* ノード　重複チェック
			//******************************************************
			String[] nodechk = new String[userid.length];
			for(int i=0;i<userid.length;i++){
				nodechk[i] = ipAddressZeroRemove(node[i]);
			}
			for(int i=0;i<userid.length-1;i++){
				for(int j=i+1; j<userid.length;j++){
					if(nodechk[j] == null || nodechk[j].length() == 0){
						//データなし行は無視
						continue;
					}
					else if(nodechk[i].equals(nodechk[j]) == true){
						dataSet(request);
						request.setAttribute("MSG", (i+1)+"番目と"+ (j+1) + "番目のノードが重複しています");
						updatemode(request,scon,session);
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}
				}
			}
			
			
			//********************************************************
			//* アドミンオプションチェックボックスの復元
			//********************************************************
			String adminoptionrows[] 	=  request.getParameterValues("adminoptionrows");
			boolean temp_adminoptionrows[]	= new boolean[userid.length];

			//アドミンオプションチェックボックスに入力がある場合
			if(adminoptionrows != null){
				//アドミンオプションチェックボックスの復元
				for(int i=0;i<adminoptionrows.length;i++){
					int linex = Integer.valueOf(adminoptionrows[i]).intValue();
					temp_adminoptionrows[linex]=true;
				}
			}

			//********************************************************
			//*メンバーファイルのアクセス＆ロード			
			//********************************************************
			ArrayList<Struct_Menber> oldalm;
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("menberFile");
			AdminMenber_IO am = new AdminMenber_IO();
			am.setFilePath(filePath);
			byte loadrtn = am.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				oldalm	= am.getdata();

			}else if(loadrtn == (byte)2){
				//* ファイルなし
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "メンバーファイルは未作成です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}	
			
			
			//********************************************************
			//* 登録・更新データの準備
			//********************************************************
			int line = 0;
			String new_userid[] 			= new String[datacount];
			String new_user_fullname[] 		= new String[datacount];
			String new_node[] 				= new String[datacount];
			String new_password[] 			= new String[datacount];
			boolean new_adminoptionrows[]	= new boolean[datacount];
			
			ArrayList<Struct_Menber> newdata = new ArrayList();

			
			boolean found;
			for(int i=0;i<userid.length;i++){
				if(userid[i] != null && userid[i].length() > 0){
					//メンバーファイル書き出しデータ
					Struct_Menber data = new Struct_Menber();
					data.setUserid(userid[i]);
					data.setUser_fullname(user_fullname[i]);
					data.setNode(node[i]);

					//パスワードの乗せ替え
					found = false;
					for(int j=0;j<oldalm.size();j++){
						if(userid[i].equals(oldalm.get(j).getUserid())){
							data.setPassword(oldalm.get(j).getPassword());
							found = true;
							break;
						}
					}
					if(found == false){
						data.setPassword(new String());
					}

					data.setAdminoption(temp_adminoptionrows[i]);
					newdata.add(data);

					//画面新データ
					new_userid[line] 		= userid[i];
					new_user_fullname[line] = user_fullname[i];
					new_node[line]			= node[i];
					new_adminoptionrows[line] = temp_adminoptionrows[i];
					line++;
				}
			}
			
			//***********************************************
			//* コミュニティメンバーファイルのアクセス準備
			//***********************************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("communityMenberFile");
			AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
			acm.setFilePath(filePath);
			loadrtn = acm.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				//***********************************************
				//* コミュニティメンバの選択排除チェック
				//***********************************************
				ArrayList<Struct_Community_Menber> dummy;
				for(int i=0;i<oldalm.size();i++){
					//変更前データから削除したデータを取得
					found = false;
					for(int j=0;j<newdata.size();j++){
						if(oldalm.get(i).getUserid().equals(newdata.get(j).getUserid())){
							found = true;
							break;
						}
					}
					//コミュニティメンバーチェック
					if(found == false){
						dummy = acm.getCommunity(oldalm.get(i).getUserid());
						if(dummy != null && dummy.size() > 0){
							dataSet(request);
							String addmsg = new String();
							for(int j=0;j<dummy.size();j++){
								if(j==0){
									addmsg = dummy.get(j).getCommunity();
								}else{
									addmsg += ","+dummy.get(j).getCommunity();
								}
							}
							
							request.setAttribute("MSG", "このユーザーはコミュニティメンバーに登録されています<br>"+
														"削除するにはコミュニティメンバーから選択を取り除いてください<br>"+
													"ユーザーＩＤ＝"+oldalm.get(i).getUserid()+"<br>"+
													"コミュニティ＝"+addmsg);
							updatemode(request,scon,session);
							getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
							return;
							
						}
						
					}
				}

				
				//***********************************************
				//* コミュニティメンバーの更新
				//***********************************************
				
				ArrayList<Struct_Community_Menber> commenData= acm.getdata();
				found = false;
				for(int i=0;i<commenData.size();i++){
					for(int j=0;j<newdata.size();j++){
						if(newdata.get(j).getUserid().equals(commenData.get(i).getUserid()) ){
							//名称変更
							if(newdata.get(j).getUser_fullname().equals(commenData.get(i).getUser_fullname()) == false){
								found = true;
								commenData.get(i).setUser_fullname(newdata.get(j).getUser_fullname());
							}
							//ノード変更
							if(newdata.get(j).getNode().equals(commenData.get(i).getNode()) == false){
								found = true;
								commenData.get(i).setNode(newdata.get(j).getNode());
							}
							break;
						}
					}
				}
				//ノードと名称に差異がある場合は更新
				if(found = true){
					if(acm.save() == false){
						request.setAttribute("TITLE",	title);
						request.setAttribute("MSG", "コミュニティメンバーの登録・変更に失敗しました");
						getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
						return;
					}
				}
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}			
			
			
			
			//********************************************************
			//* メンバーファイルファイルの更新
			//********************************************************
			filePath = scon.getInitParameter("masterDir") +
			scon.getInitParameter("menberFile");
			am.putdata(newdata);
			if(am.save() == false){
				request.setAttribute("TITLE",title);
				request.setAttribute("MSG", "メンバーの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;

			}			
			
			request.setAttribute("USERID"			,	new_userid);
			request.setAttribute("USER_FULLNAME"	,	new_user_fullname);
			request.setAttribute("NODE"				,	new_node);
			request.setAttribute("ADMINOPTIONROWS",	new_adminoptionrows);
			request.setAttribute("MSG", "メンバーを登録・変更しました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		
	}

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}

	private void dataSet(HttpServletRequest request){
		request.setAttribute("NEWNUMBER",	request.getParameterValues("newnumber"));
		request.setAttribute("USERID",	request.getParameterValues("userid"));
		request.setAttribute("USER_FULLNAME",	request.getParameterValues("user_fullname"));
		request.setAttribute("NODE",	request.getParameterValues("node"));
		
		String delrows[] 	=  request.getParameterValues("delrows");

		//行削除チェックボックスに入力がある場合
		if(delrows != null){
			boolean temp_delrows[]	= new boolean[request.getParameterValues("userid").length];

			//行削除チェックボックスの復元
			for(int i=0;i<delrows.length;i++){
				int line = Integer.valueOf(delrows[i]).intValue();
				temp_delrows[line]=true;
			}
			request.setAttribute("DELROWS",	temp_delrows);			
		}

		String adminoptionrows[] 	=  request.getParameterValues("adminoptionrows");
		//アドミンオプションチェックボックスに入力がある場合
		if(adminoptionrows != null){
			boolean temp_adminoptionrows[]	= new boolean[request.getParameterValues("userid").length];

			//アドミンオプションチェックボックスの復元
			for(int i=0;i<adminoptionrows.length;i++){
				int line = Integer.valueOf(adminoptionrows[i]).intValue();
				temp_adminoptionrows[line]=true;
			}
			request.setAttribute("ADMINOPTIONROWS",	temp_adminoptionrows);			
		}
	
	}

	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
	private boolean numericCHK(String string,int minimum,int maximum){
		
		int dummy;
		try {
			dummy = Integer.parseInt(string);
		} catch (NumberFormatException e) {
			return false;
		}	

		if(dummy < minimum){
			return false;
		}
		
		if(dummy > maximum){
			return false;
		}
		
		return true;
	}

	private boolean ipAddressCHK(String ip_address){
		 StringTokenizer st = new StringTokenizer(ip_address, ".");
		    StringBuffer sb = new StringBuffer();
		    if(st.countTokens()!= 4){
	            return false;
		    }
		    for(int i=0;i<4;i++){
		        // "192.168.0.1"をコンマ区切りにし、各数値ごとに２進変換する
		        int ipnum = new Integer(st.nextToken()).intValue();
		        if(ipnum>=0&&ipnum<=255){
		        }else{
		            return false;
		        }
		    }
		return true;
	}
	private String ipAddressZeroRemove(String ip_address){
		if(ip_address == null || ip_address.length() == 0){
			return new String();
		}
		StringTokenizer st = new StringTokenizer(ip_address, ".");
		    StringBuffer sb = new StringBuffer();
		    int[] dotaddress = new int[4];
		    for(int i=0;i<4;i++){
		        // "192.168.0.1"をコンマ区切りにし、各数値ごとに２進変換する
		        dotaddress[i] = new Integer(st.nextToken()).intValue();
		    }
		    String answer= String.valueOf(dotaddress[0]) + "." +
		    			String.valueOf(dotaddress[1]) + "." +
		    			String.valueOf(dotaddress[2]) + "." +
		    			String.valueOf(dotaddress[3]) ;
		    return answer;
	}


}
